<?php // phpcs:ignoreFile
namespace Phan\Language\Internal;

/**
 * This contains descriptions used by Phan for hover text of internal constants (global and class constants) in the language server mode.
 *
 * Format
 *
 * '<constant_name>' => 'documentation',
 *
 * NOTE: This format will very likely change as information is added and should not be used directly.
 *
 * Sources of function/method summary info:
 *
 * 1. docs.php.net's SVN repo or website, and examples (See internal/internalsignatures.php)
 *
 *    See https://secure.php.net/manual/en/copyright.php
 *
 *    The PHP manual text and comments are covered by the [Creative Commons Attribution 3.0 License](http://creativecommons.org/licenses/by/3.0/legalcode),
 *    copyright (c) the PHP Documentation Group
 * 2. Various websites documenting individual extensions (e.g. php-ast)
 * 3. PHPStorm stubs (for anything missing from the above sources)
 *    See internal/internalsignatures.php
 *
 *    Available from https://github.com/JetBrains/phpstorm-stubs under the [Apache 2 license](https://www.apache.org/licenses/LICENSE-2.0)
 *
 *
 * CONTRIBUTING:
 *
 * Running `internal/internalstubs.php` can be used to update signature maps
 *
 * There are no plans for these signatures to diverge from what the above upstream sources contain.
 *
 * - If the descriptions cause Phan to crash, bug reports are welcome
 * - If Phan improperly extracted text from a summary (and this affects multiple signatures), patches fixing the extraction will be accepted.
 * - Otherwise, fixes for typos/grammar/inaccuracies in the summary will only be accepted once they are contributed upstream and can be regenerated (e.g. to the svn repo for docs.php.net).
 *
 *   Note that the summaries are used in a wide variety of contexts, and what makes sense for Phan may not make sense for those projects, and vice versa.
 */
return [
'__COMPILER_HALT_OFFSET__' => 'Available since PHP 5.1.0',
'AF_INET6' => 'Only available if compiled with IPv6 support.',
'AL_BITS' => 'Buffer Setting',
'AL_BUFFER' => 'Source/Listener Setting (Integer)',
'AL_CHANNELS' => 'Buffer Setting',
'AL_CONE_INNER_ANGLE' => 'Source/Listener Setting (Float)',
'AL_CONE_OUTER_ANGLE' => 'Source/Listener Setting (Float)',
'AL_CONE_OUTER_GAIN' => 'Source/Listener Setting (Float)',
'AL_DIRECTION' => 'Source/Listener Setting (Float Vector)',
'AL_FALSE' => 'Boolean value recognized by OpenAL',
'AL_FORMAT_MONO16' => 'PCM Format',
'AL_FORMAT_MONO8' => 'PCM Format',
'AL_FORMAT_STEREO16' => 'PCM Format',
'AL_FORMAT_STEREO8' => 'PCM Format',
'AL_FREQUENCY' => 'Buffer Setting',
'AL_GAIN' => 'Source/Listener Setting (Float)',
'AL_INITIAL' => 'Source State',
'AL_LOOPING' => 'Source State',
'AL_MAX_DISTANCE' => 'Source/Listener Setting (Float)',
'AL_MAX_GAIN' => 'Source/Listener Setting (Float)',
'AL_MIN_GAIN' => 'Source/Listener Setting (Float)',
'AL_ORIENTATION' => 'Source/Listener Setting (Float Vector)',
'AL_PAUSED' => 'Source State',
'AL_PITCH' => 'Source/Listener Setting (Float)',
'AL_PLAYING' => 'Source State',
'AL_POSITION' => 'Source/Listener Setting (Float Vector)',
'AL_REFERENCE_DISTANCE' => 'Source/Listener Setting (Float)',
'AL_ROLLOFF_FACTOR' => 'Source/Listener Setting (Float)',
'AL_SIZE' => 'Buffer Setting',
'AL_SOURCE_RELATIVE' => 'Source/Listener Setting (Integer)',
'AL_SOURCE_STATE' => 'Source/Listener Setting (Integer)',
'AL_STOPPED' => 'Source State',
'AL_TRUE' => 'Boolean value recognized by OpenAL',
'AL_VELOCITY' => 'Source/Listener Setting (Float Vector)',
'ALC_FREQUENCY' => 'Context Attribute',
'ALC_REFRESH' => 'Context Attribute',
'ALC_SYNC' => 'Context Attribute',
'ARRAY_FILTER_USE_BOTH' => '`ARRAY_FILTER_USE_BOTH` is used with `array_filter` to pass both value and key to the given callback function. Added in PHP 5.6.0.',
'ARRAY_FILTER_USE_KEY' => '`ARRAY_FILTER_USE_KEY` is used with `array_filter` to pass each key as the first argument to the given callback function. Added in PHP 5.6.0.',
'ast\AST_ARG_LIST' => 'numerically indexed children of an argument list of a function/method invocation',
'ast\AST_ARRAY' => 'numerically indexed children of an array literal.',
'ast\AST_ARRAY_ELEM' => 'An element of an array literal. The key is `null` if there is no key (children: value, key)',
'ast\AST_ARROW_FUNC' => 'A short arrow function declaration. (children: name, docComment, params, stmts, returnType, __declId)',
'ast\AST_ASSIGN' => 'An assignment of the form `var = expr` (children: var, expr)',
'ast\AST_ASSIGN_OP' => 'An assignment operation of the form `var op= expr`. The operation is determined by the flags `ast\flags\BINARY_*` (children: var, expr)',
'ast\AST_ASSIGN_REF' => 'An assignment by reference, of the form `var =& expr`. (children: var, expr)',
'ast\AST_ATTRIBUTE' => 'A single attribute of an element of the form `class(args)` (children: class, args)',
'ast\AST_ATTRIBUTE_GROUP' => 'Numerically indexed ast\AST_ATTRIBUTE children of an attribute group',
'ast\AST_ATTRIBUTE_LIST' => 'Numerically indexed ast\AST_ATTRIBUTE_GROUP children of an attribute list of an element',
'ast\AST_BINARY_OP' => 'A binary operation of the form `left op right`. The operation is determined by the flags `ast\flags\BINARY_*` (children: left, right)',
'ast\AST_BREAK' => 'A break statement. The depth is null or an integer. (children: depth)',
'ast\AST_CALL' => 'A global function invocation of the form `expr(args)` (children: expr, args)',
'ast\AST_CALLABLE_CONVERT' => 'Used instead of an ast\AST_ARG_LIST to indicate this is using first-class callable syntax (no children or flags)',
'ast\AST_CAST' => 'A cast operation of the form `(type)expr`. The flags are the type: `ast\flags\TYPE_*` (children: expr)',
'ast\AST_CATCH' => 'An individual catch block catching an `ast\AST_CLASS_LIST` of possible classes. This is of the form `catch(class var) { stmts }`. (children: class, var, stmts)',
'ast\AST_CATCH_LIST' => 'A list of 1 or more `ast\AST_CATCH` nodes for a try statement. (numerically indexed children)',
'ast\AST_CLASS' => 'A class declaration of the form `docComment name EXTENDS extends IMPLEMENTS implements { stmts }` (children: name, docComment, extends, implements, type, stmts, __declId)',
'ast\AST_CLASS_CONST' => 'A class constant usage of the form `class::const`. (children: class, const)',
'ast\AST_CLASS_CONST_DECL' => 'A class constant declaration with one or more class constants. (numerically indexed children)',
'ast\AST_CLASS_CONST_GROUP' => 'A class constant declaration with attributes and the list of one or more class constants. (children: const, attributes)',
'ast\AST_CLASS_NAME' => 'A usage of `class::CLASS` in AST version 70 (children: class)',
'ast\AST_CLONE' => 'An expression cloning an object, of the form `clone(expr)`. (children: expr)',
'ast\AST_CLOSURE' => 'A closure declaration. (children: name, docComment, params, uses, stmts, returnType, __declId)',
'ast\AST_CLOSURE_USES' => 'A list of one or more nodes of type `ast\AST_CLOSURE_VAR` for a closure declaration. (numerically indexed children)',
'ast\AST_CLOSURE_VAR' => 'A variable in the list of `uses` of a closure declaration. (children: name)',
'ast\AST_CONDITIONAL' => 'A conditional expression of the form `cond ? true : false` or `cond ?: false`. (children: cond, true, false)',
'ast\AST_CONST' => 'A usage of a global constant `name`. (children: name)',
'ast\AST_CONST_DECL' => 'A declaration of a group of class constants of kind `ast\AST_CONST_ELEM`. (numerically indexed children)',
'ast\AST_CONST_ELEM' => 'A declaration of a class constant. (children: name, value, docComment)',
'ast\AST_CONTINUE' => 'A continue statement with a depth of `null` or an integer. (children: depth)',
'ast\AST_DECLARE' => 'A declare statement at the top of a php file (children: declares, stmts)',
'ast\AST_DIM' => 'A usage of an array/array-like field, of the form `expr[dim]` (children: expr, dim)',
'ast\AST_DO_WHILE' => 'A do-while statement of the form `do {stmts} while (cond);`. (children: stmts, cond)',
'ast\AST_ECHO' => 'An echo statement or inline HTML (children: expr)',
'ast\AST_EMPTY' => 'An `empty(expr)` expression (children: expr)',
'ast\AST_ENCAPS_LIST' => 'interpolated string with non-literals, e.g. `"foo$bar"` or heredoc (numerically indexed children)',
'ast\AST_ENUM_CASE' => 'An enum case statement (children: name, expr, attributes)',
'ast\AST_EXIT' => 'An `exit`/`die` statement. (children: expr)',
'ast\AST_EXPR_LIST' => 'A comma separated list of expressions, e.g. for the condition of a `for` loop. (numerically indexed children)',
'ast\AST_FOR' => 'A for loop of the form `for (init; cond; loop) { stmts; }`. (children: init, cond, loop, stmts)',
'ast\AST_FOREACH' => 'A foreach loop of the form `foreach (expr as [key =>] value) {stmts} (children: expr, value, key, stmts)',
'ast\AST_FUNC_DECL' => 'A global function declaration. (children: name, docComment, params, stmts, returnType, __declId)',
'ast\AST_GLOBAL' => 'A usage of a global variable of the form `global var`. (children: var)',
'ast\AST_GOTO' => 'A goto statement of the form `goto label;` (children: label)',
'ast\AST_GROUP_USE' => 'A use statement (for classes, namespaces, functions, and/or constants) containing a list of one or more elements. (children: prefix, uses)',
'ast\AST_HALT_COMPILER' => 'A `__halt_compiler;` statement. (children: offset)',
'ast\AST_IF' => 'A list of `ast\AST_IF_ELEM` nodes for a chain of 1 or more `if`/`elseif`/`else` statements (numerically indexed children)',
'ast\AST_IF_ELEM' => 'An `if`/`elseif`/`elseif` statement of the form `if (cond) stmts` (children: cond, stmts)',
'ast\AST_INCLUDE_OR_EVAL' => 'An `include*(expr)`, `require*(expr)`, or `eval(expr)` statement. The type can be determined from the flags (`ast\flags\EXEC_*`). (children: expr)',
'ast\AST_INSTANCEOF' => 'An `expr instanceof class` expression. (children: expr, class)',
'ast\AST_ISSET' => 'An `isset(var)` expression. (children: var)',
'ast\AST_LABEL' => 'A `name:` expression (a target for `goto name`). (children: name)',
'ast\AST_LIST' => 'Used for `list() = ` unpacking, etc. Predates AST version 50. (numerically indexed children)',
'ast\AST_MAGIC_CONST' => 'A magic constant (depends on flags that are one of `ast\flags\MAGIC_*`)',
'ast\AST_MATCH' => 'A match expression of the form `match(cond) { stmts }` (children: cond, stmts)',
'ast\AST_MATCH_ARM' => 'An arm of a match expression of the form `cond => expr` (children: cond, expr)',
'ast\AST_MATCH_ARM_LIST' => 'Numerically indexed children of the kind `ast\AST_MATCH_ARM` for the statements of a match expression',
'ast\AST_METHOD' => 'A method declaration. (children: name, docComment, params, stmts, returnType, __declId)',
'ast\AST_METHOD_CALL' => 'An invocation of an instance method, of the form `expr->method(args)` (children: expr, method, args)',
'ast\AST_METHOD_REFERENCE' => 'A reference to a method when using a trait inside a class declaration. (children: class, method)',
'ast\AST_NAME' => 'A name token (e.g. of a constant/class/class type) (children: name)',
'ast\AST_NAMED_ARG' => 'A named argument in an argument list of a function/method call. (children: name, expr)',
'ast\AST_NAME_LIST' => 'A list of names (e.g. for catching multiple classes in a `catch` statement) (numerically indexed children)',
'ast\AST_NAMESPACE' => 'A namespace declaration of the form `namespace name;` or `namespace name { stmts }`. (children: name, stmts)',
'ast\AST_NEW' => 'An object creation expression of the form `new class(args)` (children: class, args)',
'ast\AST_NULLABLE_TYPE' => 'A nullable node with a child node of kind `ast\AST_TYPE` or `ast\AST_NAME` (children: type)',
'ast\AST_NULLSAFE_METHOD_CALL' => 'A nullsafe method call of the form `expr?->method(args)`. (children: expr, method, args)',
'ast\AST_NULLSAFE_PROP' => 'A nullsafe property read of the form `expr?->prop`. (children: expr, prop)',
'ast\AST_PARAM' => 'A parameter of a function, closure, or method declaration. (children: type, name, default)',
'ast\AST_PARAM_LIST' => 'The list of parameters of a function, closure, or method declaration. (numerically indexed children)',
'ast\AST_POST_DEC' => 'A `var--` expression. (children: var)',
'ast\AST_POST_INC' => 'A `var++` expression. (children: var)',
'ast\AST_PRE_DEC' => 'A `--var` expression. (children: var)',
'ast\AST_PRE_INC' => 'A `++var` expression. (children: var)',
'ast\AST_PRINT' => 'A `print expr` expression.  (children: expr)',
'ast\AST_PROP' => 'An instance property usage of the form `expr->prop` (children: expr, prop)',
'ast\AST_PROP_DECL' => 'A single group of property declarations inside a class. (numerically indexed children)',
'ast\AST_PROP_ELEM' => 'A class property declaration. (children: name, default, docComment)',
'ast\AST_PROP_GROUP' => 'A class property group declaration with optional type information for the group (in PHP 7.4+). Used in AST version 70+ (children: type, props, __declId)',
'ast\AST_PROPERTY_HOOK' => 'A class property hook declaration. (children: name, docComment, params, stmts, attributes)',
'ast\AST_PROPERTY_HOOK_SHORT_BODY' => 'A class property hook declaration using the shorthand format. (children: expr)',
'ast\AST_REF' => 'only used for `&$v` in `foreach ($a as &$v)` (children: var)',
'ast\AST_RETURN' => 'A `return;` or `return expr` statement. (children: expr)',
'ast\AST_SHELL_EXEC' => 'A `\`some_shell_command\`` expression. (children: expr)',
'ast\AST_STATIC' => 'A declaration of a static local variable of the form `static var = default`. (children: var, default)',
'ast\AST_STATIC_CALL' => 'A call of a static method, of the form `class::method(args)`. (children: class, method, args)',
'ast\AST_STATIC_PROP' => 'A usage of a static property, of the form `class::prop`. (children: class, prop)',
'ast\AST_STMT_LIST' => 'A list of statements. The statements are usually nodes but can be non-nodes, e.g. `;2;`. (numerically indexed children)',
'ast\AST_SWITCH' => 'A switch statement of the form `switch(cond) { stmts }`. `stmts` is a node of the kind `ast\AST_SWITCH_LIST`. (children: cond, stmts)',
'ast\AST_SWITCH_CASE' => 'A case statement of a switch, of the form `case cond: stmts` (children: cond, stmts)',
'ast\AST_SWITCH_LIST' => 'The full list of nodes inside a switch statement body, each of kind `ast\AST_SWITCH_CASE`. (numerically indexed children)',
'ast\AST_THROW' => 'A throw statement of the form `throw expr;` (children: expr)',
'ast\AST_TRAIT_ADAPTATIONS' => 'The optional adaptations to a statement using a trait inside a class (numerically indexed children)',
'ast\AST_TRAIT_ALIAS' => 'Adds an alias inside of a use of a trait (`method as alias`) (children: method, alias)',
'ast\AST_TRAIT_PRECEDENCE' => 'Indicates the precedent of a trait over another trait (`method INSTEADOF insteadof`) (children: method, insteadof)',
'ast\AST_TRY' => 'A try/catch(es)/finally block. (children: try, catches, finally)',
'ast\AST_TYPE' => 'A type such as `bool`. Other types such as specific classes are represented as `ast\AST_NAME`s (depends on flags of `ast\flags\TYPE_*`)',
'ast\AST_TYPE_INTERSECTION' => 'An intersection type type made up of individual types, such as `\ArrayAccess&\Countable` (numerically indexed children)',
'ast\AST_TYPE_UNION' => 'A union type made up of individual types, such as `bool|int` (numerically indexed children)',
'ast\AST_UNARY_OP' => 'A unary operation of the form `op expr` (e.g. `-expr`, the flags can be one of `ast\flags\UNARY_*`) (children: expr)',
'ast\AST_UNPACK' => 'An expression unpacking an array/iterable (i.e. `...expr`) (children: expr)',
'ast\AST_UNSET' => '`unset(var)` - A statement unsetting the expression `var` (children: var)',
'ast\AST_USE' => 'A list of uses of classes/namespaces, functions, and constants. The child nodes are of the kind `ast\AST_USE_ELEM` (numerically indexed children)',
'ast\AST_USE_ELEM' => 'A single use statement for a group of (children: name, alias)',
'ast\AST_USE_TRAIT' => 'Represents `use traits {[adaptations]}` within a class declaration (children: traits, adaptations)',
'ast\AST_VAR' => 'An occurrence of a variable `$name` or `${name}`. (children: name)',
'ast\AST_WHILE' => 'A while loop of the form `while (cond) { stmts }` (children: cond, stmts)',
'ast\AST_YIELD' => 'An expression of the form `yield [key =>] value` (children: value, key)',
'ast\AST_YIELD_FROM' => 'An expression of the form `yield from expr` (children: expr)',
'ast\flags\ARRAY_ELEM_REF' => 'Marks an `ast\AST_ARRAY_ELEM` as a reference',
'ast\flags\ARRAY_SYNTAX_LIST' => 'Marks an `ast\AST_ARRAY` as using the `list(...)` syntax',
'ast\flags\ARRAY_SYNTAX_LONG' => 'Marks an `ast\AST_ARRAY` as using the `array(...)` syntax',
'ast\flags\ARRAY_SYNTAX_SHORT' => 'Marks an `ast\AST_ARRAY` as using the `[...]` syntax',
'ast\flags\BINARY_ADD' => 'Marks an ast\AST_BINARY_OP as being a `+`',
'ast\flags\BINARY_BITWISE_AND' => 'Marks an ast\AST_BINARY_OP as being a `&`',
'ast\flags\BINARY_BITWISE_OR' => 'Marks an ast\AST_BINARY_OP as being a `|`',
'ast\flags\BINARY_BITWISE_XOR' => 'Marks an ast\AST_BINARY_OP as being a `^`',
'ast\flags\BINARY_BOOL_AND' => 'Marks an ast\AST_BINARY_OP as being a `&&` or `and`',
'ast\flags\BINARY_BOOL_OR' => 'Marks an ast\AST_BINARY_OP as being a `||` or `or`',
'ast\flags\BINARY_BOOL_XOR' => 'Marks an ast\AST_BINARY_OP as being an `xor`',
'ast\flags\BINARY_COALESCE' => 'Marks an ast\AST_BINARY_OP as being a `??`',
'ast\flags\BINARY_CONCAT' => 'Marks an ast\AST_BINARY_OP as being a `.`',
'ast\flags\BINARY_DIV' => 'Marks an ast\AST_BINARY_OP as being a `/`',
'ast\flags\BINARY_IS_EQUAL' => 'Marks an ast\AST_BINARY_OP as being a `==`',
'ast\flags\BINARY_IS_GREATER' => 'Marks an ast\AST_BINARY_OP as being a `>`',
'ast\flags\BINARY_IS_GREATER_OR_EQUAL' => 'Marks an ast\AST_BINARY_OP as being a `>=`',
'ast\flags\BINARY_IS_IDENTICAL' => 'Marks an ast\AST_BINARY_OP as being a `===`',
'ast\flags\BINARY_IS_NOT_EQUAL' => 'Marks an ast\AST_BINARY_OP as being a `!=`',
'ast\flags\BINARY_IS_NOT_IDENTICAL' => 'Marks an ast\AST_BINARY_OP as being a `!==`',
'ast\flags\BINARY_IS_SMALLER' => 'Marks an ast\AST_BINARY_OP as being a `<`',
'ast\flags\BINARY_IS_SMALLER_OR_EQUAL' => 'Marks an ast\AST_BINARY_OP as being a `<=`',
'ast\flags\BINARY_MOD' => 'Marks an ast\AST_BINARY_OP as being a `%`',
'ast\flags\BINARY_MUL' => 'Marks an ast\AST_BINARY_OP as being a `*`',
'ast\flags\BINARY_POW' => 'Marks an ast\AST_BINARY_OP as being a `**`',
'ast\flags\BINARY_SHIFT_LEFT' => 'Marks an ast\AST_BINARY_OP as being a `<<`',
'ast\flags\BINARY_SHIFT_RIGHT' => 'Marks an ast\AST_BINARY_OP as being a `>>`',
'ast\flags\BINARY_SPACESHIP' => 'Marks an ast\AST_BINARY_OP as being a `<=>`',
'ast\flags\BINARY_SUB' => 'Marks an ast\AST_BINARY_OP as being a `-`',
'ast\flags\CLASS_ABSTRACT' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being abstract',
'ast\flags\CLASS_ANONYMOUS' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being anonymous',
'ast\flags\CLASS_ENUM' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being an enum',
'ast\flags\CLASS_FINAL' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being final',
'ast\flags\CLASS_INTERFACE' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being an interface',
'ast\flags\CLASS_READONLY' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being readonly',
'ast\flags\CLASS_TRAIT' => 'Marks a `ast\AST_CLASS` (class-like declaration) as being a trait',
'ast\flags\CLOSURE_USE_REF' => 'Marks an `ast\AST_CLOSURE_USE` as using a variable by reference',
'ast\flags\DIM_ALTERNATIVE_SYNTAX' => 'Marks an `ast\AST_DIM` as using the alternative `expr{dim}` syntax',
'ast\flags\ENCAPS_VAR_DOLLAR_CURLY' => 'Marks an `ast\AST_VAR` or `ast\AST_DIM` found inside an encapsulated string as being embedded using the `${...}` syntax',
'ast\flags\ENCAPS_VAR_DOLLAR_CURLY_VAR_VAR' => 'Marks an `ast\AST_VAR` or `ast\AST_DIM` found inside an encapsulated string as being a variable variable access to an expression embedded using the `${expr}` syntax (equivalent to {${expr}})',
'ast\flags\EXEC_EVAL' => 'Marks an `ast\AST_EXEC` as being an `eval(...)`',
'ast\flags\EXEC_INCLUDE' => 'Marks an `ast\AST_EXEC` as being an `include`',
'ast\flags\EXEC_INCLUDE_ONCE' => 'Marks an `ast\AST_EXEC` as being an `include_once`',
'ast\flags\EXEC_REQUIRE' => 'Marks an `ast\AST_EXEC` as being a `require`',
'ast\flags\EXEC_REQUIRE_ONCE' => 'Marks an `ast\AST_EXEC` as being a `require_once`',
'ast\flags\FUNC_GENERATOR' => 'Marks an `ast\AST_FUNC_DECL` as being a generator',
'ast\flags\FUNC_RETURNS_REF' => 'Marks an `ast\AST_FUNC_DECL` as returning a value by reference',
'ast\flags\MAGIC_CLASS' => 'Marks an `ast\AST_MAGIC_CONST` as being `__CLASS__`',
'ast\flags\MAGIC_DIR' => 'Marks an `ast\AST_MAGIC_CONST` as being `__DIR__`',
'ast\flags\MAGIC_FILE' => 'Marks an `ast\AST_MAGIC_CONST` as being `__FILE__`',
'ast\flags\MAGIC_FUNCTION' => 'Marks an `ast\AST_MAGIC_CONST` as being `__FUNCTION__`',
'ast\flags\MAGIC_LINE' => 'Marks an `ast\AST_MAGIC_CONST` as being `__LINE__`',
'ast\flags\MAGIC_METHOD' => 'Marks an `ast\AST_MAGIC_CONST` as being `__METHOD__`',
'ast\flags\MAGIC_NAMESPACE' => 'Marks an `ast\AST_MAGIC_CONST` as being `__NAMESPACE__`',
'ast\flags\MAGIC_TRAIT' => 'Marks an `ast\AST_MAGIC_CONST` as being `__TRAIT__`',
'ast\flags\MODIFIER_ABSTRACT' => 'Marks an element declaration as being `abstract`',
'ast\flags\MODIFIER_FINAL' => 'Marks an element declaration as being `final` (not overridable by subclasses)',
'ast\flags\MODIFIER_READONLY' => 'Marks a class instance property as being `readonly` (not modifiable after being set)',
'ast\flags\MODIFIER_PRIVATE' => 'Marks an element declaration as being `private`',
'ast\flags\MODIFIER_PROTECTED' => 'Marks an element declaration as being `protected`',
'ast\flags\MODIFIER_PUBLIC' => 'Marks an element declaration as being `public`',
'ast\flags\MODIFIER_STATIC' => 'Marks an element declaration as being `static`',
'ast\flags\NAME_FQ' => 'Marks an `ast\AST_NAME` as being fully qualified (`\Name`)',
'ast\flags\NAME_NOT_FQ' => 'Marks an `ast\AST_NAME` as being not fully qualified (`Name`)',
'ast\flags\NAME_RELATIVE' => 'Marks an `ast\AST_NAME` as being relative to the current namespace (`namespace\Name`)',
'ast\flags\PARAM_MODIFIER_PRIVATE' => 'Marks a promoted constructor property as being `private`',
'ast\flags\PARAM_MODIFIER_PROTECTED' => 'Marks a promoted constructor property as being `protected`',
'ast\flags\PARAM_MODIFIER_PUBLIC' => 'Marks a promoted constructor property as being `public`',
'ast\flags\PARAM_REF' => 'Marks an `ast\AST_PARAM` as being a reference (`&$x`)',
'ast\flags\PARAM_VARIADIC' => 'Marks an `ast\AST_PARAM` as being variadic (`...$x`)',
'ast\flags\PARENTHESIZED_CONDITIONAL' => 'Marks a `ast\AST_CONDITIONAL` as being parenthesized (`(cond ? true : false)`)',
'ast\flags\RETURNS_REF' => 'Marks a function-like as returning an argument by reference',
'ast\flags\TYPE_ARRAY' => 'Marks an `ast\AST_TYPE` as being `array`',
'ast\flags\TYPE_BOOL' => 'Marks an `ast\AST_TYPE` as being `bool`',
'ast\flags\TYPE_CALLABLE' => 'Marks an `ast\AST_TYPE` as being `callable`',
'ast\flags\TYPE_DOUBLE' => 'Marks an `ast\AST_TYPE` as being `float`',
'ast\flags\TYPE_FALSE' => 'Marks an `ast\AST_TYPE` as being `false`',
'ast\flags\TYPE_MIXED' => 'Marks an `ast\AST_TYPE` as being `mixed`',
'ast\flags\TYPE_NEVER' => 'Marks an `ast\AST_TYPE` as being `never`',
'ast\flags\TYPE_ITERABLE' => 'Marks an `ast\AST_TYPE` as being `iterable`',
'ast\flags\TYPE_LONG' => 'Marks an `ast\AST_TYPE` as being `int`',
'ast\flags\TYPE_NULL' => 'Marks an `ast\AST_TYPE` as being `null`',
'ast\flags\TYPE_OBJECT' => 'Marks an `ast\AST_TYPE` as being `object`',
'ast\flags\TYPE_STATIC' => 'Marks an `ast\AST_TYPE` as being `static` (for return types)',
'ast\flags\TYPE_STRING' => 'Marks an `ast\AST_TYPE` as being `string`',
'ast\flags\TYPE_TRUE' => 'Marks an `ast\AST_TYPE` as being `true`',
'ast\flags\TYPE_VOID' => 'Marks an `ast\AST_TYPE` as being `void` (for return types)',
'ast\flags\UNARY_BITWISE_NOT' => 'Marks an `ast\AST_UNARY_OP` as being `~expr`',
'ast\flags\UNARY_BOOL_NOT' => 'Marks an `ast\AST_UNARY_OP` as being `!expr`',
'ast\flags\UNARY_MINUS' => 'Marks an `ast\AST_UNARY_OP` as being `-expr`',
'ast\flags\UNARY_PLUS' => 'Marks an `ast\AST_UNARY_OP` as being `+expr`',
'ast\flags\UNARY_SILENCE' => 'Marks an `ast\AST_UNARY_OP` as being `@expr`',
'ast\flags\USE_CONST' => 'Marks an `ast\AST_USE` or `ast\AST_GROUP_USE` (namespace use statement) as being `use const name;`',
'ast\flags\USE_FUNCTION' => 'Marks an `ast\AST_USE` or `ast\AST_GROUP_USE` (namespace use statement) as being `use function name;`',
'ast\flags\USE_NORMAL' => 'Marks an `ast\AST_USE` or `ast\AST_GROUP_USE` (namespace use statement) as being `use name;`',
'BBCODE_ARG_DOUBLE_QUOTE' => 'This is a parser option allowing argument quoting with double quotes (`"`)',
'BBCODE_ARG_HTML_QUOTE' => 'This is a parser option allowing argument quoting with HTML version of double quotes (`&amp;quot;`)',
'BBCODE_ARG_QUOTE_ESCAPING' => 'This is a parser option allowing argument quotes to be escaped this permit the quote delimiter to be found in the string escaping character is \ it can escape any quoting character or itself, if found in front of a non escapable character, it will be dropped. Default behaviour is not to use escaping.',
'BBCODE_ARG_SINGLE_QUOTE' => 'This is a parser option allowing argument quoting with single quotes (`\'`)',
'BBCODE_AUTO_CORRECT' => 'This is a parser option changing the way errors are treated. It automatically closes tag in the order they are opened. And treat tags with only an open tag as if there were a close tag present.',
'BBCODE_CORRECT_REOPEN_TAGS' => 'This is a parser option changing the way errors are treated. It automatically reopens tag if close tags are not in the good order.',
'BBCODE_DEFAULT_SMILEYS_OFF' => 'This is a parser option setting smileys to OFF if no flag is given at tag level.',
'BBCODE_DEFAULT_SMILEYS_ON' => 'This is a parser option setting smileys to ON if no flag is given at tag level.',
'BBCODE_DISABLE_TREE_BUILD' => 'This is a parser option disabling the BBCode parsing it can be useful if only the "smiley" replacement must be used.',
'BBCODE_FLAGS_ARG_PARSING' => 'This BBCode tag require argument sub-parsing (the argument is also parsed by the BBCode extension). As Of 0.10.2 another parser can be used as argument parser.',
'BBCODE_FLAGS_CDATA_NOT_ALLOWED' => 'This BBCode Tag does not accept content (it voids it automatically).',
'BBCODE_FLAGS_DENY_REOPEN_CHILD' => 'This BBCode Tag does not allow unclosed children to reopen when automatically closed.',
'BBCODE_FLAGS_ONE_OPEN_PER_LEVEL' => 'This BBCode Tag automatically closes if another tag of the same type is found at the same nesting level.',
'BBCODE_FLAGS_REMOVE_IF_EMPTY' => 'This BBCode Tag is automatically removed if content is empty it allows to produce lighter HTML.',
'BBCODE_FLAGS_SMILEYS_OFF' => 'This BBCode Tag does not accept smileys.',
'BBCODE_FLAGS_SMILEYS_ON' => 'This BBCode Tag accepts smileys.',
'BBCODE_FORCE_SMILEYS_OFF' => 'This is a parser option disabling completely the smileys parsing.',
'BBCODE_SET_FLAGS_ADD' => 'This permits to switch a flag set ON on a parser.',
'BBCODE_SET_FLAGS_REMOVE' => 'This permits to switch a flag set OFF on a parser.',
'BBCODE_SET_FLAGS_SET' => 'This permits to SET the complete flag set on a parser.',
'BBCODE_SMILEYS_CASE_INSENSITIVE' => 'Use a case insensitive Detection for smileys instead of a simple binary search.',
'BBCODE_TYPE_ARG' => 'This BBCode tag need an argument.',
'BBCODE_TYPE_NOARG' => 'This BBCode tag does not accept any arguments.',
'BBCODE_TYPE_OPTARG' => 'This BBCode tag accept an optional argument.',
'BBCODE_TYPE_ROOT' => 'This BBCode tag is the special tag root (nesting level 0).',
'BBCODE_TYPE_SINGLE' => 'This BBCode tag does not have a corresponding close tag.',
'BUS_ADRALN' => 'Available since PHP 5.3.0.',
'BUS_ADRERR' => 'Available since PHP 5.3.0.',
'BUS_OBJERR' => 'Available since PHP 5.3.0.',
'CAL_DOW_DAYNO' => 'For `jddayofweek`: the day of the week as `integer`, where `0` means Sunday and `6` means Saturday.',
'CAL_DOW_LONG' => 'For `jddayofweek`: the English name of the day of the week.',
'CAL_DOW_SHORT' => 'For `jddayofweek`: the abbreviated English name of the day of the week.',
'CAL_EASTER_ALWAYS_GREGORIAN' => 'For `easter_days`: calculate Easter according to the proleptic Gregorian calendar.',
'CAL_EASTER_ALWAYS_JULIAN' => 'For `easter_days`: calculate Easter according to the Julian calendar.',
'CAL_EASTER_DEFAULT' => 'For `easter_days`: calculate Easter for years before 1753 according to the Julian calendar, and for later years according to the Gregorian calendar.',
'CAL_EASTER_ROMAN' => 'For `easter_days`: calculate Easter for years before 1583 according to the Julian calendar, and for later years according to the Gregorian calendar.',
'CAL_FRENCH' => 'For `cal_days_in_month`, `cal_from_jd`, `cal_info` and `cal_to_jd`: use the French Repuclican calendar.',
'CAL_GREGORIAN' => 'For `cal_days_in_month`, `cal_from_jd`, `cal_info` and `cal_to_jd`: use the proleptic Gregorian calendar.',
'CAL_JEWISH' => 'For `cal_days_in_month`, `cal_from_jd`, `cal_info` and `cal_to_jd`: use the Jewish calendar.',
'CAL_JEWISH_ADD_ALAFIM' => 'For `jdtojewish`: adds the word alafim as thousands separator to the year number.',
'CAL_JEWISH_ADD_ALAFIM_GERESH' => 'For `jdtojewish`: adds a geresh symbol (which resembles a single-quote mark) as thousands separator to the year number.',
'CAL_JEWISH_ADD_GERESHAYIM' => 'For `jdtojewish`: add a gershayim symbol (which resembles a double-quote mark) before the final letter of the day and year numbers.',
'CAL_JULIAN' => 'For `cal_days_in_month`, `cal_from_jd`, `cal_info` and `cal_to_jd`: use the Julian calendar.',
'CAL_MONTH_FRENCH' => 'For `jdmonthname`: the French Republican month name.',
'CAL_MONTH_GREGORIAN_LONG' => 'For `jdmonthname`: the Gregorian month name.',
'CAL_MONTH_GREGORIAN_SHORT' => 'For `jdmonthname`: the abbreviated Gregorian month name.',
'CAL_MONTH_JEWISH' => 'For `jdmonthname`: the Jewish month name.',
'CAL_MONTH_JULIAN_LONG' => 'For `jdmonthname`: the Julian month name.',
'CAL_MONTH_JULIAN_SHORT' => 'For `jdmonthname`: the abbreviated Julian month name.',
'CAL_NUM_CALS' => 'The number of available calendars.',
'CASE_LOWER' => '`CASE_LOWER` is used with `array_change_key_case` and is used to convert array keys to lower case. This is also the default case for `array_change_key_case`.',
'CASE_UPPER' => '`CASE_UPPER` is used with `array_change_key_case` and is used to convert array keys to upper case.',
'Cassandra::CONSISTENCY_ALL' => 'Consistency level ALL guarantees that data has been written to all
Replica nodes.',
'Cassandra::CONSISTENCY_ANY' => 'Consistency level ANY means the request is fulfilled as soon as the data
has been written on the Coordinator. Requests with this consistency level
are not guaranteed to make it to Replica nodes.',
'Cassandra::CONSISTENCY_EACH_QUORUM' => 'Consistency level EACH_QUORUM guarantees that data has been written to at
least a majority Replica nodes in all datacenters. This consistency level
works only with `NetworkTopologyStrategy` replication.',
'Cassandra::CONSISTENCY_LOCAL_ONE' => 'Same as `CONSISTENCY_ONE`, but confined to the local data center. This
consistency level works only with `NetworkTopologyStrategy` replication.',
'Cassandra::CONSISTENCY_LOCAL_QUORUM' => 'Same as `CONSISTENCY_QUORUM`, but confined to the local data center. This
consistency level works only with `NetworkTopologyStrategy` replication.',
'Cassandra::CONSISTENCY_LOCAL_SERIAL' => 'Same as `CONSISTENCY_SERIAL`, but confined to the local data center. This
consistency level works only with `NetworkTopologyStrategy` replication.',
'Cassandra::CONSISTENCY_ONE' => 'Consistency level ONE guarantees that data has been written to at least
one Replica node.',
'Cassandra::CONSISTENCY_QUORUM' => 'Consistency level QUORUM guarantees that data has been written to at least
the majority of Replica nodes. How many nodes exactly are a majority
depends on the replication factor of a given keyspace and is calculated
using the formula `ceil(RF / 2 + 1)`, where `ceil` is a mathematical
ceiling function and `RF` is the replication factor used. For example,
for a replication factor of `5`, the majority is `ceil(5 / 2 + 1) = 3`.',
'Cassandra::CONSISTENCY_SERIAL' => 'This is a serial consistency level, it is used in conditional updates,
e.g. (`CREATE|INSERT ... IF NOT EXISTS`), and should be specified as the
`serial_consistency` execution option when invoking `session.execute`
or `session.execute_async`.

Consistency level SERIAL, when set, ensures that a Paxos commit fails if
any of the replicas is down.',
'Cassandra::CONSISTENCY_THREE' => 'Consistency level THREE guarantees that data has been written to at least
three Replica nodes.',
'Cassandra::CONSISTENCY_TWO' => 'Consistency level TWO guarantees that data has been written to at least
two Replica nodes.',
'Cassandra::CPP_DRIVER_VERSION' => 'The version of the cpp-driver the extension is compiled against.',
'Cassandra::LOG_CRITICAL' => 'Allow critical level logging.',
'Cassandra::LOG_DEBUG' => 'Allow debug level logging.',
'Cassandra::LOG_DISABLED' => 'Used to disable logging.',
'Cassandra::LOG_ERROR' => 'Allow error level logging.',
'Cassandra::LOG_INFO' => 'Allow info level logging.',
'Cassandra::LOG_TRACE' => 'Allow trace level logging.',
'Cassandra::LOG_WARN' => 'Allow warning level logging.',
'Cassandra::TYPE_ASCII' => 'When using a map, collection or set of type ascii, all of its elements
must be strings.',
'Cassandra::TYPE_BIGINT' => 'When using a map, collection or set of type bigint, all of its elements
must be instances of Bigint.',
'Cassandra::TYPE_BLOB' => 'When using a map, collection or set of type blob, all of its elements
must be instances of Blob.',
'Cassandra::TYPE_BOOLEAN' => 'When using a map, collection or set of type bool, all of its elements
must be boolean.',
'Cassandra::TYPE_COUNTER' => 'When using a map, collection or set of type counter, all of its elements
must be instances of Bigint.',
'Cassandra::TYPE_DECIMAL' => 'When using a map, collection or set of type decimal, all of its elements
must be instances of Decimal.',
'Cassandra::TYPE_DOUBLE' => 'When using a map, collection or set of type double, all of its elements
must be doubles.',
'Cassandra::TYPE_FLOAT' => 'When using a map, collection or set of type float, all of its elements
must be instances of Float.',
'Cassandra::TYPE_INET' => 'When using a map, collection or set of type inet, all of its elements
must be instances of Inet.',
'Cassandra::TYPE_INT' => 'When using a map, collection or set of type int, all of its elements
must be ints.',
'Cassandra::TYPE_SMALLINT' => 'When using a map, collection or set of type smallint, all of its elements
must be instances of Inet.',
'Cassandra::TYPE_TEXT' => 'When using a map, collection or set of type text, all of its elements
must be strings.',
'Cassandra::TYPE_TIMESTAMP' => 'When using a map, collection or set of type timestamp, all of its elements
must be instances of Timestamp.',
'Cassandra::TYPE_TIMEUUID' => 'When using a map, collection or set of type timeuuid, all of its elements
must be instances of Timeuuid.',
'Cassandra::TYPE_TINYINT' => 'When using a map, collection or set of type tinyint, all of its elements
must be instances of Inet.',
'Cassandra::TYPE_UUID' => 'When using a map, collection or set of type uuid, all of its elements
must be instances of Uuid.',
'Cassandra::TYPE_VARCHAR' => 'When using a map, collection or set of type varchar, all of its elements
must be strings.',
'Cassandra::TYPE_VARINT' => 'When using a map, collection or set of type varint, all of its elements
must be instances of Varint.',
'Cassandra::VERIFY_NONE' => 'Perform no verification of nodes when using SSL encryption.',
'Cassandra::VERIFY_PEER_CERT' => 'Verify presence and validity of SSL certificates.',
'Cassandra::VERIFY_PEER_IDENTITY' => 'Verify that the IP address matches the SSL certificate’s common name or
one of its subject alternative names. This implies the certificate is
also present.',
'Cassandra::VERSION' => 'The current version of the extension.',
'CL_EXPUNGE' => 'silently expunge the mailbox before closing when calling `imap_close`',
'CLASSKIT_ACC_PRIVATE' => 'Marks the method `private`',
'CLASSKIT_ACC_PROTECTED' => 'Marks the method `protected`',
'CLASSKIT_ACC_PUBLIC' => 'Marks the method `public`',
'CLASSKIT_AGGREGATE_OVERRIDE' => 'PHP 5 specific flag to `classkit_import` Only defined when classkit compatibility is enabled.',
'CLASSKIT_VERSION' => 'Defined to the current version of the runkit package. Only defined when classkit compatibility is enabled.',
'CLD_CONTINUED' => 'Available since PHP 5.3.0.',
'CLD_DUMPED' => 'Available since PHP 5.3.0.',
'CLD_EXITED' => 'Available since PHP 5.3.0.',
'CLD_KILLED' => 'Available since PHP 5.3.0.',
'CLD_STOPPED' => 'Available since PHP 5.3.0.',
'CLD_TRAPPED' => 'Available since PHP 5.3.0.',
'Couchbase\Bucket::PINGSVC_FTS' => 'Ping full text search (FTS) service.',
'Couchbase\Bucket::PINGSVC_KV' => 'Ping data (Key/Value) service.',
'Couchbase\Bucket::PINGSVC_N1QL' => 'Ping query (N1QL) service.',
'Couchbase\Bucket::PINGSVC_VIEWS' => 'Ping views (Map/Reduce) service.',
'Couchbase\ClusterManager::RBAC_DOMAIN_EXTERNAL' => 'The user account managed by external system (e.g. LDAP).',
'Couchbase\ClusterManager::RBAC_DOMAIN_LOCAL' => 'The user account managed by Couchbase Cluster.',
'Couchbase\N1qlQuery::NOT_BOUNDED' => 'This is the default (for single-statement requests).
No timestamp vector is used in the index scan.
This is also the fastest mode, because we avoid the cost of obtaining the vector,
and we also avoid any wait for the index to catch up to the vector.',
'Couchbase\N1qlQuery::PROFILE_NONE' => 'Disables profiling. This is the default',
'Couchbase\N1qlQuery::PROFILE_PHASES' => 'Enables phase profiling.',
'Couchbase\N1qlQuery::PROFILE_TIMINGS' => 'Enables general timing profiling.',
'Couchbase\N1qlQuery::REQUEST_PLUS' => 'This implements strong consistency per request.
Before processing the request, a current vector is obtained.
The vector is used as a lower bound for the statements in the request.
If there are DML statements in the request, RYOW is also applied within the request.',
'Couchbase\N1qlQuery::STATEMENT_PLUS' => 'This implements strong consistency per statement.
Before processing each statement, a current vector is obtained
and used as a lower bound for that statement.',
'Couchbase\ViewQuery::UPDATE_AFTER' => 'Allow stale view, update view after it has been accessed.',
'Couchbase\ViewQuery::UPDATE_BEFORE' => 'Force a view update before returning data',
'Couchbase\ViewQuery::UPDATE_NONE' => 'Allow stale views',
'CP_MOVE' => 'Delete the messages from the current mailbox after copying with `imap_mail_copy`',
'CP_UID' => 'the sequence numbers contain UIDS',
'Crypto\Base64Exception::DECODE_FINISH_FORBIDDEN' => 'The object has not been initialized for decoding',
'Crypto\Base64Exception::DECODE_UPDATE_FAILED' => 'Base64 decoded string does not contain valid characters',
'Crypto\Base64Exception::DECODE_UPDATE_FORBIDDEN' => 'The object is already used for encoding',
'Crypto\Base64Exception::ENCODE_FINISH_FORBIDDEN' => 'The object has not been initialized for encoding',
'Crypto\Base64Exception::ENCODE_UPDATE_FORBIDDEN' => 'The object is already used for decoding',
'Crypto\Base64Exception::INPUT_DATA_LENGTH_HIGH' => 'Input data length can\'t exceed max integer length',
'Crypto\CipherException::AAD_LENGTH_HIGH' => 'AAD length can\'t exceed max integer length',
'Crypto\CipherException::AAD_SETTER_FAILED' => 'AAD setter failed',
'Crypto\CipherException::AAD_SETTER_FORBIDDEN' => 'AAD setter has to be called before encryption or decryption',
'Crypto\CipherException::ALGORITHM_NOT_FOUND' => 'Cipher \'%s\' algorithm not found',
'Crypto\CipherException::AUTHENTICATION_NOT_SUPPORTED' => 'The authentication is not supported for %s cipher mode',
'Crypto\CipherException::FINISH_DECRYPT_FORBIDDEN' => 'Cipher object is not initialized for decryption',
'Crypto\CipherException::FINISH_ENCRYPT_FORBIDDEN' => 'Cipher object is not initialized for encryption',
'Crypto\CipherException::FINISH_FAILED' => 'Finalizing of cipher failed',
'Crypto\CipherException::INIT_ALG_FAILED' => 'Initialization of cipher algorithm failed',
'Crypto\CipherException::INIT_CTX_FAILED' => 'Initialization of cipher context failed',
'Crypto\CipherException::INIT_DECRYPT_FORBIDDEN' => 'Cipher object is already used for encryption',
'Crypto\CipherException::INIT_ENCRYPT_FORBIDDEN' => 'Cipher object is already used for decryption',
'Crypto\CipherException::INPUT_DATA_LENGTH_HIGH' => 'Input data length can\'t exceed max integer length',
'Crypto\CipherException::IV_LENGTH_INVALID' => 'Invalid length of initial vector for cipher \'%s\' algorithm (required length: %d)',
'Crypto\CipherException::KEY_LENGTH_INVALID' => 'Invalid length of key for cipher \'%s\' algorithm (required length: %d)',
'Crypto\CipherException::MODE_NOT_AVAILABLE' => 'Cipher mode %s is not available in installed OpenSSL library',
'Crypto\CipherException::MODE_NOT_FOUND' => 'Cipher mode not found',
'Crypto\CipherException::STATIC_METHOD_NOT_FOUND' => 'Cipher static method \'%s\' not found',
'Crypto\CipherException::STATIC_METHOD_TOO_MANY_ARGS' => 'Cipher static method %s can accept max two arguments',
'Crypto\CipherException::TAG_GETTER_FAILED' => 'Tag getter failed',
'Crypto\CipherException::TAG_GETTER_FORBIDDEN' => 'Tag getter has to be called after encryption',
'Crypto\CipherException::TAG_LENGTH_HIGH' => 'Tag length can\'t exceed 128 bits (16 characters)',
'Crypto\CipherException::TAG_LENGTH_LOW' => 'Tag length can\'t be lower than 32 bits (4 characters)',
'Crypto\CipherException::TAG_LENGTH_SETTER_FORBIDDEN' => 'Tag length setter has to be called before encryption',
'Crypto\CipherException::TAG_SETTER_FAILED' => 'Tag setter failed',
'Crypto\CipherException::TAG_SETTER_FORBIDDEN' => 'Tag setter has to be called before decryption',
'Crypto\CipherException::TAG_VERIFY_FAILED' => 'Tag verification failed',
'Crypto\CipherException::UPDATE_DECRYPT_FORBIDDEN' => 'Cipher object is not initialized for decryption',
'Crypto\CipherException::UPDATE_ENCRYPT_FORBIDDEN' => 'Cipher object is not initialized for encryption',
'Crypto\CipherException::UPDATE_FAILED' => 'Updating of cipher failed',
'Crypto\HashException::DIGEST_FAILED' => 'Creating of hash digest failed',
'Crypto\HashException::HASH_ALGORITHM_NOT_FOUND' => 'Hash algorithm \'%s\' not found',
'Crypto\HashException::INIT_FAILED' => 'Initialization of hash failed',
'Crypto\HashException::INPUT_DATA_LENGTH_HIGH' => 'Input data length can\'t exceed max integer length',
'Crypto\HashException::STATIC_METHOD_NOT_FOUND' => 'Hash static method \'%s\' not found',
'Crypto\HashException::STATIC_METHOD_TOO_MANY_ARGS' => 'Hash static method %s can accept max one argument',
'Crypto\HashException::UPDATE_FAILED' => 'Updating of hash context failed',
'Crypto\KDFException::DERIVATION_FAILED' => 'KDF derivation failed',
'Crypto\KDFException::KEY_LENGTH_HIGH' => 'The key length is too high',
'Crypto\KDFException::KEY_LENGTH_LOW' => 'The key length is too low',
'Crypto\KDFException::PASSWORD_LENGTH_INVALID' => 'The password is too long',
'Crypto\KDFException::SALT_LENGTH_HIGH' => 'The salt is too long',
'Crypto\MACException::KEY_LENGTH_INVALID' => 'The key length for MAC is invalid',
'Crypto\MACException::MAC_ALGORITHM_NOT_FOUND' => 'MAC algorithm \'%s\' not found',
'Crypto\PBKDF2Exception::HASH_ALGORITHM_NOT_FOUND' => 'Hash algorithm \'%s\' not found',
'Crypto\PBKDF2Exception::ITERATIONS_HIGH' => 'Iterations count is too high',
'Crypto\RandException::FILE_WRITE_PREDICTABLE' => 'The bytes written were generated without appropriate seed',
'Crypto\RandException::GENERATE_PREDICTABLE' => 'The PRNG state is not yet unpredictable',
'Crypto\RandException::REQUESTED_BYTES_NUMBER_TOO_HIGH' => 'The requested number of bytes is too high',
'Crypto\RandException::SEED_LENGTH_TOO_HIGH' => 'The supplied seed length is too high',
'CURL_HTTP_VERSION_2' => 'Available since PHP 7.0.7 and cURL 7.43.0',
'CURL_HTTP_VERSION_2_0' => 'Available since PHP 5.5.24 and 5.6.8 and cURL 7.33.0',
'CURL_HTTP_VERSION_2_PRIOR_KNOWLEDGE' => 'Available since PHP 7.0.7 and cURL 7.49.0',
'CURL_HTTP_VERSION_2TLS' => 'Available since PHP 7.0.7 and cURL 7.47.0',
'CURL_LOCK_DATA_CONNECT' => 'Available since PHP 7.3.0 and cURL 7.10.0',
'CURL_LOCK_DATA_PSL' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURL_MAX_READ_SIZE' => 'Available since PHP 7.3.0 and cURL 7.53.0',
'CURL_PUSH_DENY' => 'Available since PHP 7.1.0 and cURL 7.44.0',
'CURL_PUSH_OK' => 'Available since PHP 7.1.0 and cURL 7.44.0',
'CURL_REDIR_POST_301' => 'Available since PHP 7.0.7 and cURL 7.18.2',
'CURL_REDIR_POST_302' => 'Available since PHP 7.0.7 and cURL 7.18.2',
'CURL_REDIR_POST_303' => 'Available since PHP 7.0.7 and cURL 7.25.1',
'CURL_REDIR_POST_ALL' => 'Available since PHP 7.0.7 and cURL 7.18.2',
'CURL_SSLVERSION_MAX_DEFAULT' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURL_SSLVERSION_MAX_NONE' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURL_SSLVERSION_MAX_TLSv1_0' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURL_SSLVERSION_MAX_TLSv1_1' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURL_SSLVERSION_MAX_TLSv1_2' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURL_SSLVERSION_MAX_TLSv1_3' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURL_SSLVERSION_TLSv1_0' => 'Available since PHP 5.5.19 and 5.6.3',
'CURL_SSLVERSION_TLSv1_1' => 'Available since PHP 5.5.19 and 5.6.3',
'CURL_SSLVERSION_TLSv1_2' => 'Available since PHP 5.5.19 and 5.6.3',
'CURL_SSLVERSION_TLSv1_3' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURL_VERSION_ALTSVC' => 'Available since PHP 7.3.6 and cURL 7.64.1',
'CURL_VERSION_ASYNCHDNS' => 'Available since PHP 7.3.0 and cURL 7.10.7',
'CURL_VERSION_BROTLI' => 'Available since PHP 7.3.0 and cURL 7.57.0',
'CURL_VERSION_CONV' => 'Available since PHP 7.3.0 and cURL 7.15.4',
'CURL_VERSION_CURLDEBUG' => 'Available since PHP 7.3.6 and cURL 7.19.6',
'CURL_VERSION_DEBUG' => 'Available since PHP 7.3.0 and cURL 7.10.6',
'CURL_VERSION_GSSAPI' => 'Available since PHP 7.3.0 and cURL 7.38.0',
'CURL_VERSION_GSSNEGOTIATE' => 'Available since PHP 7.3.0 and cURL 7.10.6 (deprecated since 7.38.0)',
'CURL_VERSION_HTTP2' => 'Available since PHP 5.5.24 and 5.6.8 and cURL 7.33.0',
'CURL_VERSION_HTTPS_PROXY' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURL_VERSION_IDN' => 'Available since PHP 7.3.0 and cURL 7.12.0',
'CURL_VERSION_KERBEROS5' => 'Available since PHP 7.0.7 and cURL 7.40.0',
'CURL_VERSION_MULTI_SSL' => 'Available since PHP 7.3.0 and cURL 7.56.0',
'CURL_VERSION_NTLM' => 'Available since PHP 7.3.0 and cURL 7.10.6',
'CURL_VERSION_NTLM_WB' => 'Available since PHP 7.3.0 and cURL 7.22.0',
'CURL_VERSION_PSL' => 'Available since PHP 7.0.7 and cURL 7.47.0',
'CURL_VERSION_SPNEGO' => 'Available since PHP 7.3.0 and cURL 7.10.8',
'CURL_VERSION_SSPI' => 'Available since PHP 7.3.0 and cURL 7.13.2',
'CURL_VERSION_TLSAUTH_SRP' => 'Available since PHP 7.3.0 and cURL 7.21.4',
'CURL_VERSION_UNIX_SOCKETS' => 'Available since PHP 7.0.7 and cURL 7.40.0',
'CURL_WRAPPERS_ENABLED' => 'Defined if PHP was configured with --with-curlwrappers. Moved to PECL in PHP 5.5.0.',
'CURLAUTH_BEARER' => 'Available since PHP 7.3.0 and cURL 7.61.0.',
'CURLAUTH_GSSAPI' => 'Available since PHP 7.3.0 and cURL 7.54.1',
'CURLAUTH_NEGOTIATE' => 'Available since PHP 7.0.7 and cURL 7.38.0.',
'CURLAUTH_NTLM_WB' => 'Available since PHP 7.0.7 and cURL 7.22.0',
'CURLCLOSEPOLICY_CALLBACK' => 'Removed in PHP 5.6.0.',
'CURLCLOSEPOLICY_LEAST_RECENTLY_USED' => 'Removed in PHP 5.6.0.',
'CURLCLOSEPOLICY_LEAST_TRAFFIC' => 'Removed in PHP 5.6.0.',
'CURLCLOSEPOLICY_OLDEST' => 'Removed in PHP 5.6.0.',
'CURLCLOSEPOLICY_SLOWEST' => 'Removed in PHP 5.6.0.',
'CURLE_SSH' => 'Available since PHP 5.3.0 and cURL 7.16.1.',
'CURLE_WEIRD_SERVER_REPLY' => 'Available since PHP 7.3.0 and cURL 7.51.0',
'CURLFTP_CREATE_DIR' => 'Available since PHP 7.0.7 and cURL 7.19.3',
'CURLFTP_CREATE_DIR_NONE' => 'Available since PHP 7.0.7 and cURL 7.19.3',
'CURLFTP_CREATE_DIR_RETRY' => 'Available since PHP 7.0.7 and cURL 7.19.3',
'CURLFTPAUTH_DEFAULT' => 'Available since PHP 5.1.0',
'CURLFTPAUTH_SSL' => 'Available since PHP 5.1.0',
'CURLFTPAUTH_TLS' => 'Available since PHP 5.1.0',
'CURLFTPSSL_ALL' => 'Available since PHP 5.2.0',
'CURLFTPSSL_CONTROL' => 'Available since PHP 5.2.0',
'CURLFTPSSL_NONE' => 'Available since PHP 5.2.0',
'CURLFTPSSL_TRY' => 'Available since PHP 5.2.0',
'CURLHEADER_SEPARATE' => 'Available since PHP 7.0.7 and cURL 7.37.0.',
'CURLHEADER_UNIFIED' => 'Available since PHP 7.0.7 and cURL 7.37.0.',
'CURLINFO_APPCONNECT_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLINFO_CONNECT_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLINFO_CONTENT_LENGTH_DOWNLOAD_T' => 'Available since PHP 7.3.0 and cURL 7.55.0',
'CURLINFO_CONTENT_LENGTH_UPLOAD_T' => 'Available since PHP 7.3.0 and cURL 7.55.0',
'CURLINFO_FILETIME_T' => 'Available since PHP 7.3.0 and cURL 7.59.0',
'CURLINFO_HEADER_OUT' => 'Available since PHP 5.1.3',
'CURLINFO_HTTP_CODE' => 'As of PHP 5.5.0 and cURL 7.10.8, this is a legacy alias of `CURLINFO_RESPONSE_CODE`',
'CURLINFO_HTTP_VERSION' => 'Available since PHP 7.3.0 and cURL 7.50.0',
'CURLINFO_LOCAL_IP' => 'Available since PHP 5.4.7',
'CURLINFO_LOCAL_PORT' => 'Available since PHP 5.4.7',
'CURLINFO_NAMELOOKUP_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLINFO_PRETRANSFER_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLINFO_PRIMARY_IP' => 'Available since PHP 5.4.7',
'CURLINFO_PRIMARY_PORT' => 'Available since PHP 5.4.7',
'CURLINFO_PRIVATE' => 'Available since PHP 5.2.4',
'CURLINFO_PROTOCOL' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLINFO_PROXY_SSL_VERIFYRESULT' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLINFO_REDIRECT_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLINFO_REDIRECT_URL' => 'Available since PHP 5.3.7',
'CURLINFO_RESPONSE_CODE' => 'Available since PHP 5.5.0 and cURL 7.10.8',
'CURLINFO_SCHEME' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLINFO_SIZE_DOWNLOAD_T' => 'Available since PHP 7.3.0 and cURL 7.50.0',
'CURLINFO_SIZE_UPLOAD_T' => 'Available since PHP 7.3.0 and cURL 7.50.0',
'CURLINFO_SPEED_DOWNLOAD_T' => 'Available since PHP 7.3.0 and cURL 7.50.0',
'CURLINFO_SPEED_UPLOAD_T' => 'Available since PHP 7.3.0 and cURL 7.50.0',
'CURLINFO_STARTTRANSFER_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLINFO_TOTAL_TIME_T' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLMOPT_CHUNK_LENGTH_PENALTY_SIZE' => 'Available since PHP 7.0.7 and cURL 7.30.0',
'CURLMOPT_CONTENT_LENGTH_PENALTY_SIZE' => 'Available since PHP 7.0.7 and cURL 7.30.0',
'CURLMOPT_MAX_HOST_CONNECTIONS' => 'Available since PHP 7.0.7 and cURL 7.30.0',
'CURLMOPT_MAX_PIPELINE_LENGTH' => 'Available since PHP 7.0.7 and cURL 7.30.0',
'CURLMOPT_MAX_TOTAL_CONNECTIONS' => 'Available since PHP 7.0.7 and cURL 7.30.0',
'CURLMOPT_MAXCONNECTS' => 'Available since PHP 5.5.0 and cURL 7.16.3.',
'CURLMOPT_PIPELINING' => 'Available since PHP 5.5.0 and cURL 7.16.0.',
'CURLMOPT_PUSHFUNCTION' => 'Available since PHP 7.1.0 and cURL 7.44.0',
'CURLOPT_ABSTRACT_UNIX_SOCKET' => 'Available since PHP 7.3.0 and cURL 7.53.0',
'CURLOPT_AUTOREFERER' => 'Available since PHP 5.1.0',
'CURLOPT_CLOSEPOLICY' => 'Removed in PHP 5.6.0.',
'CURLOPT_CONNECT_TO' => 'Available since PHP 7.0.7 and cURL 7.49.0',
'CURLOPT_COOKIELIST' => 'Available since PHP 5.5.0 and cURL 7.14.1',
'CURLOPT_COOKIESESSION' => 'Available since PHP 5.1.0',
'CURLOPT_DEFAULT_PROTOCOL' => 'Available since PHP 7.0.7 and cURL 7.45.0',
'CURLOPT_DISALLOW_USERNAME_IN_URL' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLOPT_DNS_INTERFACE' => 'Available since PHP 7.0.7 and cURL 7.33.0',
'CURLOPT_DNS_LOCAL_IP4' => 'Available since PHP 7.0.7 and cURL 7.33.0',
'CURLOPT_DNS_LOCAL_IP6' => 'Available since PHP 7.0.7 and cURL 7.33.0',
'CURLOPT_DNS_SHUFFLE_ADDRESSES' => 'Available since PHP 7.3.0 and cURL 7.60.0',
'CURLOPT_EXPECT_100_TIMEOUT_MS' => 'Available since PHP 7.0.7 and cURL 7.36.0',
'CURLOPT_FOLLOWLOCATION' => 'This constant is not available when open_basedir or safe_mode are enabled.',
'CURLOPT_FTP_SSL' => 'Available since PHP 5.2.0',
'CURLOPT_FTPSSLAUTH' => 'Available since PHP 5.1.0',
'CURLOPT_HAPPY_EYEBALLS_TIMEOUT_MS' => 'Available since PHP 7.3.0 and cURL 7.59.0',
'CURLOPT_HAPROXYPROTOCOL' => 'Available since PHP 7.3.0 and cURL 7.60.0',
'CURLOPT_HEADEROPT' => 'Available since PHP 7.0.7 and cURL 7.37.0',
'CURLOPT_HTTP09_ALLOWED ' => 'Available since PHP 7.3.15 and 7.4.3, respectively, and cURL 7.64.0',
'CURLOPT_KEEP_SENDING_ON_ERROR' => 'Available since PHP 7.3.0 and cURL 7.51.0',
'CURLOPT_LOGIN_OPTIONS' => 'Available since PHP 7.0.7 and cURL 7.34.0',
'CURLOPT_MAX_RECV_SPEED_LARGE' => 'Available since PHP 5.4.0 and cURL 7.15.5',
'CURLOPT_MAX_SEND_SPEED_LARGE' => 'Available since PHP 5.4.0 and cURL 7.15.5',
'CURLOPT_PATH_AS_IS' => 'Available since PHP 7.0.7 and cURL 7.42.0',
'CURLOPT_PINNEDPUBLICKEY' => 'Available since PHP 7.0.7 and cURL 7.39.0',
'CURLOPT_PIPEWAIT' => 'Available since PHP 7.0.7 and cURL 7.43.0',
'CURLOPT_PRE_PROXY' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PRIVATE' => 'Available since PHP 5.2.4',
'CURLOPT_PROGRESSFUNCTION' => 'Available since PHP 5.3.0',
'CURLOPT_PROXY_CAINFO' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_CAPATH' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_CRLFILE' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_KEYPASSWD' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_PINNEDPUBLICKEY' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SERVICE_NAME' => 'Available since PHP 7.0.7 and cURL 7.43.0',
'CURLOPT_PROXY_SSL_CIPHER_LIST' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSL_OPTIONS' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSL_VERIFYHOST' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSL_VERIFYPEER' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSLCERT' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSLCERTTYPE' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSLKEY' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSLKEYTYPE' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_SSLVERSION' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_TLS13_CIPHERS' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLOPT_PROXY_TLSAUTH_PASSWORD' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_TLSAUTH_TYPE' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXY_TLSAUTH_USERNAME' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLOPT_PROXYHEADER' => 'Available since PHP 7.0.7 and cURL 7.37.0',
'CURLOPT_PROXYTYPE' => 'Available as of cURL 7.10.',
'CURLOPT_REQUEST_TARGET' => 'Available since PHP 7.3.0 and cURL 7.55.0.',
'CURLOPT_SASL_IR' => 'Available since PHP 7.0.7 and cURL 7.31.0',
'CURLOPT_SERVICE_NAME' => 'Available since PHP 7.0.7 and cURL 7.43.0',
'CURLOPT_SOCKS5_AUTH' => 'Available since PHP 7.3.0 and cURL 7.55.0',
'CURLOPT_SSH_COMPRESSION' => 'Available since PHP 7.3.0 and cURL 7.56.0',
'CURLOPT_SSL_ENABLE_ALPN' => 'Available since PHP 7.0.7 and cURL 7.36.0',
'CURLOPT_SSL_ENABLE_NPN' => 'Available since PHP 7.0.7 and cURL 7.36.0',
'CURLOPT_SSL_FALSESTART' => 'Available since PHP 7.0.7 and cURL 7.42.0',
'CURLOPT_SSL_OPTIONS' => 'Available since PHP 5.5.0 and cURL 7.25.0',
'CURLOPT_SSL_VERIFYSTATUS' => 'Available since PHP 7.0.7 and cURL 7.41.0',
'CURLOPT_STREAM_WEIGHT' => 'Available since PHP 7.0.7 and cURL 7.46.0',
'CURLOPT_SUPPRESS_CONNECT_HEADERS' => 'Available since PHP 7.3.0 and cURL 7.54.0',
'CURLOPT_TCP_FASTOPEN' => 'Available since PHP 7.0.7 and cURL 7.49.0',
'CURLOPT_TCP_KEEPALIVE' => 'Available since PHP 5.5.0 and cURL 7.25.0',
'CURLOPT_TCP_KEEPIDLE' => 'Available since PHP 5.5.0 and cURL 7.25.0',
'CURLOPT_TCP_KEEPINTVL' => 'Available since PHP 5.5.0 and cURL 7.25.0',
'CURLOPT_TCP_NODELAY' => 'Available since PHP 5.2.1',
'CURLOPT_TFTP_NO_OPTIONS' => 'Available since PHP 7.0.7 and cURL 7.48.0',
'CURLOPT_TIMEVALUE_LARGE' => 'Available since PHP 7.3.0 and cURL 7.59.0',
'CURLOPT_TLS13_CIPHERS' => 'Available since PHP 7.3.0 and cURL 7.61.0',
'CURLOPT_UNIX_SOCKET_PATH' => 'Available since PHP 7.0.7 and cURL 7.40.0',
'CURLOPT_USERNAME' => 'Available since PHP 5.5.0 and cURL 7.19.1',
'CURLOPT_XOAUTH2_BEARER' => 'Available since PHP 7.0.7 and cURL 7.33.0',
'CURLPAUSE_ALL' => 'Available since PHP 5.5.0 and cURL 7.18.0.',
'CURLPAUSE_CONT' => 'Available since PHP 5.5.0 and cURL 7.18.0.',
'CURLPAUSE_RECV' => 'Available since PHP 5.5.0 and cURL 7.18.0.',
'CURLPAUSE_RECV_CONT' => 'Available since PHP 5.5.0 and cURL 7.18.0.',
'CURLPAUSE_SEND' => 'Available since PHP 5.5.0 and cURL 7.18.0.',
'CURLPAUSE_SEND_CONT' => 'Available since PHP 5.5.0 and cURL 7.18.0.',
'CURLPIPE_HTTP1' => 'Available since PHP 7.0.0 and cURL 7.43.0.',
'CURLPIPE_MULTIPLEX' => 'Available since PHP 7.0.0 and cURL 7.43.0.',
'CURLPIPE_NOTHING' => 'Available since PHP 7.0.0 and cURL 7.43.0.',
'CURLPROTO_SMB' => 'Available since PHP 7.0.7 and cURL 7.40.0.',
'CURLPROTO_SMBS' => 'Available since PHP 7.0.7 and cURL 7.40.0.',
'CURLPROXY_HTTP' => 'Available since cURL 7.10.',
'CURLPROXY_HTTP_1_0' => 'Available since PHP 7.0.7 and cURL 7.19.3',
'CURLPROXY_HTTPS' => 'Available since PHP 7.3.0 and cURL 7.52.0',
'CURLPROXY_SOCKS4' => 'Available since PHP 5.2.10 and cURL 7.10.',
'CURLPROXY_SOCKS4A' => 'Available since PHP 5.5.23 and PHP 5.6.7 and cURL 7.18.0.',
'CURLPROXY_SOCKS5' => 'Available since cURL 7.10.',
'CURLPROXY_SOCKS5_HOSTNAME' => 'Available since PHP 5.5.23 and PHP 5.6.7 and cURL 7.18.0.',
'CURLSSH_AUTH_AGENT' => 'Available since PHP 7.0.7 and cURL 7.28.0',
'CURLSSH_AUTH_GSSAPI' => 'Available since PHP 7.3.0 and cURL 7.58.0',
'CURLSSLOPT_ALLOW_BEAST' => 'Available since PHP 5.5.0 and cURL 7.25.0',
'CURLSSLOPT_NO_REVOKE' => 'Available since PHP 7.0.7 and cURL 7.44.0',
'DB2_AUTOCOMMIT_OFF' => 'Specifies that autocommit should be turned off.',
'DB2_AUTOCOMMIT_ON' => 'Specifies that autocommit should be turned on.',
'DB2_BINARY' => 'Specifies that binary data shall be returned as is. This is the default mode.',
'DB2_CASE_LOWER' => 'Specifies that column names will be returned in lower case.',
'DB2_CASE_NATURAL' => 'Specifies that column names will be returned in their natural case.',
'DB2_CASE_UPPER' => 'Specifies that column names will be returned in upper case.',
'DB2_CHAR' => 'Specifies that the variable should be bound as a CHAR or VARCHAR data type.',
'DB2_CONVERT' => 'Specifies that binary data shall be converted to a hexadecimal encoding and returned as an ASCII string.',
'DB2_DEFERRED_PREPARE_OFF' => 'Specifies that deferred prepare should be turned off for the specified statement resource.',
'DB2_DEFERRED_PREPARE_ON' => 'Specifies that deferred prepare should be turned on for the specified statement resource.',
'DB2_DOUBLE' => 'Specifies that the variable should be bound as a DOUBLE, FLOAT, or REAL data type.',
'DB2_FORWARD_ONLY' => 'Specifies a forward-only cursor for a statement resource. This is the default cursor type and is supported on all database servers.',
'DB2_LONG' => 'Specifies that the variable should be bound as a SMALLINT, INTEGER, or BIGINT data type.',
'DB2_PARAM_FILE' => 'Specifies that the column should be bound directly to a file for input.',
'DB2_PARAM_IN' => 'Specifies the PHP variable should be bound as an IN parameter for a stored procedure.',
'DB2_PARAM_INOUT' => 'Specifies the PHP variable should be bound as an INOUT parameter for a stored procedure.',
'DB2_PARAM_OUT' => 'Specifies the PHP variable should be bound as an OUT parameter for a stored procedure.',
'DB2_PASSTHRU' => 'Specifies that binary data shall be converted to a `null` value.',
'DB2_SCROLLABLE' => 'Specifies a scrollable cursor for a statement resource. This mode enables random access to rows in a result set, but currently is supported only by IBM DB2 Universal Database.',
'DBASE_RDONLY' => 'Open database for reading only. Used with `dbase_open`. (Available as of dbase 7.0.0)',
'DBASE_RDWR' => 'Open database for reading and writing. Used with `dbase_open`. (Available as of dbase 7.0.0)',
'DBASE_TYPE_DBASE' => 'Create dBASE style database. Used with `dbase_create`. (Available as of dbase 7.0.0)',
'DBASE_TYPE_FOXPRO' => 'Create FoxPro style database. Used with `dbase_create`. (Available as of dbase 7.0.0)',
'DBASE_VERSION' => 'The extension version. (Available as of dbase 7.0.0)',
'E_ALL' => 'Error reporting constant',
'E_COMPILE_ERROR' => 'Error reporting constant',
'E_COMPILE_WARNING' => 'Error reporting constant',
'E_CORE_ERROR' => 'Error reporting constant',
'E_CORE_WARNING' => 'Error reporting constant',
'E_DEPRECATED' => 'Error reporting constant.',
'E_ERROR' => 'Error reporting constant',
'E_NOTICE' => 'Error reporting constant',
'E_PARSE' => 'Error reporting constant',
'E_RECOVERABLE_ERROR' => 'Error reporting constant.',
'E_STRICT' => 'Error reporting constant',
'E_USER_DEPRECATED' => 'Error reporting constant.',
'E_USER_ERROR' => 'Error reporting constant',
'E_USER_NOTICE' => 'Error reporting constant',
'E_USER_WARNING' => 'Error reporting constant',
'E_WARNING' => 'Error reporting constant',
'EIO_DT_BLK' => 'Node type',
'EIO_DT_CHR' => 'Node type',
'EIO_DT_CMP' => 'HP-UX network special node type',
'EIO_DT_DIR' => 'Directory node type',
'EIO_DT_DOOR' => 'Solaris door node type',
'EIO_DT_FIFO' => 'FIFO node type',
'EIO_DT_LNK' => 'Link node type',
'EIO_DT_MAX' => 'Highest node type value',
'EIO_DT_MPB' => 'Multiplexed block device (v7+coherent)',
'EIO_DT_MPC' => 'Multiplexed char device (v7+coherent) node type',
'EIO_DT_NAM' => 'Xenix special named file node type',
'EIO_DT_REG' => 'Node type',
'EIO_DT_SOCK' => 'Socket node type',
'EIO_DT_UNKNOWN' => 'Unknown node type(very common). Further `stat` needed.',
'EIO_DT_WHT' => 'Node type',
'EIO_PRI_DEFAULT' => 'Request default prioriry',
'EIO_PRI_MAX' => 'Request maximal prioriry',
'EIO_PRI_MIN' => 'Request minimal prioriry',
'EIO_READDIR_DENTS' => '`eio_readdir` flag. If specified, the result argument of the callback becomes an array with the following keys: `\'names\'` - array of directory names `\'dents\'` - array of `struct eio_dirent`-like arrays having the following keys each: `\'name\'` - the directory name; `\'type\'` - one of *EIO_DT_** constants; `\'inode\'` - the inode number, if available, otherwise unspecified;',
'EIO_READDIR_DIRS_FIRST' => 'When this flag is specified, the names will be returned in an order where likely directories come first, in optimal stat order.',
'EIO_READDIR_STAT_ORDER' => 'When this flag is specified, then the names will be returned in an order suitable for `stat`\'ing each one. When planning to `stat` all files in the given directory, the returned order will likely be fastest.',
'EIO_SEEK_CUR' => 'The offset is set to its current location plus offset bytes.',
'EIO_SEEK_END' => 'The offset is set to the size of the file plus offset bytes.',
'EIO_SEEK_SET' => 'The offset is set to specified number of bytes(offset).',
'ENC7BIT' => 'Body encoding: 7 bit SMTP semantic data',
'ENC8BIT' => 'Body encoding: 8 bit SMTP semantic data',
'ENCBASE64' => 'Body encoding: base-64 encoded data',
'ENCBINARY' => 'Body encoding: 8 bit binary data',
'ENCHANT_ISPELL' => 'Dictionary type for Ispell. Used with `enchant_broker_get_dict_path` and `enchant_broker_set_dict_path`.',
'ENCHANT_MYSPELL' => 'Dictionary type for MySpell. Used with `enchant_broker_get_dict_path` and `enchant_broker_set_dict_path`.',
'ENCOTHER' => 'Body encoding: unknown',
'ENCQUOTEDPRINTABLE' => 'Body encoding: human-readable 8-as-7 bit data',
'Ev::BACKEND_ALL' => 'Try all backends(even corrupted ones). It\'s not recommended to use it explicitly. Bitwise operators should be
applied here(e.g. Ev::BACKEND_ALL & ~ Ev::BACKEND_KQUEUE ) Use Ev::recommendedBackends() , or don\'t specify any
backends at all.',
'Ev::BACKEND_DEVPOLL' => 'Solaris 8 backend. This is not implemented yet.',
'Ev::BACKEND_EPOLL' => 'Linux-specific epoll(7) backend for both pre- and post-2.6.9 kernels',
'Ev::BACKEND_KQUEUE' => 'kqueue backend used on most BSD systems. EvEmbed watcher could be used to embed one loop(with kqueue backend)
into another. For instance, one can try to create an event loop with kqueue backend and use it for sockets only.',
'Ev::BACKEND_MASK' => 'Not a backend, but a mask to select all backend bits from flags value to mask out any backends(e.g. when
modifying the LIBEV_FLAGS environment variable).',
'Ev::BACKEND_POLL' => 'poll(2) backend',
'Ev::BACKEND_PORT' => 'Solaris 10 event port mechanism with a good scaling.',
'Ev::BACKEND_SELECT' => 'select(2) backend',
'Ev::BREAK_ALL' => 'Flag passed to Ev::stop() or EvLoop::stop(): Makes all nested Ev::run() or EvLoop::run() calls return.',
'Ev::BREAK_CANCEL' => 'Flag passed to Ev::stop() or EvLoop::stop(): Cancel the break operation.',
'Ev::BREAK_ONE' => 'Flag passed to Ev::stop() or EvLoop::stop(): Makes the innermost Ev::run() or EvLoop::run() call return.',
'Ev::CHECK' => 'Event bitmask: All EvCheck watchers are queued just after Ev::run() has gathered the new events, but before it
queues any callbacks for any received events. Thus, EvCheck watchers will be invoked before any other watchers
of the same or lower priority within an event loop iteration.',
'Ev::CHILD' => 'Event bitmask: The pid specified in EvChild::__construct() has received a status change.',
'Ev::CUSTOM' => 'Event bitmask: Not ever sent(or otherwise used) by libev itself, but can be freely used by libev users to signal
watchers (e.g. via EvWatcher::feed() ).',
'Ev::EMBED' => 'Event bitmask: The embedded event loop specified in the EvEmbed watcher needs attention.',
'Ev::ERROR' => 'Event bitmask: An unspecified error has occurred, the watcher has been stopped. This might happen because the
watcher could not be properly started because libev ran out of memory, a file descriptor was found to be closed
or any other problem. Libev considers these application bugs.',
'Ev::FLAG_AUTO' => 'Flag passed to create a loop: The default flags value',
'Ev::FLAG_FORKCHECK' => 'Flag passed to create a loop: Makes libev check for a fork in each iteration, instead of calling EvLoop::fork()
manually. This works by calling getpid() on every iteration of the loop, and thus this might slow down the event
loop with lots of loop iterations, but usually is not noticeable. This flag setting cannot be overridden or
specified in the LIBEV_FLAGS environment variable.',
'Ev::FLAG_NOENV' => 'Flag passed to create a loop: If this flag used(or the program runs setuid or setgid), libev won\'t look at the
environment variable LIBEV_FLAGS. Otherwise(by default), LIBEV_FLAGS will override the flags completely if it is
found. Useful for performance tests and searching for bugs.',
'Ev::FLAG_NOINOTIFY' => 'Flag passed to create a loop: When this flag is specified, libev won\'t attempt to use the inotify API for its
ev_stat watchers. The flag can be useful to conserve inotify file descriptors, as otherwise each loop using
ev_stat watchers consumes one inotify handle.',
'Ev::FLAG_NOSIGMASK' => 'Flag passed to create a loop: When this flag is specified, libev will avoid to modify the signal mask.
Specifically, this means having to make sure signals are unblocked before receiving them.

This behaviour is useful for custom signal handling, or handling signals only in specific threads.',
'Ev::FLAG_SIGNALFD' => 'Flag passed to create a loop: When this flag is specified, libev will attempt to use the signalfd API for its
ev_signal (and ev_child ) watchers. This API delivers signals synchronously, which makes it both faster and might
make it possible to get the queued signal data. It can also simplify signal handling with threads, as long as
signals are properly blocked in threads. Signalfd will not be used by default.',
'Ev::IDLE' => 'Event bitmask: EvIdle watcher works when there is nothing to do with other watchers.',
'Ev::MAXPRI' => 'Highest allowed watcher priority.',
'Ev::MINPRI' => 'Lowest allowed watcher priority.',
'Ev::PERIODIC' => 'Event bitmask: EvPeriodic watcher has been timed out.',
'Ev::PREPARE' => 'Event bitmask: All EvPrepare watchers are invoked just before Ev::run() starts. Thus, EvPrepare watchers are the
last watchers invoked before the event loop sleeps or polls for new events.',
'Ev::READ' => 'Event bitmask: The file descriptor in the EvIo watcher has become readable.',
'Ev::RUN_NOWAIT' => 'Flag passed to Ev::run() or EvLoop::run(): Means that event loop will look for new events, will handle those
events and any already outstanding ones, but will not wait and block the process in case there are no events and
will return after one iteration of the loop. This is sometimes useful to poll and handle new events while doing
lengthy calculations, to keep the program responsive.',
'Ev::RUN_ONCE' => 'Flag passed to Ev::run() or EvLoop::run(): Means that event loop will look for new events (waiting if necessary)
and will handle those and any already outstanding ones. It will block the process until at least one new event
arrives (which could be an event internal to libev itself, so there is no guarantee that a user-registered
callback will be called), and will return after one iteration of the loop.',
'Ev::SIGNAL' => 'Event bitmask: A signal specified in EvSignal::__construct() has been received.',
'Ev::STAT' => 'Event bitmask: The path specified in EvStat watcher changed its attributes.',
'Ev::TIMER' => 'Event bitmask: EvTimer watcher has been timed out.',
'Ev::WRITE' => 'Event bitmask: The file descriptor in the EvIo watcher has become writable.',
'EXIF_USE_MBSTRING' => 'This constant have a value of `1` if the mbstring is enabled, otherwise the value is `0`.',
'EXP_EOF' => 'Value, returned by `expect_expectl`, when EOF is reached.',
'EXP_EXACT' => 'Indicates that the pattern is an exact string.',
'EXP_FULLBUFFER' => 'Value, returned by `expect_expectl` if no pattern have been matched.',
'EXP_GLOB' => 'Indicates that the pattern is a glob-style string pattern.',
'EXP_REGEXP' => 'Indicates that the pattern is a regexp-style string pattern.',
'EXP_TIMEOUT' => 'Value, returned by `expect_expectl` upon timeout of seconds, specified in value of expect.timeout',
'FANN_COS' => 'Periodical cosinus activation function.',
'FANN_COS_SYMMETRIC' => 'Periodical cosinus activation function.',
'FANN_E_CANT_ALLOCATE_MEM' => 'Unable to allocate memory.',
'FANN_E_CANT_OPEN_CONFIG_R' => 'Unable to open configuration file for reading.',
'FANN_E_CANT_OPEN_CONFIG_W' => 'Unable to open configuration file for writing.',
'FANN_E_CANT_OPEN_TD_R' => 'Unable to open train data file for reading.',
'FANN_E_CANT_OPEN_TD_W' => 'Unable to open train data file for writing.',
'FANN_E_CANT_READ_CONFIG' => 'Error reading info from configuration file.',
'FANN_E_CANT_READ_CONNECTIONS' => 'Error reading connections from configuration file.',
'FANN_E_CANT_READ_NEURON' => 'Error reading neuron info from configuration file.',
'FANN_E_CANT_READ_TD' => 'Error reading training data from file.',
'FANN_E_CANT_TRAIN_ACTIVATION' => 'Unable to train with the selected activation function.',
'FANN_E_CANT_USE_ACTIVATION' => 'Unable to use the selected activation function.',
'FANN_E_CANT_USE_TRAIN_ALG' => 'Unable to use the selected training algorithm.',
'FANN_E_INDEX_OUT_OF_BOUND' => 'Index is out of bound.',
'FANN_E_INPUT_NO_MATCH' => 'The number of input neurons in the ann data do not match',
'FANN_E_NO_ERROR' => 'No error.',
'FANN_E_OUTPUT_NO_MATCH' => 'The number of output neurons in the ann and data do not match.',
'FANN_E_SCALE_NOT_PRESENT' => 'Scaling parameters not present.',
'FANN_E_TRAIN_DATA_MISMATCH' => 'Irreconcilable differences between two struct fann_train_data structures.',
'FANN_E_TRAIN_DATA_SUBSET' => 'Trying to take subset which is not within the training set.',
'FANN_E_WRONG_CONFIG_VERSION' => 'Wrong version of configuration file.',
'FANN_E_WRONG_NUM_CONNECTIONS' => 'Number of connections not equal to the number expected.',
'FANN_ELLIOT' => 'Fast (sigmoid like) activation function defined by David Elliott.',
'FANN_ELLIOT_SYMMETRIC' => 'Fast (symmetric sigmoid like) activation function defined by David Elliott.',
'FANN_ERRORFUNC_LINEAR' => 'Standard linear error function.',
'FANN_ERRORFUNC_TANH' => 'Tanh error function, usually better but can require a lower learning rate. This error function aggressively targets outputs that differ much from the desired, while not targeting outputs that only differ a little that much. This activation function is not recommended for cascade training and incremental training.',
'FANN_GAUSSIAN' => 'Gaussian activation function.',
'FANN_GAUSSIAN_STEPWISE' => 'Stepwise gaussian activation function.',
'FANN_GAUSSIAN_SYMMETRIC' => 'Symmetric gaussian activation function.',
'FANN_LINEAR' => 'Linear activation function.',
'FANN_LINEAR_PIECE' => 'Bounded linear activation function.',
'FANN_LINEAR_PIECE_SYMMETRIC' => 'Bounded linear activation function.',
'FANN_NETTYPE_LAYER' => 'Each layer only has connections to the next layer.',
'FANN_NETTYPE_SHORTCUT' => 'Each layer has connections to all following layers',
'FANN_SIGMOID' => 'Sigmoid activation function.',
'FANN_SIGMOID_STEPWISE' => 'Stepwise linear approximation to sigmoid.',
'FANN_SIGMOID_SYMMETRIC' => 'Symmetric sigmoid activation function, aka. tanh.',
'FANN_SIGMOID_SYMMETRIC_STEPWISE' => 'Stepwise linear approximation to symmetric sigmoid',
'FANN_SIN' => 'Periodical sinus activation function.',
'FANN_SIN_SYMMETRIC' => 'Periodical sinus activation function.',
'FANN_STOPFUNC_BIT' => 'Stop criteria is number of bits that fail. The number of bits means the number of output neurons which differs more than the bit fail limit (see fann_get_bit_fail_limit, fann_set_bit_fail_limit). The bits are counted in all of the training data, so this number can be higher than the number of training data.',
'FANN_STOPFUNC_MSE' => 'Stop criteria is Mean Square Error (MSE) value.',
'FANN_THRESHOLD' => 'Threshold activation function.',
'FANN_THRESHOLD_SYMMETRIC' => 'Threshold activation function.',
'FANN_TRAIN_BATCH' => 'Standard backpropagation algorithm, where the weights are updated after calculating the mean square error for the whole training set. This means that the weights are only updated once during a epoch. For this reason some problems, will train slower with this algorithm. But since the mean square error is calculated more correctly than in incremental training, some problems will reach a better solutions with this algorithm.',
'FANN_TRAIN_INCREMENTAL' => 'Standard backpropagation algorithm, where the weights are updated after each training pattern. This means that the weights are updated many times during a single epoch. For this reason some problems, will train very fast with this algorithm, while other more advanced problems will not train very well.',
'FANN_TRAIN_QUICKPROP' => 'A more advanced batch training algorithm which achieves good results for many problems. The quickprop training algorithm uses the learning_rate parameter along with other more advanced parameters, but it is only recommended to change these advanced parameters, for users with insight in how the quickprop training algorithm works. The quickprop training algorithm is described by [Fahlman, 1988].',
'FANN_TRAIN_RPROP' => 'A more advanced batch training algorithm which achieves good results for many problems. The RPROP training algorithm is adaptive, and does therefore not use the learning_rate. Some other parameters can however be set to change the way the RPROP algorithm works, but it is only recommended for users with insight in how the RPROP training algorithm works. The RPROP training algorithm is described by [Riedmiller and Braun, 1993], but the actual learning algorithm used here is the iRPROP- training algorithm which is described by [Igel and Husken, 2000] which is an variety of the standard RPROP training algorithm.',
'FANN_TRAIN_SARPROP' => 'Even more advance training algorithm. Only for version 2.2',
'FILE_APPEND' => 'Append content to existing file.',
'FILE_BINARY' => 'Binary mode (since PHP 5.2.7). This constant has no effect, and is only available for `forward compatibility`.',
'FILE_IGNORE_NEW_LINES' => 'Strip EOL characters.',
'FILE_SKIP_EMPTY_LINES' => 'Skip empty lines.',
'FILE_TEXT' => 'Text mode (since PHP 5.2.7). This constant has no effect, and is only available for `forward compatibility`.',
'FILE_USE_INCLUDE_PATH' => 'Search for filename in include_path.',
'FILEINFO_COMPRESS' => 'Decompress compressed files.

Disabled since PHP 5.3.0 due to thread safety issues.',
'FILEINFO_CONTINUE' => 'Return all matches, not just the first.',
'FILEINFO_DEVICES' => 'Look at the contents of blocks or character special devices.',
'FILEINFO_EXTENSION' => 'Returns the file extension appropriate for a the MIME type detected in the file.

For types that commonly have multiple file extensions, such as `JPEG` images, then the return value is multiple extensions separated by a forward slash e.g.: `"jpeg/jpg/jpe/jfif"`. For unknown types not available in the magic.mime database, then return value is `"???"`.

Available since PHP 7.2.0.',
'FILEINFO_MIME' => 'Return the mime type and mime encoding as defined by RFC 2045.',
'FILEINFO_MIME_ENCODING' => 'Return the mime encoding of the file.',
'FILEINFO_MIME_TYPE' => 'Return the mime type.',
'FILEINFO_NONE' => 'No special handling.',
'FILEINFO_PRESERVE_ATIME' => 'If possible preserve the original access time.',
'FILEINFO_RAW' => 'Don\'t translate unprintable characters to a `\ooo` octal representation.',
'FILEINFO_SYMLINK' => 'Follow symlinks.',
'FILTER_CALLBACK' => 'ID of "callback" filter.',
'FILTER_DEFAULT' => 'ID of default ("unsafe_raw") filter. This is equivalent to `FILTER_UNSAFE_RAW`.',
'FILTER_FLAG_ALLOW_FRACTION' => 'Allow fractional part in "number_float" filter.',
'FILTER_FLAG_ALLOW_HEX' => 'Allow hex notation (`0x[0-9a-fA-F]+`) in "int" filter.',
'FILTER_FLAG_ALLOW_OCTAL' => 'Allow octal notation (`0[0-7]+`) in "int" filter.',
'FILTER_FLAG_ALLOW_SCIENTIFIC' => 'Allow scientific notation (`e`, `E`) in "number_float" filter.',
'FILTER_FLAG_ALLOW_THOUSAND' => 'Allow thousand separator (`,`) in "number_float" filter.',
'FILTER_FLAG_EMAIL_UNICODE' => 'Accepts Unicode characters in the local part in "validate_email" filter. (Available as of PHP 7.1.0)',
'FILTER_FLAG_EMPTY_STRING_NULL' => '(No use for now.)',
'FILTER_FLAG_ENCODE_AMP' => 'Encode `&amp;`.',
'FILTER_FLAG_ENCODE_HIGH' => 'Encode characters with ASCII value greater than 127.',
'FILTER_FLAG_ENCODE_LOW' => 'Encode characters with ASCII value less than 32.',
'FILTER_FLAG_IPV4' => 'Allow only IPv4 address in "validate_ip" filter.',
'FILTER_FLAG_IPV6' => 'Allow only IPv6 address in "validate_ip" filter.',
'FILTER_FLAG_NO_ENCODE_QUOTES' => 'Don\'t encode `\'` and `"`.',
'FILTER_FLAG_NO_PRIV_RANGE' => 'Deny private addresses in "validate_ip" filter.',
'FILTER_FLAG_NO_RES_RANGE' => 'Deny reserved addresses in "validate_ip" filter.',
'FILTER_FLAG_NONE' => 'No flags.',
'FILTER_FLAG_PATH_REQUIRED' => 'Require path in "validate_url" filter.',
'FILTER_FLAG_QUERY_REQUIRED' => 'Require query in "validate_url" filter.',
'FILTER_FLAG_STRIP_HIGH' => 'Strip characters with ASCII value greater than 127.',
'FILTER_FLAG_STRIP_LOW' => 'Strip characters with ASCII value less than 32.',
'FILTER_FORCE_ARRAY' => 'Always returns an array.',
'FILTER_NULL_ON_FAILURE' => 'Use NULL instead of FALSE on failure.',
'FILTER_REQUIRE_ARRAY' => 'Require an array as input.',
'FILTER_REQUIRE_SCALAR' => 'Flag used to require scalar as input',
'FILTER_SANITIZE_EMAIL' => 'ID of "email" filter.',
'FILTER_SANITIZE_ENCODED' => 'ID of "encoded" filter.',
'FILTER_SANITIZE_MAGIC_QUOTES' => 'ID of "magic_quotes" filter.',
'FILTER_SANITIZE_NUMBER_FLOAT' => 'ID of "number_float" filter.',
'FILTER_SANITIZE_NUMBER_INT' => 'ID of "number_int" filter.',
'FILTER_SANITIZE_SPECIAL_CHARS' => 'ID of "special_chars" filter.',
'FILTER_SANITIZE_STRING' => 'ID of "string" filter.',
'FILTER_SANITIZE_STRIPPED' => 'ID of "stripped" filter.',
'FILTER_SANITIZE_URL' => 'ID of "url" filter.',
'FILTER_UNSAFE_RAW' => 'ID of "unsafe_raw" filter.',
'FILTER_VALIDATE_BOOLEAN' => 'ID of "boolean" filter.',
'FILTER_VALIDATE_EMAIL' => 'ID of "validate_email" filter.',
'FILTER_VALIDATE_FLOAT' => 'ID of "float" filter.',
'FILTER_VALIDATE_INT' => 'ID of "int" filter.',
'FILTER_VALIDATE_IP' => 'ID of "validate_ip" filter.',
'FILTER_VALIDATE_MAC' => 'ID of "validate_mac_address" filter. (Available as of PHP 5.5.0)',
'FILTER_VALIDATE_REGEXP' => 'ID of "validate_regexp" filter.',
'FILTER_VALIDATE_URL' => 'ID of "validate_url" filter.',
'FNM_CASEFOLD' => 'Caseless match. Part of the GNU extension.',
'FNM_NOESCAPE' => 'Disable backslash escaping.',
'FNM_PATHNAME' => 'Slash in string only matches slash in the given pattern.',
'FNM_PERIOD' => 'Leading period in string must be exactly matched by period in the given pattern.',
'FPE_FLTDIV' => 'Available since PHP 5.3.0.',
'FPE_FLTINV' => 'Available since PHP 5.3.0.',
'FPE_FLTOVF' => 'Available since PHP 5.3.0.',
'FPE_FLTRES' => 'Available since PHP 5.3.0.',
'FPE_FLTSUB' => 'Available since PHP 5.3.0.',
'FPE_FLTUND' => 'Available since PHP 5.3.0.',
'FPE_INTDIV' => 'Available since PHP 5.3.0.',
'FPE_INTOVF' => 'Available since PHP 5.3.0.',
'FRIBIDI_AUTO' => 'Autodetect the base direction',
'FRIBIDI_CHARSET_8859_6' => 'Arabic',
'FRIBIDI_CHARSET_8859_8' => 'Hebrew',
'FRIBIDI_CHARSET_CAP_RTL' => 'Used for test purposes, will treat CAPS as non-English letters',
'FRIBIDI_CHARSET_CP1255' => 'Hebrew/Yiddish',
'FRIBIDI_CHARSET_CP1256' => 'Arabic',
'FRIBIDI_CHARSET_ISIRI_3342' => 'Persian',
'FRIBIDI_CHARSET_UTF8' => 'Unicode',
'FRIBIDI_LTR' => 'Left to right',
'FRIBIDI_RTL' => 'Right to left',
'FT_INTERNAL' => 'The return string is in internal format, will not canonicalize to CRLF.',
'FT_PEEK' => 'Do not set the \Seen flag if not already set',
'FT_UID' => 'The parameter is a UID',
'FTP_AUTORESUME' => 'Automatically determine resume position and start position for GET and PUT requests (only works if FTP_AUTOSEEK is enabled)',
'FTP_AUTOSEEK' => 'See `ftp_set_option` for information.',
'FTP_FAILED' => 'Asynchronous transfer has failed',
'FTP_FINISHED' => 'Asynchronous transfer has finished',
'FTP_IMAGE' => 'Alias of `FTP_BINARY`.',
'FTP_MOREDATA' => 'Asynchronous transfer is still active',
'FTP_TEXT' => 'Alias of `FTP_ASCII`.',
'FTP_TIMEOUT_SEC' => 'See `ftp_set_option` for information.',
'FTP_USEPASVADDRESS' => 'See `ftp_set_option` for information. Available as of PHP 5.6.0.',
'GD_BUNDLED' => 'When the bundled version of GD is used this is 1 otherwise its set to 0.',
'GD_EXTRA_VERSION' => 'The GD "extra" version (beta/rc..) PHP was compiled against. (Available as of PHP 5.2.4)',
'GD_MAJOR_VERSION' => 'The GD major version PHP was compiled against. (Available as of PHP 5.2.4)',
'GD_MINOR_VERSION' => 'The GD minor version PHP was compiled against. (Available as of PHP 5.2.4)',
'GD_RELEASE_VERSION' => 'The GD release version PHP was compiled against. (Available as of PHP 5.2.4)',
'GD_VERSION' => 'The GD version PHP was compiled against. (Available as of PHP 5.2.4)',
'GEARMAN_CLIENT_FREE_TASKS' => 'Automatically free task objects once they are complete. This is the default setting in this extension to prevent memory leaks.',
'GEARMAN_CLIENT_GENERATE_UNIQUE' => 'Generate a unique id (UUID) for each task.',
'GEARMAN_CLIENT_NON_BLOCKING' => 'Run the cient in a non-blocking mode.',
'GEARMAN_CLIENT_UNBUFFERED_RESULT' => 'Allow the client to read data in chunks rather than have the library buffer the entire data result and pass that back.',
'GEARMAN_COULD_NOT_CONNECT' => 'Failed to connect to servers.',
'GEARMAN_ECHO_DATA_CORRUPTION' => 'After `GearmanClient::echo` or `GearmanWorker::echo` the data returned doesn\'t match the data sent.',
'GEARMAN_ERRNO' => 'A system error. Check `GearmanClient::errno` or `GearmanWorker::errno` for the system error code that was returned.',
'GEARMAN_GETADDRINFO' => 'DNS resolution failed (invalid host, port, etc).',
'GEARMAN_INVALID_FUNCTION_NAME' => 'Trying to register a function name of NULL or using the callback interface without specifying callbacks.',
'GEARMAN_INVALID_WORKER_FUNCTION' => 'Trying to register a function with a NULL callback function.',
'GEARMAN_IO_WAIT' => 'When in non-blocking mode, an event is hit that would have blocked.',
'GEARMAN_LOST_CONNECTION' => 'Lost a connection during a request.',
'GEARMAN_MEMORY_ALLOCATION_FAILURE' => 'Memory allocation failed (ran out of memory).',
'GEARMAN_NEED_WORKLOAD_FN' => 'When the client opted to stream the workload of a task, but did not specify a workload callback function.',
'GEARMAN_NO_ACTIVE_FDS' => '`GearmanClient::wait` or `GearmanWorker` was called with no connections.',
'GEARMAN_NO_JOBS' => 'For a non-blocking worker, when `GearmanWorker::work` does not have any active jobs.',
'GEARMAN_NO_REGISTERED_FUNCTIONS' => 'When a worker gets a job for a function it did not register.',
'GEARMAN_NO_SERVERS' => 'Did not call `GearmanClient::addServer` before submitting jobs or tasks.',
'GEARMAN_PAUSE' => 'For the non-blocking client task interface, can be returned from the task callback to "pause" the call and return from `GearmanClient::runTasks`. Call `GearmanClient::runTasks` again to continue.',
'GEARMAN_SEND_BUFFER_TOO_SMALL' => 'Internal error: trying to flush more data in one atomic chunk than is possible due to hard-coded buffer sizes.',
'GEARMAN_SERVER_ERROR' => 'Something went wrong in the Gearman server and it could not handle the request gracefully.',
'GEARMAN_SUCCESS' => 'Whatever action was taken was successful.',
'GEARMAN_TIMEOUT' => 'Hit the timeout limit set by the client/worker.',
'GEARMAN_UNEXPECTED_PACKET' => 'Indicates something going very wrong in gearmand. Applies only to `GearmanWorker`.',
'GEARMAN_UNKNOWN_STATE' => 'Internal client/worker state error.',
'GEARMAN_WORK_DATA' => 'Notice return code obtained with `GearmanClient::returnCode` when using `GearmanClient::do`. Sent to update the client with data from a running job. A worker uses this when it needs to send updates, send partial results, or flush data during long running jobs.',
'GEARMAN_WORK_EXCEPTION' => 'Notice return code obtained with `GearmanClient::returnCode` when using `GearmanClient::do`. Indicates that a job failed with a given exception.',
'GEARMAN_WORK_FAIL' => 'Notice return code obtained with `GearmanClient::returnCode` when using `GearmanClient::do`. Indicates that the job failed.',
'GEARMAN_WORK_STATUS' => 'Notice return code obtained with `GearmanClient::returnCode` when using `GearmanClient::do`. Sent to update the status of a long running job. Use `GearmanClient::doStatus` to obtain the percentage complete of the task.',
'GEARMAN_WORK_WARNING' => 'Notice return code obtained with `GearmanClient::returnCode` when using `GearmanClient::do`. Updates the client with a warning. The behavior is just like `GEARMAN_WORK_DATA`, but should be treated as a warning instead of normal response data.',
'GEARMAN_WORKER_GRAB_UNIQ' => 'Return the client assigned unique ID in addition to the job handle.',
'GEARMAN_WORKER_NON_BLOCKING' => 'Run the worker in non-blocking mode.',
'Gmagick::COLOR_ALPHA' => 'Alpha',
'Gmagick::COLOR_BLACK' => 'Black',
'Gmagick::COLOR_BLUE' => 'Blue',
'Gmagick::COLOR_CYAN' => 'Cyan',
'Gmagick::COLOR_FUZZ' => 'Fuzz',
'Gmagick::COLOR_GREEN' => 'Green',
'Gmagick::COLOR_MAGENTA' => 'Magenta',
'Gmagick::COLOR_OPACITY' => 'Opacity',
'Gmagick::COLOR_RED' => 'Red',
'Gmagick::COLOR_YELLOW' => 'Yellow',
'Gmagick::COMPOSITE_ADD' => 'The result of image + image',
'Gmagick::COMPOSITE_ATOP' => 'The result is the same shape as image, with composite image obscuring image where the image shapes overlap',
'Gmagick::COMPOSITE_BLEND' => 'Blends the image',
'Gmagick::COMPOSITE_BUMPMAP' => 'The same as COMPOSITE_MULTIPLY, except the source is converted to grayscale first.',
'Gmagick::COMPOSITE_CLEAR' => 'Makes the target image transparent',
'Gmagick::COMPOSITE_COLORBURN' => 'Darkens the destination image to reflect the source image',
'Gmagick::COMPOSITE_COLORDODGE' => 'Brightens the destination image to reflect the source image',
'Gmagick::COMPOSITE_COLORIZE' => 'Colorizes the target image using the composite image',
'Gmagick::COMPOSITE_COPY' => 'Copies the source image on the target image',
'Gmagick::COMPOSITE_COPYBLACK' => 'Copies black from the source to target',
'Gmagick::COMPOSITE_COPYBLUE' => 'Copies blue from the source to target',
'Gmagick::COMPOSITE_COPYCYAN' => 'Copies cyan from the source to target',
'Gmagick::COMPOSITE_COPYGREEN' => 'Copies green from the source to target',
'Gmagick::COMPOSITE_COPYMAGENTA' => 'Copies magenta from the source to target',
'Gmagick::COMPOSITE_COPYOPACITY' => 'Copies opacity from the source to target',
'Gmagick::COMPOSITE_COPYRED' => 'Copies red from the source to target',
'Gmagick::COMPOSITE_COPYYELLOW' => 'Copies yellow from the source to target',
'Gmagick::COMPOSITE_DARKEN' => 'Darkens the target image',
'Gmagick::COMPOSITE_DEFAULT' => 'The default composite operator',
'Gmagick::COMPOSITE_DIFFERENCE' => 'Subtracts the darker of the two constituent colors from the lighter',
'Gmagick::COMPOSITE_DISPLACE' => 'Shifts target image pixels as defined by the source',
'Gmagick::COMPOSITE_DISSOLVE' => 'Dissolves the source in to the target',
'Gmagick::COMPOSITE_DST' => 'The target is left untouched',
'Gmagick::COMPOSITE_DSTATOP' => 'The part of the destination lying inside of the source is composited over the source and replaces the destination',
'Gmagick::COMPOSITE_DSTIN' => 'The parts inside the source replace the target',
'Gmagick::COMPOSITE_DSTOUT' => 'The parts outside the source replace the target',
'Gmagick::COMPOSITE_DSTOVER' => 'Target replaces the source',
'Gmagick::COMPOSITE_EXCLUSION' => 'Produces an effect similar to that of Gmagick::COMPOSITE_DIFFERENCE, but appears as lower contrast',
'Gmagick::COMPOSITE_HARDLIGHT' => 'Multiplies or screens the colors, dependent on the source color value',
'Gmagick::COMPOSITE_HUE' => 'Modifies the hue of the target as defined by source',
'Gmagick::COMPOSITE_IN' => 'Composites source into the target',
'Gmagick::COMPOSITE_LIGHTEN' => 'Lightens the target as defined by source',
'Gmagick::COMPOSITE_LUMINIZE' => 'Luminizes the target as defined by source',
'Gmagick::COMPOSITE_MINUS' => 'Subtracts the source from the target',
'Gmagick::COMPOSITE_MODULATE' => 'Modulates the target brightness, saturation and hue as defined by source',
'Gmagick::COMPOSITE_MULTIPLY' => 'Multiplies the target to the source',
'Gmagick::COMPOSITE_NO' => 'No composite operator defined',
'Gmagick::COMPOSITE_OUT' => 'Composites outer parts of the source on the target',
'Gmagick::COMPOSITE_OVER' => 'Composites source over the target',
'Gmagick::COMPOSITE_OVERLAY' => 'Overlays the source on the target',
'Gmagick::COMPOSITE_PLUS' => 'Adds the source to the target',
'Gmagick::COMPOSITE_REPLACE' => 'Replaces the target with the source',
'Gmagick::COMPOSITE_SATURATE' => 'Saturates the target as defined by the source',
'Gmagick::COMPOSITE_SCREEN' => 'The source and destination are complemented and then multiplied and then replace the destination',
'Gmagick::COMPOSITE_SOFTLIGHT' => 'Darkens or lightens the colors, dependent on the source',
'Gmagick::COMPOSITE_SRC' => 'The source is copied to the destination',
'Gmagick::COMPOSITE_SRCATOP' => 'The part of the source lying inside of the destination is composited onto the destination',
'Gmagick::COMPOSITE_SRCIN' => 'The part of the source lying inside of the destination replaces the destination',
'Gmagick::COMPOSITE_SRCOUT' => 'The part of the source lying outside of the destination replaces the destination',
'Gmagick::COMPOSITE_SRCOVER' => 'The source replaces the destination',
'Gmagick::COMPOSITE_SUBTRACT' => 'Subtract the colors in the source image from the destination image',
'Gmagick::COMPOSITE_THRESHOLD' => 'The source is composited on the target as defined by source threshold',
'Gmagick::COMPOSITE_UNDEFINED' => 'Undefined composite operator',
'Gmagick::COMPOSITE_XOR' => 'The part of the source that lies outside of the destination is combined with the part of the destination that lies outside of the source',
'GMP_VERSION' => 'The GMP library version',
'Grpc\CALL_ERROR' => 'something failed, we don\'t know what',
'Grpc\CALL_ERROR_ALREADY_ACCEPTED' => 'this method must be called before server_accept',
'Grpc\CALL_ERROR_ALREADY_FINISHED' => 'this call is already finished
(writes_done or write_status has already been called)',
'Grpc\CALL_ERROR_ALREADY_INVOKED' => 'this method must be called before invoke',
'Grpc\CALL_ERROR_BATCH_TOO_BIG' => 'this batch of operations leads to more operations than allowed',
'Grpc\CALL_ERROR_INVALID_FLAGS' => 'the flags value was illegal for this call',
'Grpc\CALL_ERROR_INVALID_MESSAGE' => 'invalid message was passed to this call',
'Grpc\CALL_ERROR_INVALID_METADATA' => 'invalid metadata was passed to this call',
'Grpc\CALL_ERROR_NOT_INVOKED' => 'this method must be called after invoke',
'Grpc\CALL_ERROR_NOT_ON_CLIENT' => 'this method is not available on the client',
'Grpc\CALL_ERROR_NOT_ON_SERVER' => 'this method is not available on the server',
'Grpc\CALL_ERROR_NOT_SERVER_COMPLETION_QUEUE' => 'completion queue for notification has not been registered with the
server',
'Grpc\CALL_ERROR_PAYLOAD_TYPE_MISMATCH' => 'payload type requested is not the type registered',
'Grpc\CALL_ERROR_TOO_MANY_OPERATIONS' => 'there is already an outstanding read/write operation on the call',
'Grpc\CALL_OK' => 'everything went ok',
'Grpc\CHANNEL_CONNECTING' => 'channel is connecting',
'Grpc\CHANNEL_IDLE' => 'channel is idle',
'Grpc\CHANNEL_READY' => 'channel is ready for work',
'Grpc\CHANNEL_SHUTDOWN' => 'channel has seen a failure that it cannot recover from',
'Grpc\CHANNEL_TRANSIENT_FAILURE' => 'channel has seen a failure but expects to recover',
'Grpc\OP_RECV_CLOSE_ON_SERVER' => 'Receive close on the server: one and only one must be made on the
server.
This op completes after the close has been received by the server.
This operation always succeeds, meaning ops paired with this operation
will also appear to succeed, even though they may not have.',
'Grpc\OP_RECV_INITIAL_METADATA' => 'Receive initial metadata: one and only one MUST be made on the client,
must not be made on the server.
This op completes after all initial metadata has been read from the
peer.',
'Grpc\OP_RECV_MESSAGE' => 'Receive a message: 0 or more of these operations can occur for each call.
This op completes after all bytes of the received message have been
read, or after a half-close has been received on this call.',
'Grpc\OP_RECV_STATUS_ON_CLIENT' => 'Receive status on the client: one and only one must be made on the client.
This operation always succeeds, meaning ops paired with this operation
will also appear to succeed, even though they may not have. In that case
the status will indicate some failure.
This op completes after all activity on the call has completed.',
'Grpc\OP_SEND_CLOSE_FROM_CLIENT' => 'Send a close from the client: one and only one instance MUST be sent from
the client, unless the call was cancelled - in which case this can be
skipped.
This op completes after all bytes for the call (including the close)
have passed outgoing flow control.',
'Grpc\OP_SEND_INITIAL_METADATA' => 'Send initial metadata: one and only one instance MUST be sent for each
call, unless the call was cancelled - in which case this can be skipped.
This op completes after all bytes of metadata have been accepted by
outgoing flow control.',
'Grpc\OP_SEND_MESSAGE' => 'Send a message: 0 or more of these operations can occur for each call.
This op completes after all bytes for the message have been accepted by
outgoing flow control.',
'Grpc\OP_SEND_STATUS_FROM_SERVER' => 'Send status from the server: one and only one instance MUST be sent from
the server unless the call was cancelled - in which case this can be
skipped.
This op completes after all bytes for the call (including the status)
have passed outgoing flow control.',
'Grpc\STATUS_ABORTED' => 'The operation was aborted, typically due to a concurrency issue
like sequencer check failures, transaction aborts, etc.

See litmus test above for deciding between FAILED_PRECONDITION,
ABORTED, and UNAVAILABLE.',
'Grpc\STATUS_CANCELLED' => 'The operation was cancelled (typically by the caller).',
'Grpc\STATUS_DATA_LOSS' => 'Unrecoverable data loss or corruption.',
'Grpc\STATUS_DEADLINE_EXCEEDED' => 'Deadline expired before operation could complete.  For operations
that change the state of the system, this error may be returned
even if the operation has completed successfully.  For example, a
successful response from a server could have been delayed long
enough for the deadline to expire.',
'Grpc\STATUS_FAILED_PRECONDITION' => 'Operation was rejected because the system is not in a state
required for the operation\'s execution.  For example, directory
to be deleted may be non-empty, an rmdir operation is applied to
a non-directory, etc.

A litmus test that may help a service implementor in deciding
between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
 (a) Use UNAVAILABLE if the client can retry just the failing call.
 (b) Use ABORTED if the client should retry at a higher-level
     (e.g., restarting a read-modify-write sequence).
 (c) Use FAILED_PRECONDITION if the client should not retry until
     the system state has been explicitly fixed.  E.g., if an "rmdir"
     fails because the directory is non-empty, FAILED_PRECONDITION
     should be returned since the client should not retry unless
     they have first fixed up the directory by deleting files from it.
 (d) Use FAILED_PRECONDITION if the client performs conditional
     REST Get/Update/Delete on a resource and the resource on the
     server does not match the condition. E.g., conflicting
     read-modify-write on the same resource.',
'Grpc\STATUS_INTERNAL' => 'Internal errors.  Means some invariants expected by underlying
 system has been broken.  If you see one of these errors,
 something is very broken.',
'Grpc\STATUS_INVALID_ARGUMENT' => 'Client specified an invalid argument.  Note that this differs
from FAILED_PRECONDITION.  INVALID_ARGUMENT indicates arguments
that are problematic regardless of the state of the system
(e.g., a malformed file name).',
'Grpc\STATUS_NOT_FOUND' => 'Some requested entity (e.g., file or directory) was not found.',
'Grpc\STATUS_OK' => 'Not an error; returned on success',
'Grpc\STATUS_OUT_OF_RANGE' => 'Operation was attempted past the valid range.  E.g., seeking or
reading past end of file.

Unlike INVALID_ARGUMENT, this error indicates a problem that may
be fixed if the system state changes. For example, a 32-bit file
system will generate INVALID_ARGUMENT if asked to read at an
offset that is not in the range [0,2^32-1], but it will generate
OUT_OF_RANGE if asked to read from an offset past the current
file size.

There is a fair bit of overlap between FAILED_PRECONDITION and
OUT_OF_RANGE.  We recommend using OUT_OF_RANGE (the more specific
error) when it applies so that callers who are iterating through
a space can easily look for an OUT_OF_RANGE error to detect when
they are done.',
'Grpc\STATUS_PERMISSION_DENIED' => 'The caller does not have permission to execute the specified
operation.  PERMISSION_DENIED must not be used for rejections
caused by exhausting some resource (use RESOURCE_EXHAUSTED
instead for those errors).  PERMISSION_DENIED must not be
used if the caller can not be identified (use UNAUTHENTICATED
instead for those errors).',
'Grpc\STATUS_RESOURCE_EXHAUSTED' => 'Some resource has been exhausted, perhaps a per-user quota, or
perhaps the entire file system is out of space.',
'Grpc\STATUS_UNAUTHENTICATED' => 'The request does not have valid authentication credentials for the
operation.',
'Grpc\STATUS_UNAVAILABLE' => 'The service is currently unavailable.  This is a most likely a
transient condition and may be corrected by retrying with
a backoff.

See litmus test above for deciding between FAILED_PRECONDITION,
ABORTED, and UNAVAILABLE.',
'Grpc\STATUS_UNIMPLEMENTED' => 'Operation is not implemented or not supported/enabled in this service.',
'Grpc\STATUS_UNKNOWN' => 'Unknown error.  An example of where this error may be returned is
if a Status value received from another address space belongs to
an error-space that is not known in this address space.  Also
errors raised by APIs that do not return enough error information
may be converted to this error.',
'Grpc\WRITE_BUFFER_HINT' => 'Hint that the write may be buffered and need not go out on the wire
immediately. GRPC is free to buffer the message until the next non-buffered
write, or until writes_done, but it need not buffer completely or at all.',
'Grpc\WRITE_NO_COMPRESS' => 'Force compression to be disabled for a particular write
(start_write/add_metadata). Illegal on invoke/accept.',
'GSLC_SSL_NO_AUTH' => 'SSL Authentication Mode - No authentication required. (Only for Oracle LDAP)',
'GSLC_SSL_ONEWAY_AUTH' => 'SSL Authentication Mode - Only server authentication required. (Only for Oracle LDAP)',
'GSLC_SSL_TWOWAY_AUTH' => 'SSL Authentication Mode - Both server and client authentication required. (Only for Oracle LDAP)',
'HASH_HMAC' => 'Optional flag for `hash_init`. Indicates that the HMAC digest-keying algorithm should be applied to the current hashing context.',
'http\Client::DEBUG_BODY' => 'Debug callback\'s $data contains a body part.',
'http\Client::DEBUG_HEADER' => 'Debug callback\'s $data contains headers.',
'http\Client::DEBUG_IN' => 'Debug callback\'s $data contains data received.',
'http\Client::DEBUG_INFO' => 'Debug callback\'s $data contains human readable text.',
'http\Client::DEBUG_OUT' => 'Debug callback\'s $data contains data sent.',
'http\Client::DEBUG_SSL' => 'Debug callback\'s $data contains SSL data.',
'http\Client\Curl\AUTH_ANY' => 'Use any authentication.',
'http\Client\Curl\AUTH_BASIC' => 'Use Basic authentication.',
'http\Client\Curl\AUTH_DIGEST' => 'Use Digest authentication.',
'http\Client\Curl\AUTH_DIGEST_IE' => 'Use IE (lower v7) quirks with Digest authentication. Available if libcurl is v7.19.3 or more recent.',
'http\Client\Curl\AUTH_GSSNEG' => 'Use GSS-Negotiate authentication.',
'http\Client\Curl\AUTH_NTLM' => 'Use NTLM authentication.',
'http\Client\Curl\AUTH_SPNEGO' => 'Use HTTP Netgotiate authentication (SPNEGO, RFC4559). Available if libcurl is v7.38.0 or more recent.',
'http\Client\Curl\FEATURES' => 'Bitmask of available libcurl features.
  See http\Client\Curl\Features namespace.',
'http\Client\Curl\Features\ASYNCHDNS' => 'Whether libcurl supports asynchronous domain name resolution.',
'http\Client\Curl\Features\GSSAPI' => 'Whether libcurl supports the Generic Security Services Application Program Interface. Available if libcurl is v7.38.0 or more recent.',
'http\Client\Curl\Features\GSSNEGOTIATE' => 'Whether libcurl supports HTTP Generic Security Services negotiation.',
'http\Client\Curl\Features\HTTP2' => 'Whether libcurl supports the HTTP/2 protocol. Available if libcurl is v7.33.0 or more recent.',
'http\Client\Curl\Features\IDN' => 'Whether libcurl supports international domain names.',
'http\Client\Curl\Features\IPV6' => 'Whether libcurl supports IPv6.',
'http\Client\Curl\Features\KERBEROS4' => 'Whether libcurl supports the old Kerberos protocol.',
'http\Client\Curl\Features\KERBEROS5' => 'Whether libcurl supports the more recent Kerberos v5 protocol. Available if libcurl is v7.40.0 or more recent.',
'http\Client\Curl\Features\LARGEFILE' => 'Whether libcurl supports large files.',
'http\Client\Curl\Features\LIBZ' => 'Whether libcurl supports gzip/deflate compression.',
'http\Client\Curl\Features\NTLM' => 'Whether libcurl supports the NT Lan Manager authentication.',
'http\Client\Curl\Features\NTLM_WB' => 'Whether libcurl supports NTLM delegation to a winbind helper. Available if libcurl is v7.22.0 or more recent.',
'http\Client\Curl\Features\PSL' => 'Whether libcurl supports the Public Suffix List for cookie host handling. Available if libcurl is v7.47.0 or more recent.',
'http\Client\Curl\Features\SPNEGO' => 'Whether libcurl supports the Simple and Protected GSSAPI Negotiation Mechanism.',
'http\Client\Curl\Features\SSL' => 'Whether libcurl supports SSL/TLS protocols.',
'http\Client\Curl\Features\SSPI' => 'Whether libcurl supports the Security Support Provider Interface.',
'http\Client\Curl\Features\TLSAUTH_SRP' => 'Whether libcurl supports TLS Secure Remote Password authentication. Available if libcurl is v7.21.4 or more recent.',
'http\Client\Curl\Features\UNIX_SOCKETS' => 'Whether libcurl supports connections to unix sockets. Available if libcurl is v7.40.0 or more recent.',
'http\Client\Curl\HTTP_VERSION_1_0' => 'Use HTTP/1.0 protocol version.',
'http\Client\Curl\HTTP_VERSION_1_1' => 'Use HTTP/1.1 protocol version.',
'http\Client\Curl\HTTP_VERSION_2_0' => 'Attempt to use HTTP/2 protocol version. Available if libcurl is v7.33.0 or more recent and was built with nghttp2 support.',
'http\Client\Curl\HTTP_VERSION_2TLS' => 'Attempt to use version 2 for HTTPS, version 1.1 for HTTP. Available if libcurl is v7.47.0 or more recent and was built with nghttp2 support.',
'http\Client\Curl\HTTP_VERSION_ANY' => 'Use any HTTP protocol version.',
'http\Client\Curl\IPRESOLVE_ANY' => 'Use any resolver.',
'http\Client\Curl\IPRESOLVE_V4' => 'Use IPv4 resolver.',
'http\Client\Curl\IPRESOLVE_V6' => 'Use IPv6 resolver.',
'http\Client\Curl\POSTREDIR_301' => 'Keep POSTing on 301 redirects. Available if libcurl is v7.19.1 or more recent.',
'http\Client\Curl\POSTREDIR_302' => 'Keep POSTing on 302 redirects. Available if libcurl is v7.19.1 or more recent.',
'http\Client\Curl\POSTREDIR_303' => 'Keep POSTing on 303 redirects. Available if libcurl is v7.19.1 or more recent.',
'http\Client\Curl\POSTREDIR_ALL' => 'Keep POSTing on any redirect. Available if libcurl is v7.19.1 or more recent.',
'http\Client\Curl\PROXY_HTTP' => 'Use HTTP/1.1 proxy protocol.',
'http\Client\Curl\PROXY_HTTP_1_0' => 'Use HTTP/1.0 proxy protocol. Available if libcurl is v7.19.4 or more recent.',
'http\Client\Curl\PROXY_SOCKS4' => 'Use SOCKSv4 proxy protocol.',
'http\Client\Curl\PROXY_SOCKS4A' => 'Use SOCKSv4a proxy protocol.',
'http\Client\Curl\PROXY_SOCKS5' => 'Use SOCKS5 proxy protoccol.',
'http\Client\Curl\PROXY_SOCKS5_HOSTNAME' => 'Use SOCKS5h proxy protocol.',
'http\Client\Curl\SSL_VERSION_ANY' => 'Use any encryption.',
'http\Client\Curl\SSL_VERSION_SSLv2' => 'Use SSL v2 encryption.',
'http\Client\Curl\SSL_VERSION_SSLv3' => 'Use SSL v3 encryption.',
'http\Client\Curl\SSL_VERSION_TLSv1' => 'Use any TLS v1 encryption.',
'http\Client\Curl\SSL_VERSION_TLSv1_0' => 'Use TLS v1.0 encryption.',
'http\Client\Curl\SSL_VERSION_TLSv1_1' => 'Use TLS v1.1 encryption.',
'http\Client\Curl\SSL_VERSION_TLSv1_2' => 'Use TLS v1.2 encryption.',
'http\Client\Curl\TLSAUTH_SRP' => 'Use TLS SRP authentication. Available if libcurl is v7.21.4 or more recent and was built with gnutls or openssl with TLS-SRP support.',
'http\Client\Curl\User::POLL_IN' => 'Poll for read readiness.',
'http\Client\Curl\User::POLL_INOUT' => 'Poll for read/write readiness.',
'http\Client\Curl\User::POLL_NONE' => 'No action.',
'http\Client\Curl\User::POLL_OUT' => 'Poll for write readiness.',
'http\Client\Curl\User::POLL_REMOVE' => 'Stop polling for activity on this descriptor.',
'http\Client\Curl\VERSIONS' => 'List of library versions of or linked into libcurl,
  e.g. "libcurl/7.50.0 OpenSSL/1.0.2h zlib/1.2.8 libidn/1.32 nghttp2/1.12.0".
  See http\Client\Curl\Versions namespace.',
'http\Client\Curl\Versions\ARES' => 'Version string of the c-ares library, e.g. "1.11.0".',
'http\Client\Curl\Versions\CURL' => 'Version string of libcurl, e.g. "7.50.0".',
'http\Client\Curl\Versions\IDN' => 'Version string of the IDN library, e.g. "1.32".',
'http\Client\Curl\Versions\LIBZ' => 'Version string of the zlib compression library, e.g. "1.2.8".',
'http\Client\Curl\Versions\SSL' => 'Version string of the SSL/TLS library, e.g. "OpenSSL/1.0.2h".',
'http\Client\Request::TYPE_NONE' => 'No specific type of message.',
'http\Client\Request::TYPE_REQUEST' => 'A request message.',
'http\Client\Request::TYPE_RESPONSE' => 'A response message.',
'http\Client\Response::TYPE_NONE' => 'No specific type of message.',
'http\Client\Response::TYPE_REQUEST' => 'A request message.',
'http\Client\Response::TYPE_RESPONSE' => 'A response message.',
'http\Cookie::HTTPONLY' => 'The cookies\' flags have the httpOnly attribute set.',
'http\Cookie::PARSE_RAW' => 'Do not decode cookie contents.',
'http\Cookie::SECURE' => 'The cookies\' flags have the secure attribute set.',
'http\Encoding\Stream::FLUSH_FULL' => 'Flush at each IO operation.',
'http\Encoding\Stream::FLUSH_NONE' => 'Do no intermittent flushes.',
'http\Encoding\Stream::FLUSH_SYNC' => 'Flush at appropriate transfer points.',
'http\Encoding\Stream\Debrotli::FLUSH_FULL' => 'Flush at each IO operation.',
'http\Encoding\Stream\Debrotli::FLUSH_NONE' => 'Do no intermittent flushes.',
'http\Encoding\Stream\Debrotli::FLUSH_SYNC' => 'Flush at appropriate transfer points.',
'http\Encoding\Stream\Dechunk::FLUSH_FULL' => 'Flush at each IO operation.',
'http\Encoding\Stream\Dechunk::FLUSH_NONE' => 'Do no intermittent flushes.',
'http\Encoding\Stream\Dechunk::FLUSH_SYNC' => 'Flush at appropriate transfer points.',
'http\Encoding\Stream\Deflate::FLUSH_FULL' => 'Flush at each IO operation.',
'http\Encoding\Stream\Deflate::FLUSH_NONE' => 'Do no intermittent flushes.',
'http\Encoding\Stream\Deflate::FLUSH_SYNC' => 'Flush at appropriate transfer points.',
'http\Encoding\Stream\Deflate::LEVEL_DEF' => 'Default compression level.',
'http\Encoding\Stream\Deflate::LEVEL_MAX' => 'Greatest compression level.',
'http\Encoding\Stream\Deflate::LEVEL_MIN' => 'Least compression level.',
'http\Encoding\Stream\Deflate::STRATEGY_DEF' => 'Default compression strategy.',
'http\Encoding\Stream\Deflate::STRATEGY_FILT' => 'Filtered compression strategy.',
'http\Encoding\Stream\Deflate::STRATEGY_FIXED' => 'Encoding with fixed Huffman codes only.

> **A note on the compression strategy:**
>
> The strategy parameter is used to tune the compression algorithm.
>
> Use the value DEFAULT_STRATEGY for normal data, FILTERED for data produced by a filter (or predictor), HUFFMAN_ONLY to force Huffman encoding only (no string match), or RLE to limit match distances to one (run-length encoding).
>
> Filtered data consists mostly of small values with a somewhat random distribution. In this case, the compression algorithm is tuned to compress them better. The effect of FILTERED is to force more Huffman coding and less string matching; it is somewhat intermediate between DEFAULT_STRATEGY and HUFFMAN_ONLY.
>
> RLE is designed to be almost as fast as HUFFMAN_ONLY, but give better compression for PNG image data.
>
> FIXED prevents the use of dynamic Huffman codes, allowing for a simpler decoder for special applications.
>
> The strategy parameter only affects the compression ratio but not the correctness of the compressed output even if it is not set appropriately.
>
>_Source: [zlib Manual](http://www.zlib.net/manual.html)_',
'http\Encoding\Stream\Deflate::STRATEGY_HUFF' => 'Huffman strategy only.',
'http\Encoding\Stream\Deflate::STRATEGY_RLE' => 'Run-length encoding strategy.',
'http\Encoding\Stream\Deflate::TYPE_GZIP' => 'Gzip encoding. RFC1952',
'http\Encoding\Stream\Deflate::TYPE_RAW' => 'Deflate encoding. RFC1951',
'http\Encoding\Stream\Deflate::TYPE_ZLIB' => 'Zlib encoding. RFC1950',
'http\Encoding\Stream\Enbrotli::FLUSH_FULL' => 'Flush at each IO operation.',
'http\Encoding\Stream\Enbrotli::FLUSH_NONE' => 'Do no intermittent flushes.',
'http\Encoding\Stream\Enbrotli::FLUSH_SYNC' => 'Flush at appropriate transfer points.',
'http\Encoding\Stream\Enbrotli::LEVEL_DEF' => 'Default compression level.',
'http\Encoding\Stream\Enbrotli::LEVEL_MAX' => 'Greatest compression level.',
'http\Encoding\Stream\Enbrotli::LEVEL_MIN' => 'Least compression level.',
'http\Encoding\Stream\Enbrotli::MODE_FONT' => 'Compression mode used in WOFF 2.0.',
'http\Encoding\Stream\Enbrotli::MODE_GENERIC' => 'Default compression mode.',
'http\Encoding\Stream\Enbrotli::MODE_TEXT' => 'Compression mode for UTF-8 formatted text.',
'http\Encoding\Stream\Enbrotli::WBITS_DEF' => 'Default window bits.',
'http\Encoding\Stream\Enbrotli::WBITS_MAX' => 'Maximum window bits.',
'http\Encoding\Stream\Enbrotli::WBITS_MIN' => 'Minimum window bits.',
'http\Encoding\Stream\Inflate::FLUSH_FULL' => 'Flush at each IO operation.',
'http\Encoding\Stream\Inflate::FLUSH_NONE' => 'Do no intermittent flushes.',
'http\Encoding\Stream\Inflate::FLUSH_SYNC' => 'Flush at appropriate transfer points.',
'http\Env\Request::TYPE_NONE' => 'No specific type of message.',
'http\Env\Request::TYPE_REQUEST' => 'A request message.',
'http\Env\Request::TYPE_RESPONSE' => 'A response message.',
'http\Env\Response::CACHE_HIT' => 'The cache was hit.',
'http\Env\Response::CACHE_MISS' => 'The cache was missed.',
'http\Env\Response::CACHE_NO' => 'No caching info available.',
'http\Env\Response::CONTENT_ENCODING_GZIP' => 'Support "Accept-Encoding" requests with gzip and deflate encoding.',
'http\Env\Response::CONTENT_ENCODING_NONE' => 'Do not use content encoding.',
'http\Env\Response::TYPE_NONE' => 'No specific type of message.',
'http\Env\Response::TYPE_REQUEST' => 'A request message.',
'http\Env\Response::TYPE_RESPONSE' => 'A response message.',
'http\Header::MATCH_CASE' => 'Perform case sensitive matching.',
'http\Header::MATCH_FULL' => 'Match the complete string.',
'http\Header::MATCH_LOOSE' => 'None of the following match constraints applies.',
'http\Header::MATCH_STRICT' => 'Case sensitively match the full string (same as MATCH_CASE|MATCH_FULL).',
'http\Header::MATCH_WORD' => 'Match only on word boundaries (according by CType alpha-numeric).',
'http\Header\Parser::CLEANUP' => 'Finish up parser at end of (incomplete) input.',
'http\Header\Parser::STATE_DONE' => 'Finished parsing the headers.

> ***NOTE:***
> Most of this states won\'t be returned to the user, because the parser immediately jumps to the next expected state.',
'http\Header\Parser::STATE_FAILURE' => 'Parse failure.',
'http\Header\Parser::STATE_HEADER_DONE' => 'A header was completed.',
'http\Header\Parser::STATE_KEY' => 'Expecting a key or already parsing a key.',
'http\Header\Parser::STATE_START' => 'Expecting HTTP info (request/response line) or headers.',
'http\Header\Parser::STATE_VALUE' => 'Expecting a value or already parsing the value.',
'http\Header\Parser::STATE_VALUE_EX' => 'At EOL of an header, checking whether a folded header line follows.',
'http\Message::TYPE_NONE' => 'No specific type of message.',
'http\Message::TYPE_REQUEST' => 'A request message.',
'http\Message::TYPE_RESPONSE' => 'A response message.',
'http\Message\Parser::CLEANUP' => 'Finish up parser at end of (incomplete) input.',
'http\Message\Parser::DUMB_BODIES' => 'Soak up the rest of input if no entity length is deducible.',
'http\Message\Parser::EMPTY_REDIRECTS' => 'Redirect messages do not contain any body despite of indication of such.',
'http\Message\Parser::GREEDY' => 'Continue parsing while input is available.',
'http\Message\Parser::STATE_BODY' => 'Parsing the body.',
'http\Message\Parser::STATE_BODY_CHUNKED' => 'Parsing `chunked` encoded body.',
'http\Message\Parser::STATE_BODY_DONE' => 'Finished parsing the body.',
'http\Message\Parser::STATE_BODY_DUMB' => 'Soaking up all input as body.',
'http\Message\Parser::STATE_BODY_LENGTH' => 'Reading body as indicated by `Content-Length` or `Content-Range`.',
'http\Message\Parser::STATE_DONE' => 'Finished parsing the message.

> ***NOTE:***
> Most of this states won\'t be returned to the user, because the parser immediately jumps to the next expected state.',
'http\Message\Parser::STATE_FAILURE' => 'Parse failure.',
'http\Message\Parser::STATE_HEADER' => 'Parsing headers.',
'http\Message\Parser::STATE_HEADER_DONE' => 'Completed parsing headers.',
'http\Message\Parser::STATE_START' => 'Expecting HTTP info (request/response line) or headers.',
'http\Message\Parser::STATE_UPDATE_CL' => 'Updating Content-Length based on body size.',
'http\Params::COOKIE_PARAM_SEP' => 'Empty param separator to parse cookies.',
'http\Params::DEF_ARG_SEP' => 'The default argument separator (";").',
'http\Params::DEF_PARAM_SEP' => 'The default parameter separator (",").',
'http\Params::DEF_VAL_SEP' => 'The default value separator ("=").',
'http\Params::PARSE_DEFAULT' => 'Interpret input as default formatted parameters.',
'http\Params::PARSE_DIMENSION' => 'Parse sub dimensions indicated by square brackets.',
'http\Params::PARSE_ESCAPED' => 'Parse backslash escaped (quoted) strings.',
'http\Params::PARSE_QUERY' => 'Parse URL querystring (same as http\Params::PARSE_URLENCODED|http\Params::PARSE_DIMENSION).',
'http\Params::PARSE_RAW' => 'Do not interpret the parsed parameters.',
'http\Params::PARSE_RFC5987' => 'Parse [RFC5987](http://tools.ietf.org/html/rfc5987) style encoded character set and language information embedded in HTTP header params.',
'http\Params::PARSE_RFC5988' => 'Parse [RFC5988](http://tools.ietf.org/html/rfc5988) (Web Linking) tags of Link headers.',
'http\Params::PARSE_URLENCODED' => 'Urldecode single units of parameters, arguments and values.',
'http\QueryString::TYPE_ARRAY' => 'Cast requested value to an array.',
'http\QueryString::TYPE_BOOL' => 'Cast requested value to bool.',
'http\QueryString::TYPE_FLOAT' => 'Cast requested value to float.',
'http\QueryString::TYPE_INT' => 'Cast requested value to int.',
'http\QueryString::TYPE_OBJECT' => 'Cast requested value to an object.',
'http\QueryString::TYPE_STRING' => 'Cast requested value to string.',
'http\Url::FROM_ENV' => 'Import initial URL parts from the SAPI environment.',
'http\Url::IGNORE_ERRORS' => 'Continue parsing when encountering errors.',
'http\Url::JOIN_PATH' => 'Whether a relative path should be joined into the old path.',
'http\Url::JOIN_QUERY' => 'Whether the querystrings should be joined.',
'http\Url::PARSE_MBLOC' => 'Parse locale encoded multibyte sequences (on systems with wide character support).',
'http\Url::PARSE_MBUTF8' => 'Parse UTF-8 encoded multibyte sequences.',
'http\Url::PARSE_TOIDN' => 'Parse and convert multibyte hostnames according to IDNA (with IDNA support).',
'http\Url::PARSE_TOIDN_2003' => 'Explicitly request IDNA2003 implementation if available (libidn, idnkit or ICU).',
'http\Url::PARSE_TOIDN_2008' => 'Explicitly request IDNA2008 implementation if available (libidn2, idnkit2 or ICU).',
'http\Url::PARSE_TOPCT' => 'Percent encode multibyte sequences in the userinfo, path, query and fragment parts of the URL.',
'http\Url::REPLACE' => 'Replace parts of the old URL with parts of the new.',
'http\Url::SANITIZE_PATH' => 'Whether to sanitize the URL path (consolidate double slashes, directory jumps etc.)',
'http\Url::SILENT_ERRORS' => 'Suppress errors/exceptions.',
'http\Url::STDFLAGS' => 'Standard flags used by default internally for e.g. http\Message::setRequestUrl().
  Enables joining path and query, sanitizing path, multibyte/unicode, international domain names and transient percent encoding.',
'http\Url::STRIP_ALL' => 'Strip everything except scheme and host information.',
'http\Url::STRIP_AUTH' => 'Strip user and password information from URL (same as STRIP_USER|STRIP_PASS).',
'http\Url::STRIP_FRAGMENT' => 'Strip the fragment (hash) from the URL.',
'http\Url::STRIP_PASS' => 'Strip the password from the URL.',
'http\Url::STRIP_PATH' => 'Do not include the URL path.',
'http\Url::STRIP_PORT' => 'Do not include the port.',
'http\Url::STRIP_QUERY' => 'Do not include the URL querystring.',
'http\Url::STRIP_USER' => 'Strip the user information from the URL.',
'IBASE_BKP_CONVERT' => 'Options to `ibase_backup`',
'IBASE_BKP_IGNORE_CHECKSUMS' => 'Options to `ibase_backup`',
'IBASE_BKP_IGNORE_LIMBO' => 'Options to `ibase_backup`',
'IBASE_BKP_METADATA_ONLY' => 'Options to `ibase_backup`',
'IBASE_BKP_NO_GARBAGE_COLLECT' => 'Options to `ibase_backup`',
'IBASE_BKP_NON_TRANSPORTABLE' => 'Options to `ibase_backup`',
'IBASE_BKP_OLD_DESCRIPTIONS' => 'Options to `ibase_backup`',
'IBASE_RES_CREATE' => 'Options to `ibase_restore`',
'IBASE_RES_DEACTIVATE_IDX' => 'Options to `ibase_restore`',
'IBASE_RES_NO_SHADOW' => 'Options to `ibase_restore`',
'IBASE_RES_NO_VALIDITY' => 'Options to `ibase_restore`',
'IBASE_RES_ONE_AT_A_TIME' => 'Options to `ibase_restore`',
'IBASE_RES_USE_ALL_SPACE' => 'Options to `ibase_restore`',
'IBASE_RPR_SWEEP_DB' => 'Options to `ibase_maintain_db`',
'IBASE_STS_SYS_RELATIONS' => 'Options to `ibase_db_info`',
'IBASE_SVC_GET_ENV' => 'Options to `ibase_server_info`',
'IBASE_SVC_GET_USERS' => 'Options to `ibase_server_info`',
'IBASE_SVC_IMPLEMENTATION' => 'Options to `ibase_server_info`',
'IBASE_SVC_SERVER_VERSION' => 'Options to `ibase_server_info`',
'ID3_BEST' => '`ID3_BEST` is used if would like to let the id3 functions determine which tag version should be used.',
'ID3_V1_0' => '`ID3_V1_0` is used if you are working with ID3 V1.0 tags. These tags may contain the fields title, artist, album, genre, year and comment.',
'ID3_V1_1' => '`ID3_V1_1` is used if you are working with ID3 V1.1 tags. These tags may all information contained in v1.0 tags plus the track number.',
'ID3_V2_1' => '`ID3_V2_1` is used if you are working with ID3 V2.1 tags.',
'ID3_V2_2' => '`ID3_V2_2` is used if you are working with ID3 V2.2 tags.',
'ID3_V2_3' => '`ID3_V2_3` is used if you are working with ID3 V2.3 tags.',
'ID3_V2_4' => '`ID3_V2_4` is used if you are working with ID3 V2.4 tags.',
'IDNA_ALLOW_UNASSIGNED' => 'Allow processing of unassigned codepoints in the input for IDN functions.',
'IDNA_CHECK_BIDI' => 'Check whether the input conforms to the BiDi rules. Ignored by the IDNA2003 implementation, which always performs this check.',
'IDNA_CHECK_CONTEXTJ' => 'Check whether the input conforms to the CONTEXTJ rules. Ignored by the IDNA2003 implementation, as this check is new in IDNA2008.',
'IDNA_DEFAULT' => 'Prohibit processing of unassigned codepoints in the input for IDN functions and do not check if the input conforms to domain name ASCII rules.',
'IDNA_ERROR_EMPTY_LABEL' => 'Errors reported in a bitset returned by the UTS #46 algorithm in `idn_to_utf8` and `idn_to_ascii`.',
'IDNA_NONTRANSITIONAL_TO_ASCII' => 'Option for nontransitional processing in `idn_to_ascii`. Transitional processing is activated by default. This option is ignored by the IDNA2003 implementation.',
'IDNA_NONTRANSITIONAL_TO_UNICODE' => 'Option for nontransitional processing in `idn_to_utf8`. Transitional processing is activated by default. This option is ignored by the IDNA2003 implementation.',
'IDNA_USE_STD3_RULES' => 'Check if the input for IDN functions conforms to domain name ASCII rules.',
'ILL_BADSTK' => 'Available since PHP 5.3.0.',
'ILL_COPROC' => 'Available since PHP 5.3.0.',
'ILL_ILLADR' => 'Available since PHP 5.3.0.',
'ILL_ILLOPC' => 'Available since PHP 5.3.0.',
'ILL_ILLOPN' => 'Available since PHP 5.3.0.',
'ILL_ILLTRP' => 'Available since PHP 5.3.0.',
'ILL_PRVOPC' => 'Available since PHP 5.3.0.',
'ILL_PRVREG' => 'Available since PHP 5.3.0.',
'IMAGETYPE_ICO' => '(Available as of PHP 5.3.0)',
'IMAGETYPE_WEBP' => '(Available as of PHP 7.1.0)',
'imagick::ALPHACHANNEL_ACTIVATE' => '`imagick.constant.available` 6.3.8 or higher.',
'imagick::ALPHACHANNEL_COPY' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::ALPHACHANNEL_DEACTIVATE' => '`imagick.constant.available` 6.3.8 or higher.',
'imagick::ALPHACHANNEL_EXTRACT' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::ALPHACHANNEL_OPAQUE' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::ALPHACHANNEL_RESET' => '`imagick.constant.available` 6.3.8 or higher.',
'imagick::ALPHACHANNEL_SET' => '`imagick.constant.available` 6.3.8 or higher.',
'imagick::ALPHACHANNEL_SHAPE' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::ALPHACHANNEL_TRANSPARENT' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::ALPHACHANNEL_UNDEFINED' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::COLOR_ALPHA' => 'Color\'s alpha',
'imagick::COLOR_BLACK' => 'Black color',
'imagick::COLOR_BLUE' => 'Blue color',
'imagick::COLOR_CYAN' => 'Cyan color',
'imagick::COLOR_FUZZ' => 'Color\'s fuzz',
'imagick::COLOR_GREEN' => 'Green color',
'imagick::COLOR_MAGENTA' => 'Magenta color',
'imagick::COLOR_OPACITY' => 'Color\'s opacity',
'imagick::COLOR_RED' => 'Red color',
'imagick::COLOR_YELLOW' => 'Yellow color',
'imagick::COLORSPACE_CMY' => '`imagick.constant.available` 6.4.2 or higher.',
'imagick::COMPOSITE_ADD' => 'The result of image + image',
'imagick::COMPOSITE_ATOP' => 'The result is the same shape as image, with composite image obscuring image where the image shapes overlap',
'imagick::COMPOSITE_BLEND' => 'Blends the image',
'imagick::COMPOSITE_BUMPMAP' => 'The same as COMPOSITE_MULTIPLY, except the source is converted to grayscale first.',
'imagick::COMPOSITE_CLEAR' => 'Makes the target image transparent',
'imagick::COMPOSITE_COLORBURN' => 'Darkens the destination image to reflect the source image',
'imagick::COMPOSITE_COLORDODGE' => 'Brightens the destination image to reflect the source image',
'imagick::COMPOSITE_COLORIZE' => 'Colorizes the target image using the composite image',
'imagick::COMPOSITE_COPY' => 'Copies the source image on the target image',
'imagick::COMPOSITE_COPYBLACK' => 'Copies black from the source to target',
'imagick::COMPOSITE_COPYBLUE' => 'Copies blue from the source to target',
'imagick::COMPOSITE_COPYCYAN' => 'Copies cyan from the source to target',
'imagick::COMPOSITE_COPYGREEN' => 'Copies green from the source to target',
'imagick::COMPOSITE_COPYMAGENTA' => 'Copies magenta from the source to target',
'imagick::COMPOSITE_COPYOPACITY' => 'Copies opacity from the source to target',
'imagick::COMPOSITE_COPYRED' => 'Copies red from the source to target',
'imagick::COMPOSITE_COPYYELLOW' => 'Copies yellow from the source to target',
'imagick::COMPOSITE_DARKEN' => 'Darkens the target image',
'imagick::COMPOSITE_DEFAULT' => 'The default composite operator',
'imagick::COMPOSITE_DIFFERENCE' => 'Subtracts the darker of the two constituent colors from the lighter',
'imagick::COMPOSITE_DISPLACE' => 'Shifts target image pixels as defined by the source',
'imagick::COMPOSITE_DISSOLVE' => 'Dissolves the source in to the target',
'imagick::COMPOSITE_DST' => 'The target is left untouched',
'imagick::COMPOSITE_DSTATOP' => 'The part of the destination lying inside of the source is composited over the source and replaces the destination',
'imagick::COMPOSITE_DSTIN' => 'The parts inside the source replace the target',
'imagick::COMPOSITE_DSTOUT' => 'The parts outside the source replace the target',
'imagick::COMPOSITE_DSTOVER' => 'Target replaces the source',
'imagick::COMPOSITE_EXCLUSION' => 'Produces an effect similar to that of imagick::COMPOSITE_DIFFERENCE, but appears as lower contrast',
'imagick::COMPOSITE_HARDLIGHT' => 'Multiplies or screens the colors, dependent on the source color value',
'imagick::COMPOSITE_HUE' => 'Modifies the hue of the target as defined by source',
'imagick::COMPOSITE_IN' => 'Composites source into the target',
'imagick::COMPOSITE_LIGHTEN' => 'Lightens the target as defined by source',
'imagick::COMPOSITE_LUMINIZE' => 'Luminizes the target as defined by source',
'imagick::COMPOSITE_MINUS' => 'Subtracts the source from the target',
'imagick::COMPOSITE_MODULATE' => 'Modulates the target brightness, saturation and hue as defined by source',
'imagick::COMPOSITE_MULTIPLY' => 'Multiplies the target to the source',
'imagick::COMPOSITE_NO' => 'No composite operator defined',
'imagick::COMPOSITE_OUT' => 'Composites outer parts of the source on the target',
'imagick::COMPOSITE_OVER' => 'Composites source over the target',
'imagick::COMPOSITE_OVERLAY' => 'Overlays the source on the target',
'imagick::COMPOSITE_PLUS' => 'Adds the source to the target',
'imagick::COMPOSITE_REPLACE' => 'Replaces the target with the source',
'imagick::COMPOSITE_SATURATE' => 'Saturates the target as defined by the source',
'imagick::COMPOSITE_SCREEN' => 'The source and destination are complemented and then multiplied and then replace the destination',
'imagick::COMPOSITE_SOFTLIGHT' => 'Darkens or lightens the colors, dependent on the source',
'imagick::COMPOSITE_SRC' => 'The source is copied to the destination',
'imagick::COMPOSITE_SRCATOP' => 'The part of the source lying inside of the destination is composited onto the destination',
'imagick::COMPOSITE_SRCIN' => 'The part of the source lying inside of the destination replaces the destination',
'imagick::COMPOSITE_SRCOUT' => 'The part of the source lying outside of the destination replaces the destination',
'imagick::COMPOSITE_SRCOVER' => 'The source replaces the destination',
'imagick::COMPOSITE_SUBTRACT' => 'Subtract the colors in the source image from the destination image',
'imagick::COMPOSITE_THRESHOLD' => 'The source is composited on the target as defined by source threshold',
'imagick::COMPOSITE_UNDEFINED' => 'Undefined composite operator',
'imagick::COMPOSITE_XOR' => 'The part of the source that lies outside of the destination is combined with the part of the destination that lies outside of the source',
'imagick::COMPRESSION_DXT1' => '`imagick.constant.available` 6.4.0 or higher.',
'imagick::COMPRESSION_DXT3' => '`imagick.constant.available` 6.4.0 or higher.',
'imagick::COMPRESSION_DXT5' => '`imagick.constant.available` 6.4.0 or higher.',
'imagick::DISPOSE_BACKGROUND' => 'Dispose background',
'imagick::DISPOSE_NONE' => 'No dispose type defined',
'imagick::DISPOSE_PREVIOUS' => 'Dispose previous',
'imagick::DISPOSE_UNDEFINED' => 'Undefined dispose type',
'imagick::DISPOSE_UNRECOGNIZED' => 'Unrecognized dispose type',
'imagick::DISTORTION_AFFINE' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_AFFINEPROJECTION' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_ARC' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_BARREL' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_BARRELINVERSE' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_BILINEAR' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_DEPOLAR' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_PERSPECTIVE' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_PERSPECTIVEPROJECTION' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_POLAR' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_POLYNOMIAL' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_SCALEROTATETRANSLATE' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DISTORTION_SENTINEL' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_SHEPARDS' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DISTORTION_UNDEFINED' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::DITHERMETHOD_FLOYDSTEINBERG' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DITHERMETHOD_NO' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DITHERMETHOD_RIEMERSMA' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::DITHERMETHOD_UNDEFINED' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::EVALUATE_ADDMODULUS' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_COSINE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_GAUSSIANNOISE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_IMPULSENOISE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_LAPLACIANNOISE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_LOG' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_MULTIPLICATIVENOISE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_POISSONNOISE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_POW' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_SINE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_THRESHOLD' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_THRESHOLDBLACK' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_THRESHOLDWHITE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::EVALUATE_UNIFORMNOISE' => '`imagick.constant.available` 6.4.4 or higher.',
'imagick::FUNCTION_POLYNOMIAL' => '`imagick.constant.available` 6.4.9 or higher.',
'imagick::FUNCTION_SINUSOID' => '`imagick.constant.available` 6.4.9 or higher.',
'imagick::FUNCTION_UNDEFINED' => '`imagick.constant.available` 6.4.9 or higher.',
'imagick::INTERLACE_GIF' => '`imagick.constant.available` 6.3.4 or higher.',
'imagick::INTERPOLATE_AVERAGE' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_BICUBIC' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_BILINEAR' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_FILTER' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_INTEGER' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_MESH' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_NEARESTNEIGHBOR' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::INTERPOLATE_SPLINE' => '`imagick.constant.available` 6.3.4 or higher.',
'imagick::INTERPOLATE_UNDEFINED' => '`imagick.constant.available` 6.3.2 or higher.',
'imagick::LAYERMETHOD_COALESCE' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_COMPAREANY' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_COMPARECLEAR' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_COMPAREOVERLAY' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_COMPOSITE' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::LAYERMETHOD_DISPOSE' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_FLATTEN' => '`imagick.constant.available` 6.3.7 or higher.',
'imagick::LAYERMETHOD_MERGE' => '`imagick.constant.available` 6.3.7 or higher.',
'imagick::LAYERMETHOD_MOSAIC' => '`imagick.constant.available` 6.3.7 or higher.',
'imagick::LAYERMETHOD_OPTIMIZE' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_OPTIMIZEIMAGE' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::LAYERMETHOD_OPTIMIZEPLUS' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::LAYERMETHOD_OPTIMIZETRANS' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::LAYERMETHOD_REMOVEDUPS' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::LAYERMETHOD_REMOVEZERO' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::LAYERMETHOD_UNDEFINED' => '`imagick.constant.available` 6.2.9 or higher.',
'imagick::NOISE_RANDOM' => '`imagick.constant.available` 6.3.6 or higher.',
'imagick::ORIENTATION_BOTTOMLEFT' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_BOTTOMRIGHT' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_LEFTBOTTOM' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_LEFTTOP' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_RIGHTBOTTOM' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_RIGHTTOP' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_TOPLEFT' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_TOPRIGHT' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::ORIENTATION_UNDEFINED' => '`imagick.constant.available` 6.3.0 or higher.',
'imagick::PIXEL_INTEGER' => 'Only available for ImageMagick &lt; 7.',
'imagick::RESOURCETYPE_AREA' => 'Set the maximum width * height of an image that can reside in the pixel cache memory.',
'imagick::RESOURCETYPE_DISK' => 'Set maximum amount of disk space in bytes permitted for use by the pixel cache.',
'imagick::RESOURCETYPE_FILE' => 'Set maximum number of open pixel cache files.',
'imagick::RESOURCETYPE_MAP' => 'Set maximum amount of memory map in bytes to allocate for the pixel cache.',
'imagick::RESOURCETYPE_MEMORY' => 'Set maximum amount of memory in bytes to allocate for the pixel cache from the heap.',
'imagick::RESOURCETYPE_THREAD' => 'Set maximum parallel threads. `imagick.constant.available` 6.7.8 or higher.',
'imagick::SPARSECOLORMETHOD_BARYCENTRIC' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::SPARSECOLORMETHOD_BILINEAR' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::SPARSECOLORMETHOD_POLYNOMIAL' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::SPARSECOLORMETHOD_SPEPARDS' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::SPARSECOLORMETHOD_UNDEFINED' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::SPARSECOLORMETHOD_VORONOI' => '`imagick.constant.available` 6.4.6 or higher.',
'imagick::VIRTUALPIXELMETHOD_BLACK' => '`imagick.constant.available` 6.4.2 or higher.',
'imagick::VIRTUALPIXELMETHOD_GRAY' => '`imagick.constant.available` 6.4.2 or higher.',
'imagick::VIRTUALPIXELMETHOD_HORIZONTALTILE' => '`imagick.constant.available` 6.4.3 or higher.',
'imagick::VIRTUALPIXELMETHOD_MASK' => '`imagick.constant.available` 6.4.2 or higher.',
'imagick::VIRTUALPIXELMETHOD_VERTICALTILE' => '`imagick.constant.available` 6.4.3 or higher.',
'imagick::VIRTUALPIXELMETHOD_WHITE' => '`imagick.constant.available` 6.4.2 or higher.',
'IMAP_GC_ELT' => 'Garbage collector, clear message cache elements.',
'IMAP_GC_ENV' => 'Garbage collector, clear envelopes and bodies.',
'IMAP_GC_TEXTS' => 'Garbage collector, clear texts.',
'IMG_ARC_ROUNDED' => 'This constant has the same value as `IMG_ARC_PIE`',
'IMG_FILTER_PIXELATE' => '(Available as of PHP 5.3.0)',
'IMG_FILTER_SCATTER' => '(Available as of PHP 7.4.0)',
'IMG_JPEG' => 'This constant has the same value as `IMG_JPG`',
'IMG_WEBP' => 'Available as of PHP 5.6.25 and PHP 7.0.10, respectively.',
'IN_ACCESS' => 'File was accessed (read) (*)',
'IN_ALL_EVENTS' => 'Bitmask of all the above constants',
'IN_ATTRIB' => 'Metadata changed (e.g. permissions, mtime, etc.) (*)',
'IN_CLOSE' => 'Equals to IN_CLOSE_WRITE | IN_CLOSE_NOWRITE',
'IN_CLOSE_NOWRITE' => 'File not opened for writing was closed (*)',
'IN_CLOSE_WRITE' => 'File opened for writing was closed (*)',
'IN_CREATE' => 'File or directory created in watched directory (*)',
'IN_DELETE' => 'File or directory deleted in watched directory (*)',
'IN_DELETE_SELF' => 'Watched file or directory was deleted',
'IN_DONT_FOLLOW' => 'Do not dereference pathname if it is a symlink (Since Linux 2.6.15)',
'IN_IGNORED' => 'Watch was removed (explicitly by `inotify_rm_watch` or because file was removed or filesystem unmounted',
'IN_ISDIR' => 'Subject of this event is a directory',
'IN_MASK_ADD' => 'Add events to watch mask for this pathname if it already exists (instead of replacing mask).',
'IN_MODIFY' => 'File was modified (*)',
'IN_MOVE' => 'Equals to IN_MOVED_FROM | IN_MOVED_TO',
'IN_MOVE_SELF' => 'Watch file or directory was moved',
'IN_MOVED_FROM' => 'File moved out of watched directory (*)',
'IN_MOVED_TO' => 'File moved into watched directory (*)',
'IN_ONESHOT' => 'Monitor pathname for one event, then remove from watch list.',
'IN_ONLYDIR' => 'Only watch pathname if it is a directory (Since Linux 2.6.15)',
'IN_OPEN' => 'File was opened (*)',
'IN_Q_OVERFLOW' => 'Event queue overflowed (wd is -1 for this event)',
'IN_UNMOUNT' => 'File system containing watched object was unmounted',
'INGRES_API_VERSION' => 'Specifies the version of Ingres OpenAPI that the extension was built against. Available since version 1.2.0 of the PECL extension.',
'INGRES_ASSOC' => 'Columns are returned into the array having the fieldname as the array index. Used with `ingres_fetch_array`.',
'INGRES_BOTH' => 'Columns are returned into the array having both a numerical index and the fieldname as the array index. Used with `ingres_fetch_array`.',
'INGRES_CURSOR_READONLY' => 'Specifies that Ingres cursors should be opened in "readonly" mode. Available since version 1.2.0 of the PECL extension. Used with ingres.cursor_mode.',
'INGRES_CURSOR_UPDATE' => 'Specifies that Ingres cursors should be opened "for update." Available since version 1.2.0 of the PECL extension. Used with ingres.cursor_mode.',
'INGRES_DATE_DMY' => 'Equivalent to the II_DATE_FORMAT setting of DMY. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_FINNISH' => 'Equivalent to the II_DATE_FORMAT setting of FINNISH. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_GERMAN' => 'Equivalent to the II_DATE_FORMAT setting of GERMAN. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_ISO' => 'Equivalent to the II_DATE_FORMAT setting of ISO. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_ISO4' => 'Equivalent to the II_DATE_FORMAT setting of ISO4. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_MDY' => 'Equivalent to the II_DATE_FORMAT setting of MDY. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_MULTINATIONAL' => 'Equivalent to the II_DATE_FORMAT setting of MULTINATIONAL. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_MULTINATIONAL4' => 'Equivalent to the II_DATE_FORMAT setting of MULTINATIONAL4. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_DATE_YMD' => 'Equivalent to the II_DATE_FORMAT setting of YMD. Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_EXT_VERSION' => 'Specifies the version of the Ingres Extension. Available since version 1.2.0 of the PECL extension.',
'INGRES_MONEY_LEADING' => 'Specifies the currency character that should be placed at the start of a money value. Equivalent to setting II_MONEY_FORMAT to "L:". Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_MONEY_TRAILING' => 'Specifies the currency character that should be placed at the end of a money value. Equivalent to setting II_MONEY_FORMAT to "T:". Available since version 1.2.0 of the PECL extension. Used with `ingres_connect`, `ingres_pconnect` and `ingres_set_environment`. See options in `ingres_set_environment`.',
'INGRES_NUM' => 'Columns are returned into the array having a numerical index to the fields. By default this index starts at 1, the first field in the result. To change this value, see ingres.array_index_start. Used with `ingres_fetch_array`.',
'INGRES_STRUCTURE_BTREE' => 'Specifies the default table or index structure to BTREE when used in combination with the options or index_structure option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_CBTREE' => 'Specifies the default table or index structure to COMPRESSED BTREE when used in combination with the options or index_structure option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_CHASH' => 'Specifies the default table or index structure to COMPRESSED HASH when used in combination with the options or index_structure option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_CHEAP' => 'Specifies the default table structure to COMPRESSED HEAP when used in combination with the options option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_CISAM' => 'Specifies the default table or index structure to COMPRESSED ISAM when used in combination with the options or index_structure option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_HASH' => 'Specifies the default table or index structure to HASH when used in combination with the options or index_structure option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_HEAP' => 'Specifies the default table structure to HEAP when used in combination with the options option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INGRES_STRUCTURE_ISAM' => 'Specifies the default table or index structure to ISAM when used in combination with the options or index_structure option when connecting. Available since version 1.4.0 of the PECL extension. Used with `ingres_connect` and `ingres_pconnect`. See options in `ingres_connect`.',
'INI_SCANNER_NORMAL' => 'Normal INI scanner mode (since PHP 5.3).',
'INI_SCANNER_RAW' => 'Raw INI scanner mode (since PHP 5.3).',
'INI_SCANNER_TYPED' => 'Typed INI scanner mode (since PHP 5.6.1).',
'INPUT_COOKIE' => 'COOKIE variables.',
'INPUT_ENV' => 'ENV variables.',
'INPUT_GET' => 'GET variables.',
'INPUT_POST' => 'POST variables.',
'INPUT_REQUEST' => 'REQUEST variables. (not implemented yet)',
'INPUT_SERVER' => 'SERVER variables.',
'INPUT_SESSION' => 'SESSION variables. (not implemented yet)',
'INTL_IDNA_VARIANT_2003' => 'Use IDNA 2003 algorithm in `idn_to_utf8` and `idn_to_ascii`. This is the default. This constant and using the default has been deprecated as of PHP 7.2.0.',
'INTL_IDNA_VARIANT_UTS46' => 'Use UTS #46 algorithm in `idn_to_utf8` and `idn_to_ascii`. Available as of ICU 4.6.',
'INTL_MAX_LOCALE_LEN' => 'Limit on locale length, set to 80 in PHP code. Locale names longer than this limit will not be accepted.',
'JSON_BIGINT_AS_STRING' => 'Decodes large integers as their original string value. Available since PHP 5.4.0.',
'JSON_ERROR_CTRL_CHAR' => 'Control character error, possibly incorrectly encoded.',
'JSON_ERROR_DEPTH' => 'The maximum stack depth has been exceeded.',
'JSON_ERROR_INF_OR_NAN' => 'The value passed to `json_encode` includes either `NAN` or `INF`. If the `JSON_PARTIAL_OUTPUT_ON_ERROR` option was given, `0` will be encoded in the place of these special numbers. Available since PHP 5.5.0.',
'JSON_ERROR_INVALID_PROPERTY_NAME' => 'A key starting with \u0000 character was in the string passed to `json_decode` when decoding a JSON object into a PHP object. Available since PHP 7.0.0.',
'JSON_ERROR_NONE' => 'No error has occurred.',
'JSON_ERROR_RECURSION' => 'The object or array passed to `json_encode` include recursive references and cannot be encoded. If the `JSON_PARTIAL_OUTPUT_ON_ERROR` option was given, `null` will be encoded in the place of the recursive reference. Available since PHP 5.5.0.',
'JSON_ERROR_STATE_MISMATCH' => 'Occurs with underflow or with the modes mismatch.',
'JSON_ERROR_SYNTAX' => 'Syntax error.',
'JSON_ERROR_UNSUPPORTED_TYPE' => 'A value of an unsupported type was given to `json_encode`, such as a `resource`. If the `JSON_PARTIAL_OUTPUT_ON_ERROR` option was given, `null` will be encoded in the place of the unsupported value. Available since PHP 5.5.0.',
'JSON_ERROR_UTF16' => 'Single unpaired UTF-16 surrogate in unicode escape contained in the JSON string passed to `json_encode`. Available since PHP 7.0.0.',
'JSON_ERROR_UTF8' => 'Malformed UTF-8 characters, possibly incorrectly encoded.',
'JSON_FORCE_OBJECT' => 'Outputs an object rather than an array when a non-associative array is used. Especially useful when the recipient of the output is expecting an object and the array is empty.',
'JSON_HEX_AMP' => 'All &amp;s are converted to \u0026.',
'JSON_HEX_APOS' => 'All \' are converted to \u0027.',
'JSON_HEX_QUOT' => 'All " are converted to \u0022.',
'JSON_HEX_TAG' => 'All &lt; and &gt; are converted to \u003C and \u003E.',
'JSON_INVALID_UTF8_IGNORE' => 'Ignore invalid UTF-8 characters. Available as of PHP 7.2.0.',
'JSON_INVALID_UTF8_SUBSTITUTE' => 'Convert invalid UTF-8 characters to \0xfffd (Unicode Character \'REPLACEMENT CHARACTER\') Available as of PHP 7.2.0.',
'JSON_NUMERIC_CHECK' => 'Encodes numeric strings as numbers.',
'JSON_OBJECT_AS_ARRAY' => 'Decodes JSON objects as PHP array. This option can be added automatically by calling `json_decode` with the second parameter equal to `true`. Available since PHP 5.4.0.',
'JSON_PARTIAL_OUTPUT_ON_ERROR' => 'Substitute some unencodable values instead of failing. Available since PHP 5.5.0.',
'JSON_PRESERVE_ZERO_FRACTION' => 'Ensures that `float` values are always encoded as a float value. Available since PHP 5.6.6.',
'JSON_PRETTY_PRINT' => 'Use whitespace in returned data to format it. Available since PHP 5.4.0.',
'JSON_THROW_ON_ERROR' => 'Throws `JsonException` if an error occurs instead of setting the global error state that is retrieved with `json_last_error`. `JSON_PARTIAL_OUTPUT_ON_ERROR` takes precedence over `JSON_THROW_ON_ERROR`. Available since PHP 7.3.0.',
'JSON_UNESCAPED_LINE_TERMINATORS' => 'The line terminators are kept unescaped when `JSON_UNESCAPED_UNICODE` is supplied. It uses the same behaviour as it was before PHP 7.1 without this constant. Available since PHP 7.1.0.',
'JSON_UNESCAPED_SLASHES' => 'Don\'t escape `/`. Available since PHP 5.4.0.',
'JSON_UNESCAPED_UNICODE' => 'Encode multibyte Unicode characters literally (default is to escape as \uXXXX). Available since PHP 5.4.0.',
'Judy::BITSET' => 'Define the Judy Array as a Bitset with keys as Integer and Values as a Boolean.',
'Judy::INT_TO_INT' => 'Define the Judy Array with key/values as Integer, and Integer only.',
'Judy::INT_TO_MIXED' => 'Define the Judy Array with keys as Integer and Values of any type.',
'Judy::STRING_TO_INT' => 'Define the Judy Array with keys as a String and Values as Integer, and Integer only.',
'Judy::STRING_TO_MIXED' => 'Define the Judy Array with keys as a String and Values of any type.',
'KTaglib_ID3v2_AttachedPictureFrame::Artist' => 'Picture type Artist',
'KTaglib_ID3v2_AttachedPictureFrame::BackCover' => 'Picture type BackCover',
'KTaglib_ID3v2_AttachedPictureFrame::Band' => 'Picture type Band',
'KTaglib_ID3v2_AttachedPictureFrame::BandLogo' => 'Picture type BandLogo',
'KTaglib_ID3v2_AttachedPictureFrame::ColouredFish' => 'Picture type ColouredFish',
'KTaglib_ID3v2_AttachedPictureFrame::Composer' => 'Picture type Composer',
'KTaglib_ID3v2_AttachedPictureFrame::Conductor' => 'Picture type Conductor',
'KTaglib_ID3v2_AttachedPictureFrame::DuringPerformance' => 'Picture type DuringPerformance',
'KTaglib_ID3v2_AttachedPictureFrame::DuringRecording' => 'Picture type DuringRecording',
'KTaglib_ID3v2_AttachedPictureFrame::FileIcon' => 'Picture type FileIcon',
'KTaglib_ID3v2_AttachedPictureFrame::FrontCover' => 'Picture type FrontCover',
'KTaglib_ID3v2_AttachedPictureFrame::Illustration' => 'Picture type Illustration',
'KTaglib_ID3v2_AttachedPictureFrame::LeadArtist' => 'Picture type LeadArtist',
'KTaglib_ID3v2_AttachedPictureFrame::LeafletPage' => 'Picture type LeafletPage',
'KTaglib_ID3v2_AttachedPictureFrame::Lyricist' => 'Picture type Lyricist',
'KTaglib_ID3v2_AttachedPictureFrame::Media' => 'Picture type Media',
'KTaglib_ID3v2_AttachedPictureFrame::MovieScreenCapture' => 'Picture type MovieScreenCapture',
'KTaglib_ID3v2_AttachedPictureFrame::Other' => 'Picture type Other',
'KTaglib_ID3v2_AttachedPictureFrame::OtherFileIcon' => 'Picture type OtherFileIcon',
'KTaglib_ID3v2_AttachedPictureFrame::RecordingLocation' => 'Picture type RecordingLocation',
'KTaglib_MPEG_Header::Version1' => 'ID3 version is 1.0',
'KTaglib_MPEG_Header::Version2' => 'ID3 version is 2.0',
'KTaglib_MPEG_Header::Version2_5' => 'ID3 version is 2.5',
'LATT_HASCHILDREN' => 'This mailbox has selectable inferiors.',
'LATT_HASNOCHILDREN' => 'This mailbox has no selectable inferiors.',
'LATT_MARKED' => 'This mailbox is marked. Only used by UW-IMAPD.',
'LATT_NOINFERIORS' => 'This mailbox has no "children" (there are no mailboxes below this one).',
'LATT_NOSELECT' => 'This is only a container, not a mailbox - you cannot open it.',
'LATT_REFERRAL' => 'This container has a referral to a remote mailbox.',
'LATT_UNMARKED' => 'This mailbox is not marked. Only used by UW-IMAPD.',
'LDAP_CONTROL_ASSERT' => 'Control Constant - Assertion (RFC 4528). Available as of PHP 7.3.0.',
'LDAP_CONTROL_AUTHZID_REQUEST' => 'Control Constant - Authorization Identity Request (RFC 3829). Available as of PHP 7.3.0.',
'LDAP_CONTROL_AUTHZID_RESPONSE' => 'Control Constant - Authorization Identity Response (RFC 3829). Available as of PHP 7.3.0.',
'LDAP_CONTROL_DONTUSECOPY' => 'Control Constant - Don\'t Use Copy (RFC 6171). Available as of PHP 7.3.0.',
'LDAP_CONTROL_MANAGEDSAIT' => 'Control Constant - Manage DSA IT (RFC 3296). Available as of PHP 7.3.0.',
'LDAP_CONTROL_PAGEDRESULTS' => 'Control Constant - Paged results (RFC 2696). Available as of PHP 7.3.0.',
'LDAP_CONTROL_PASSWORDPOLICYREQUEST' => 'Control Constant - Password Policy Request. Available as of PHP 7.3.0.',
'LDAP_CONTROL_PASSWORDPOLICYRESPONSE' => 'Control Constant - Password Policy Response. Available as of PHP 7.3.0.',
'LDAP_CONTROL_POST_READ' => 'Control Constant - Post read (RFC 4527). Available as of PHP 7.3.0.',
'LDAP_CONTROL_PRE_READ' => 'Control Constant - Pre read (RFC 4527). Available as of PHP 7.3.0.',
'LDAP_CONTROL_PROXY_AUTHZ' => 'Control Constant - Proxied Authorization (RFC 4370). Available as of PHP 7.3.0.',
'LDAP_CONTROL_SORTREQUEST' => 'Control Constant - Sort request (RFC 2891). Available as of PHP 7.3.0.',
'LDAP_CONTROL_SORTRESPONSE' => 'Control Constant - Sort response (RFC 2891). Available as of PHP 7.3.0.',
'LDAP_CONTROL_SUBENTRIES' => 'Control Constant - Subentries (RFC 3672). Available as of PHP 7.3.0.',
'LDAP_CONTROL_SYNC' => 'Control Constant - Content Synchronization Operation (RFC 4533). Available as of PHP 7.3.0.',
'LDAP_CONTROL_SYNC_DONE' => 'Control Constant - Content Synchronization Operation Done (RFC 4533). Available as of PHP 7.3.0.',
'LDAP_CONTROL_SYNC_STATE' => 'Control Constant - Content Synchronization Operation State (RFC 4533). Available as of PHP 7.3.0.',
'LDAP_CONTROL_VALUESRETURNFILTER' => 'Control Constant - Filter returned values (RFC 3876). Available as of PHP 7.3.0.',
'LDAP_CONTROL_VLVREQUEST' => 'Control Constant - Virtual List View Request. Available as of PHP 7.3.0.',
'LDAP_CONTROL_VLVRESPONSE' => 'Control Constant - Virtual List View Response. Available as of PHP 7.3.0.',
'LDAP_CONTROL_X_DOMAIN_SCOPE' => 'Control Constant - Active Directory Domain Scope. Available as of PHP 7.3.0.',
'LDAP_CONTROL_X_EXTENDED_DN' => 'Control Constant - Active Directory Extended DN. Available as of PHP 7.3.0.',
'LDAP_CONTROL_X_INCREMENTAL_VALUES' => 'Control Constant - Active Directory Incremental Values. Available as of PHP 7.3.0.',
'LDAP_CONTROL_X_PERMISSIVE_MODIFY' => 'Control Constant - Active Directory Permissive Modify. Available as of PHP 7.3.0.',
'LDAP_CONTROL_X_SEARCH_OPTIONS' => 'Control Constant - Active Directory Search Options. Available as of PHP 7.3.0.',
'LDAP_CONTROL_X_TREE_DELETE' => 'Control Constant - Active Directory Tree Delete. Available as of PHP 7.3.0.',
'LDAP_DEREF_ALWAYS' => 'Alias dereferencing rule - Always.',
'LDAP_DEREF_FINDING' => 'Alias dereferencing rule - Finding.',
'LDAP_DEREF_NEVER' => 'Alias dereferencing rule - Never.',
'LDAP_DEREF_SEARCHING' => 'Alias dereferencing rule - Searching.',
'LDAP_EXOP_MODIFY_PASSWD' => 'Extended Operation constant - Modify password (RFC 3062).',
'LDAP_EXOP_REFRESH' => 'Extended Operation Constant - Refresh (RFC 2589).',
'LDAP_EXOP_START_TLS' => 'Extended Operation constant - Start TLS (RFC 4511).',
'LDAP_EXOP_TURN' => 'Extended Operation Constant - Turn (RFC 4531).',
'LDAP_EXOP_WHO_AM_I' => 'Extended Operation Constant - WHOAMI (RFC 4532).',
'LDAP_OPT_CLIENT_CONTROLS' => 'Specifies a default list of client controls to be processed with each request.',
'LDAP_OPT_DEBUG_LEVEL' => 'Specifies a bitwise level for debug traces.',
'LDAP_OPT_DEREF' => 'Specifies alternative rules for following aliases at the server.',
'LDAP_OPT_DIAGNOSTIC_MESSAGE' => 'Gets the latest session error message.',
'LDAP_OPT_ERROR_NUMBER' => 'Latest session error number.',
'LDAP_OPT_ERROR_STRING' => 'Alias of `LDAP_OPT_DIAGNOSTIC_MESSAGE`.',
'LDAP_OPT_HOST_NAME' => 'Sets/gets a space-separated of hosts when trying to connect.',
'LDAP_OPT_MATCHED_DN' => 'Sets/gets the matched DN associated with the connection.',
'LDAP_OPT_NETWORK_TIMEOUT' => 'Option for `ldap_set_option` to allow setting network timeout. (Available as of PHP 5.3.0)',
'LDAP_OPT_PROTOCOL_VERSION' => 'Specifies the LDAP protocol to be used (V2 or V3).',
'LDAP_OPT_REFERRALS' => 'Specifies whether to automatically follow referrals returned by the LDAP server.',
'LDAP_OPT_RESTART' => 'Determines whether or not the connection should be implicitly restarted.',
'LDAP_OPT_SERVER_CONTROLS' => 'Specifies a default list of server controls to be sent with each request.',
'LDAP_OPT_SIZELIMIT' => 'Specifies the maximum number of entries that can be returned on a search operation.

The actual size limit for operations is also bounded by the server\'s configured maximum number of return entries. The lesser of these two settings is the actual size limit.',
'LDAP_OPT_TIMELIMIT' => 'Specifies the number of seconds to wait for search results.',
'LDAP_OPT_X_KEEPALIVE_IDLE' => 'Specifies the number of seconds a connection needs to remain idle before TCP starts sending keepalive probes.',
'LDAP_OPT_X_KEEPALIVE_INTERVAL' => 'Specifies the interval in seconds between individual keepalive probes.',
'LDAP_OPT_X_KEEPALIVE_PROBES' => 'Specifies the maximum number of keepalive probes TCP should send before dropping the connection.',
'LDAP_OPT_X_TLS_CACERTDIR' => 'Specifies the path of the directory containing CA certificates.',
'LDAP_OPT_X_TLS_CACERTFILE' => 'Specifies the full-path of the CA certificate file.',
'LDAP_OPT_X_TLS_CERTFILE' => 'Specifies the full-path of the certificate file.',
'LDAP_OPT_X_TLS_CIPHER_SUITE' => 'Specifies the allowed cipher suite.',
'LDAP_OPT_X_TLS_CRLCHECK' => 'Specifies the CRL evaluation strategy. This must be one of: `LDAP_OPT_X_TLS_CRL_NONE`,`LDAP_OPT_X_TLS_CRL_PEER`, `LDAP_OPT_X_TLS_CRL_ALL`.',
'LDAP_OPT_X_TLS_CRLFILE' => 'Specifies the full-path of the CRL file.',
'LDAP_OPT_X_TLS_DHFILE' => 'Specifies the full-path of the file containing the parameters for Diffie-Hellman ephemeral key exchange.',
'LDAP_OPT_X_TLS_KEYFILE' => 'Specifies the full-path of the certificate key file.',
'LDAP_OPT_X_TLS_PROTOCOL_MIN' => 'Specifies the minimum protocol version. This can be one of: `LDAP_OPT_X_TLS_PROTOCOL_SSL2`,`LDAP_OPT_X_TLS_PROTOCOL_SSL3`, `LDAP_OPT_X_TLS_PROTOCOL_TLS1_0`, `LDAP_OPT_X_TLS_PROTOCOL_TLS1_1`, `LDAP_OPT_X_TLS_PROTOCOL_TLS1_2`',
'LDAP_OPT_X_TLS_RANDOM_FILE' => 'Sets/gets the random file when one of the system default ones are not available.',
'LDAP_OPT_X_TLS_REQUIRE_CERT' => 'Specifies the certificate checking checking strategy. This must be one of: `LDAP_OPT_X_TLS_NEVER`,`LDAP_OPT_X_TLS_HARD`, `LDAP_OPT_X_TLS_DEMAND`, `LDAP_OPT_X_TLS_ALLOW`, `LDAP_OPT_X_TLS_TRY`. (Available as of PHP 7.0.0)',
'LIBEXSLT_DOTTED_VERSION' => 'libexslt version like 1.1.17. Available as of PHP 5.1.2.',
'LIBEXSLT_VERSION' => 'libexslt version like 813. Available as of PHP 5.1.2.',
'LIBXML_BIGLINES' => 'Allows line numbers greater than 65535 to be reported correctly.',
'LIBXML_COMPACT' => 'Activate small nodes allocation optimization. This may speed up your application without needing to change the code.',
'LIBXML_DOTTED_VERSION' => 'libxml version like 2.6.5 or 2.6.17',
'LIBXML_DTDATTR' => 'Default DTD attributes',
'LIBXML_DTDLOAD' => 'Load the external subset',
'LIBXML_DTDVALID' => 'Validate with the DTD',
'LIBXML_ERR_ERROR' => 'A recoverable error',
'LIBXML_ERR_FATAL' => 'A fatal error',
'LIBXML_ERR_NONE' => 'No errors',
'LIBXML_ERR_WARNING' => 'A simple warning',
'LIBXML_HTML_NODEFDTD' => 'Sets HTML_PARSE_NODEFDTD flag, which prevents a default doctype being added when one is not found.',
'LIBXML_HTML_NOIMPLIED' => 'Sets HTML_PARSE_NOIMPLIED flag, which turns off the automatic adding of implied html/body... elements.',
'LIBXML_NOBLANKS' => 'Remove blank nodes',
'LIBXML_NOCDATA' => 'Merge CDATA as text nodes',
'LIBXML_NOEMPTYTAG' => 'Expand empty tags (e.g. `&lt;br/&gt;` to `&lt;br&gt;&lt;/br&gt;`)',
'LIBXML_NOENT' => 'Substitute entities',
'LIBXML_NOERROR' => 'Suppress error reports',
'LIBXML_NONET' => 'Disable network access when loading documents',
'LIBXML_NOWARNING' => 'Suppress warning reports',
'LIBXML_NOXMLDECL' => 'Drop the XML declaration when saving a document',
'LIBXML_NSCLEAN' => 'Remove redundant namespace declarations',
'LIBXML_PARSEHUGE' => 'Sets XML_PARSE_HUGE flag, which relaxes any hardcoded limit from the parser. This affects limits like maximum depth of a document or the entity recursion, as well as limits of the size of text nodes.',
'LIBXML_PEDANTIC' => 'Sets XML_PARSE_PEDANTIC flag, which enables pedantic error reporting.',
'LIBXML_SCHEMA_CREATE' => 'Create default/fixed value nodes during XSD schema validation',
'LIBXML_VERSION' => 'libxml version like 20605 or 20617',
'LIBXML_XINCLUDE' => 'Implement XInclude substitution',
'LIBXSLT_DOTTED_VERSION' => 'libxslt version like 1.1.17. Available as of PHP 5.1.2.',
'LIBXSLT_VERSION' => 'libxslt version like 10117. Available as of PHP 5.1.2.',
'MB_CASE_FOLD' => 'Available since PHP 7.3.',
'MB_CASE_FOLD_SIMPLE' => 'Used by case-insensitive operations. Available since PHP 7.3.',
'MB_CASE_LOWER' => 'Performs a full lower-case folding. This may change the length of the string. This is the mode used by mb_strtolower().',
'MB_CASE_LOWER_SIMPLE' => 'Available since PHP 7.3.',
'MB_CASE_TITLE' => 'Performs a full title-case conversion based on the Cased and CaseIgnorable derived Unicode properties. In particular this improves handling of quotes and apostrophes. This may change the length of the string.',
'MB_CASE_TITLE_SIMPLE' => 'Available since PHP 7.3.',
'MB_CASE_UPPER' => 'Performs a full upper-case folding. This may change the length of the string. This is the mode used by mb_strtoupper().',
'MB_CASE_UPPER_SIMPLE' => 'Performs simple upper-case fold conversion. This does not change the length of the string. Available as of PHP 7.3.',
'MB_ONIGURUMA_VERSION' => 'The Oniguruma version, e.g. `6.9.4`. Available as of PHP 7.4.',
'Memcached::DISTRIBUTION_CONSISTENT' => '<p>Consistent hashing key distribution algorithm (based on libketama).</p>',
'Memcached::DISTRIBUTION_MODULA' => '<p>Modulo-based key distribution algorithm.</p>',
'Memcached::GET_EXTENDED' => 'A flag for `Memcached::get`, `Memcached::getMulti` and `Memcached::getMultiByKey` to ensure that the CAS token values are returned as well.',
'Memcached::GET_PRESERVE_ORDER' => '<p>A flag for <b>Memcached::getMulti</b> and
<b>Memcached::getMultiByKey</b> to ensure that the keys are
returned in the same order as they were requested in. Non-existing keys
get a default value of NULL.</p>',
'Memcached::HASH_CRC' => '<p>CRC item key hashing algorithm.</p>',
'Memcached::HASH_DEFAULT' => '<p>The default (Jenkins one-at-a-time) item key hashing algorithm.</p>',
'Memcached::HASH_FNV1_32' => '<p>FNV1_32 item key hashing algorithm.</p>',
'Memcached::HASH_FNV1_64' => '<p>FNV1_64 item key hashing algorithm.</p>',
'Memcached::HASH_FNV1A_32' => '<p>FNV1_32A item key hashing algorithm.</p>',
'Memcached::HASH_FNV1A_64' => '<p>FNV1_64A item key hashing algorithm.</p>',
'Memcached::HASH_HSIEH' => '<p>Hsieh item key hashing algorithm.</p>',
'Memcached::HASH_MD5' => '<p>MD5 item key hashing algorithm.</p>',
'Memcached::HASH_MURMUR' => '<p>Murmur item key hashing algorithm.</p>',
'Memcached::HAVE_IGBINARY' => 'Indicates whether igbinary serializer support is available.',
'Memcached::HAVE_JSON' => 'Indicates whether JSON serializer support is available.',
'Memcached::HAVE_MSGPACK' => 'Indicates whether msgpack serializer support is available.',
'Memcached::HAVE_SASL' => 'Whether SASL is available for authentication',
'Memcached::HAVE_SESSION' => 'Whether memcached can be used for storing session data',
'Memcached::OPT_BINARY_PROTOCOL' => '<p>Enable the use of the binary protocol. Please note that you cannot
toggle this option on an open connection.</p>
<p>Type: boolean, default: <b>FALSE</b>.</p>',
'Memcached::OPT_BUFFER_WRITES' => '<p>Enables or disables buffered I/O. Enabling buffered I/O causes
storage commands to "buffer" instead of being sent. Any action that
retrieves data causes this buffer to be sent to the remote connection.
Quitting the connection or closing down the connection will also cause
the buffered data to be pushed to the remote connection.</p>
<p>Type: boolean, default: <b>FALSE</b>.</p>',
'Memcached::OPT_CACHE_LOOKUPS' => '<p>Enables or disables caching of DNS lookups.</p>
<p>Type: boolean, default: <b>FALSE</b>.</p>',
'Memcached::OPT_COMPRESSION' => '<p>Enables or disables payload compression. When enabled,
item values longer than a certain threshold (currently 100 bytes) will be
compressed during storage and decompressed during retrieval
transparently.</p>
<p>Type: boolean, default: <b>TRUE</b>.</p>',
'Memcached::OPT_CONNECT_TIMEOUT' => '<p>In non-blocking mode this set the value of the timeout during socket
connection, in milliseconds.</p>
<p>Type: integer, default: 1000.</p>',
'Memcached::OPT_DISTRIBUTION' => '<p>Specifies the method of distributing item keys to the servers.
Currently supported methods are modulo and consistent hashing. Consistent
hashing delivers better distribution and allows servers to be added to
the cluster with minimal cache losses.</p>
<p>Type: integer, default: <b>Memcached::DISTRIBUTION_MODULA.</b></p>',
'Memcached::OPT_HASH' => '<p>Specifies the hashing algorithm used for the item keys. The valid
values are supplied via <b>Memcached::HASH_*</b> constants.
Each hash algorithm has its advantages and its disadvantages. Go with the
default if you don\'t know or don\'t care.</p>
<p>Type: integer, default: <b>Memcached::HASH_DEFAULT</b></p>',
'Memcached::OPT_LIBKETAMA_COMPATIBLE' => '<p>Enables or disables compatibility with libketama-like behavior. When
enabled, the item key hashing algorithm is set to MD5 and distribution is
set to be weighted consistent hashing distribution. This is useful
because other libketama-based clients (Python, Ruby, etc.) with the same
server configuration will be able to access the keys transparently.
</p>
<p>
It is highly recommended to enable this option if you want to use
consistent hashing, and it may be enabled by default in future
releases.
</p>
<p>Type: boolean, default: <b>FALSE</b>.</p>',
'Memcached::OPT_NO_BLOCK' => '<p>Enables or disables asynchronous I/O. This is the fastest transport
available for storage functions.</p>
<p>Type: boolean, default: <b>FALSE</b>.</p>',
'Memcached::OPT_POLL_TIMEOUT' => '<p>Timeout for connection polling, in milliseconds.</p>
<p>Type: integer, default: 1000.</p>',
'Memcached::OPT_PREFIX_KEY' => '<p>This can be used to create a "domain" for your item keys. The value
specified here will be prefixed to each of the keys. It cannot be
longer than 128 characters and will reduce the
maximum available key size. The prefix is applied only to the item keys,
not to the server keys.</p>
<p>Type: string, default: "".</p>',
'Memcached::OPT_RECV_TIMEOUT' => '<p>Socket reading timeout, in microseconds. In cases where you cannot
use non-blocking I/O this will allow you to still have timeouts on the
reading of data.</p>
<p>Type: integer, default: 0.</p>',
'Memcached::OPT_RETRY_TIMEOUT' => '<p>The amount of time, in seconds, to wait until retrying a failed
connection attempt.</p>
<p>Type: integer, default: 0.</p>',
'Memcached::OPT_SEND_TIMEOUT' => '<p>Socket sending timeout, in microseconds. In cases where you cannot
use non-blocking I/O this will allow you to still have timeouts on the
sending of data.</p>
<p>Type: integer, default: 0.</p>',
'Memcached::OPT_SERIALIZER' => '<p>
Specifies the serializer to use for serializing non-scalar values.
The valid serializers are <b>Memcached::SERIALIZER_PHP</b>
or <b>Memcached::SERIALIZER_IGBINARY</b>. The latter is
supported only when memcached is configured with
--enable-memcached-igbinary option and the
igbinary extension is loaded.
</p>
<p>Type: integer, default: <b>Memcached::SERIALIZER_PHP</b>.</p>',
'Memcached::OPT_SERVER_FAILURE_LIMIT' => '<p>Specifies the failure limit for server connection attempts. The
server will be removed after this many continuous connection
failures.</p>
<p>Type: integer, default: 0.</p>',
'Memcached::OPT_SOCKET_RECV_SIZE' => '<p>The maximum socket receive buffer in bytes.</p>
<p>Type: integer, default: varies by platform/kernel
configuration.</p>',
'Memcached::OPT_SOCKET_SEND_SIZE' => '<p>The maximum socket send buffer in bytes.</p>
<p>Type: integer, default: varies by platform/kernel
configuration.</p>',
'Memcached::OPT_TCP_NODELAY' => '<p>Enables or disables the no-delay feature for connecting sockets (may
be faster in some environments).</p>
<p>Type: boolean, default: <b>FALSE</b>.</p>',
'Memcached::RES_AUTH_CONTINUE' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_AUTH_FAILURE' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_AUTH_PROBLEM' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_BAD_KEY_PROVIDED' => '<p>Bad key.</p>',
'Memcached::RES_BUFFERED' => '<p>The operation was buffered.</p>',
'Memcached::RES_CLIENT_ERROR' => '<p>Error on the client side.</p>',
'Memcached::RES_CONNECTION_SOCKET_CREATE_FAILURE' => '<p>Failed to create network socket.</p>',
'Memcached::RES_DATA_EXISTS' => '<p>Failed to do compare-and-swap: item you are trying to store has been
modified since you last fetched it.</p>',
'Memcached::RES_E2BIG' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_END' => '<p>End of result set.</p>',
'Memcached::RES_ERRNO' => '<p>System error.</p>',
'Memcached::RES_FAILURE' => '<p>The operation failed in some fashion.</p>',
'Memcached::RES_HOST_LOOKUP_FAILURE' => '<p>DNS lookup failed.</p>',
'Memcached::RES_KEY_TOO_BIG' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_NO_SERVERS' => '<p>Server list is empty.</p>',
'Memcached::RES_NOTFOUND' => '<p>Item with this key was not found (with "get" operation or "case"
operations).</p>',
'Memcached::RES_NOTSTORED' => '<p>Item was not stored: but not because of an error. This normally
means that either the condition for an "add" or a "replace" command
wasn\'t met, or that the item is in a delete queue.</p>',
'Memcached::RES_PARTIAL_READ' => '<p>Partial network data read error.</p>',
'Memcached::RES_PAYLOAD_FAILURE' => '<p>Payload failure: could not compress/decompress or serialize/unserialize the value.</p>',
'Memcached::RES_PROTOCOL_ERROR' => '<p>Bad command in memcached protocol.</p>',
'Memcached::RES_SERVER_ERROR' => '<p>Error on the server side.</p>',
'Memcached::RES_SERVER_MEMORY_ALLOCATION_FAILURE' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_SERVER_TEMPORARILY_DISABLED' => 'Available as of Memcached 3.0.0.',
'Memcached::RES_SOME_ERRORS' => '<p>Some errors occurred during multi-get.</p>',
'Memcached::RES_SUCCESS' => '<p>The operation was successful.</p>',
'Memcached::RES_TIMEOUT' => '<p>The operation timed out.</p>',
'Memcached::RES_UNKNOWN_READ_FAILURE' => '<p>Failed to read network data.</p>',
'Memcached::RES_WRITE_FAILURE' => '<p>Failed to write network data.</p>',
'Memcached::SERIALIZER_IGBINARY' => '<p>The igbinary serializer.
Instead of textual representation it stores PHP data structures in a
compact binary form, resulting in space and time gains.</p>',
'Memcached::SERIALIZER_JSON' => '<p>The JSON serializer. Requires PHP 5.2.10+.</p>',
'Memcached::SERIALIZER_PHP' => '<p>The default PHP serializer.</p>',
'MONGO_STREAMS' => 'Alias of `MONGO_SUPPORTS_STREAMS`',
'MONGO_SUPPORTS_AUTH_MECHANISM_GSSAPI' => '1 when GSSAPI authentication is compiled in.',
'MONGO_SUPPORTS_AUTH_MECHANISM_MONGODB_CR' => '1 when MongoDB-Challenge/Response authentication is compiled in.',
'MONGO_SUPPORTS_AUTH_MECHANISM_MONGODB_X509' => '1 when x.509 authentication is compiled in.',
'MONGO_SUPPORTS_AUTH_MECHANISM_PLAIN' => '1 when PLAIN authentication is compiled in.',
'MONGO_SUPPORTS_SSL' => '1 when the PHP manual\'s section on book.openssl is enabled and available.',
'MONGO_SUPPORTS_STREAMS' => '1 when compiled against PHP Streams (default since 1.4.0).',
'MongoBinData::BYTE_ARRAY' => 'Generic binary data (deprecated in favor of MongoBinData::GENERIC)',
'MongoBinData::CUSTOM' => 'User-defined type',
'MongoBinData::FUNC' => 'Function',
'MongoBinData::GENERIC' => 'Generic binary data.',
'MongoBinData::MD5' => 'MD5',
'MongoBinData::UUID' => 'Universally unique identifier (deprecated in favor of MongoBinData::UUID_RFC4122)',
'MongoBinData::UUID_RFC4122' => 'Universally unique identifier (according to » RFC 4122)',
'MongoDB::PROFILING_OFF' => 'Profiling is off.',
'MongoDB::PROFILING_ON' => 'Profiling is on for all operations.',
'MongoDB::PROFILING_SLOW' => 'Profiling is on for slow operations (>100 ms).',
'MongoDB\Driver\WriteConcern::MAJORITY' => 'Majority of all the members in the set; arbiters, non-voting members, passive members, hidden members and delayed members are all included in the definition of majority write concern.',
'MONGODB_STABILITY' => 'Current stability (alpha/beta/stable)',
'MONGODB_VERSION' => 'x.y.z style version number of the extension',
'MS_TRUE' => 'Mapscript extension (version 7.0.*)
Parsed from documentation
Generated at 2017-08-24 16:06:54',
'MSG_EOF' => 'Not available on Windows platforms.',
'MSG_EOR' => 'Not available on Windows platforms.',
'MSSQL_ASSOC' => 'Return an associative array. Used on `mssql_fetch_array`\'s `result_type` parameter.',
'MSSQL_BOTH' => 'Return an array with both numeric keys and keys with their field name. This is the default value for `mssql_fetch_array`\'s `result_type` parameter.',
'MSSQL_NUM' => 'Return an array with numeric keys. Used on `mssql_fetch_array`\'s `result_type` parameter.',
'MYSQLI_ASSOC' => 'Columns are returned into the array having the fieldname as the array index.',
'MYSQLI_AUTO_INCREMENT_FLAG' => 'Field is defined as `AUTO_INCREMENT`',
'MYSQLI_BINARY_FLAG' => 'Field is defined as `BINARY`.',
'MYSQLI_BLOB_FLAG' => 'Field is defined as `BLOB`',
'MYSQLI_BOTH' => 'Columns are returned into the array having both a numerical index and the fieldname as the associative index.',
'MYSQLI_CLIENT_COMPRESS' => 'Use compression protocol',
'MYSQLI_CLIENT_IGNORE_SPACE' => 'Allow spaces after function names. Makes all functions names reserved words.',
'MYSQLI_CLIENT_INTERACTIVE' => 'Allow `interactive_timeout` seconds (instead of `wait_timeout` seconds) of inactivity before closing the connection. The client\'s session `wait_timeout` variable will be set to the value of the session `interactive_timeout` variable.',
'MYSQLI_CLIENT_MULTI_QUERIES' => 'Allows multiple semicolon-delimited queries in a single `mysqli_query` call.',
'MYSQLI_CLIENT_NO_SCHEMA' => 'Don\'t allow the `db_name.tbl_name.col_name` syntax.',
'MYSQLI_CLIENT_SSL' => 'Use SSL (encrypted protocol). This option should not be set by application programs; it is set internally in the MySQL client library',
'MYSQLI_DATA_TRUNCATED' => 'Data truncation occurred. Available since PHP 5.1.0 and MySQL 5.0.5.',
'MYSQLI_DEBUG_TRACE_ENABLED' => 'Is set to 1 if `mysqli_debug` functionality is enabled.',
'MYSQLI_ENUM_FLAG' => 'Field is defined as `ENUM`.',
'MYSQLI_GROUP_FLAG' => 'Field is part of `GROUP BY`',
'MYSQLI_INIT_COMMAND' => 'Command to execute when connecting to MySQL server. Will automatically be re-executed when reconnecting.',
'MYSQLI_MULTIPLE_KEY_FLAG' => 'Field is part of an index.',
'MYSQLI_NEED_DATA' => 'More data available for bind variable',
'MYSQLI_NO_DATA' => 'No more data available for bind variable',
'MYSQLI_NOT_NULL_FLAG' => 'Indicates that a field is defined as `NOT NULL`',
'MYSQLI_NUM' => 'Columns are returned into the array having an enumerated index.',
'MYSQLI_NUM_FLAG' => 'Field is defined as `NUMERIC`',
'MYSQLI_OPT_CONNECT_TIMEOUT' => 'Connect timeout in seconds',
'MYSQLI_OPT_LOCAL_INFILE' => 'Enables command `LOAD LOCAL INFILE`',
'MYSQLI_PART_KEY_FLAG' => 'Field is part of an multi-index',
'MYSQLI_PRI_KEY_FLAG' => 'Field is part of a primary index',
'MYSQLI_READ_DEFAULT_FILE' => 'Read options from the named option file instead of from my.cnf',
'MYSQLI_READ_DEFAULT_GROUP' => 'Read options from the named group from my.cnf or the file specified with `MYSQLI_READ_DEFAULT_FILE`',
'MYSQLI_REFRESH_GRANT' => 'Refreshes the grant tables.',
'MYSQLI_REFRESH_HOSTS' => 'Flushes the host cache, like executing the `FLUSH HOSTS` SQL statement.',
'MYSQLI_REFRESH_LOG' => 'Flushes the logs, like executing the `FLUSH LOGS` SQL statement.',
'MYSQLI_REFRESH_MASTER' => 'On a master replication server: removes the binary log files listed in the binary log index, and truncates the index file. Like executing the `RESET MASTER` SQL statement.',
'MYSQLI_REFRESH_SLAVE' => 'On a slave replication server: resets the master server information, and restarts the slave. Like executing the `RESET SLAVE` SQL statement.',
'MYSQLI_REFRESH_STATUS' => 'Reset the status variables, like executing the `FLUSH STATUS` SQL statement.',
'MYSQLI_REFRESH_TABLES' => 'Flushes the table cache, like executing the `FLUSH TABLES` SQL statement.',
'MYSQLI_REFRESH_THREADS' => 'Flushes the thread cache.',
'MYSQLI_REPORT_ALL' => 'Set all options on (report all).',
'MYSQLI_REPORT_ERROR' => 'Report errors from mysqli function calls.',
'MYSQLI_REPORT_INDEX' => 'Report if no index or bad index was used in a query.',
'MYSQLI_REPORT_OFF' => 'Turns reporting off.',
'MYSQLI_REPORT_STRICT' => 'Throw a `mysqli_sql_exception` for errors instead of warnings.',
'MYSQLI_SET_FLAG' => 'Field is defined as `SET`',
'MYSQLI_STORE_RESULT' => 'For using buffered resultsets',
'MYSQLI_TIMESTAMP_FLAG' => 'Field is defined as `TIMESTAMP`',
'MYSQLI_TRANS_COR_AND_CHAIN' => 'Appends "AND CHAIN" to `mysqli_commit` or `mysqli_rollback`.',
'MYSQLI_TRANS_COR_AND_NO_CHAIN' => 'Appends "AND NO CHAIN" to `mysqli_commit` or `mysqli_rollback`.',
'MYSQLI_TRANS_COR_NO_RELEASE' => 'Appends "NO RELEASE" to `mysqli_commit` or `mysqli_rollback`.',
'MYSQLI_TRANS_COR_RELEASE' => 'Appends "RELEASE" to `mysqli_commit` or `mysqli_rollback`.',
'MYSQLI_TRANS_START_CONSISTENT_SNAPSHOT' => 'Start the transaction as "START TRANSACTION WITH CONSISTENT SNAPSHOT" with `mysqli_begin_transaction`.',
'MYSQLI_TRANS_START_READ_ONLY' => 'Start the transaction as "START TRANSACTION READ ONLY" with `mysqli_begin_transaction`.',
'MYSQLI_TRANS_START_READ_WRITE' => 'Start the transaction as "START TRANSACTION READ WRITE" with `mysqli_begin_transaction`.',
'MYSQLI_TYPE_BIT' => 'Field is defined as `BIT` (MySQL 5.0.3 and up)',
'MYSQLI_TYPE_BLOB' => 'Field is defined as `BLOB`',
'MYSQLI_TYPE_CHAR' => 'Field is defined as `TINYINT`. For `CHAR`, see `MYSQLI_TYPE_STRING`',
'MYSQLI_TYPE_DATE' => 'Field is defined as `DATE`',
'MYSQLI_TYPE_DATETIME' => 'Field is defined as `DATETIME`',
'MYSQLI_TYPE_DECIMAL' => 'Field is defined as `DECIMAL`',
'MYSQLI_TYPE_DOUBLE' => 'Field is defined as `DOUBLE`',
'MYSQLI_TYPE_ENUM' => 'Field is defined as `ENUM`',
'MYSQLI_TYPE_FLOAT' => 'Field is defined as `FLOAT`',
'MYSQLI_TYPE_GEOMETRY' => 'Field is defined as `GEOMETRY`',
'MYSQLI_TYPE_INT24' => 'Field is defined as `MEDIUMINT`',
'MYSQLI_TYPE_INTERVAL' => 'Field is defined as `INTERVAL`',
'MYSQLI_TYPE_LONG' => 'Field is defined as `INT`',
'MYSQLI_TYPE_LONG_BLOB' => 'Field is defined as `LONGBLOB`',
'MYSQLI_TYPE_LONGLONG' => 'Field is defined as `BIGINT`',
'MYSQLI_TYPE_MEDIUM_BLOB' => 'Field is defined as `MEDIUMBLOB`',
'MYSQLI_TYPE_NEWDATE' => 'Field is defined as `DATE`',
'MYSQLI_TYPE_NEWDECIMAL' => 'Precision math `DECIMAL` or `NUMERIC` field (MySQL 5.0.3 and up)',
'MYSQLI_TYPE_NULL' => 'Field is defined as `DEFAULT NULL`',
'MYSQLI_TYPE_SET' => 'Field is defined as `SET`',
'MYSQLI_TYPE_SHORT' => 'Field is defined as `SMALLINT`',
'MYSQLI_TYPE_STRING' => 'Field is defined as `CHAR` or `BINARY`',
'MYSQLI_TYPE_TIME' => 'Field is defined as `TIME`',
'MYSQLI_TYPE_TIMESTAMP' => 'Field is defined as `TIMESTAMP`',
'MYSQLI_TYPE_TINY' => 'Field is defined as `TINYINT`',
'MYSQLI_TYPE_TINY_BLOB' => 'Field is defined as `TINYBLOB`',
'MYSQLI_TYPE_VAR_STRING' => 'Field is defined as `VARCHAR`',
'MYSQLI_TYPE_YEAR' => 'Field is defined as `YEAR`',
'MYSQLI_UNIQUE_KEY_FLAG' => 'Field is part of a unique index.',
'MYSQLI_UNSIGNED_FLAG' => 'Field is defined as `UNSIGNED`',
'MYSQLI_USE_RESULT' => 'For using unbuffered resultsets',
'MYSQLI_ZEROFILL_FLAG' => 'Field is defined as `ZEROFILL`',
'MYSQLND_MEMCACHE_DEFAULT_REGEXP' => 'Default regular expression (PCRE style) used for matching `SELECT` statements that will be mapped into a MySQL Memcache Plugin access point, if possible.

It is also possible to use `mysqlnd_memcache_set`, but the default approach is using this regular expression for pattern matching.',
'MYSQLND_MEMCACHE_VERSION' => 'Plugin version string, for example, 1.0.0-alpha.',
'MYSQLND_MEMCACHE_VERSION_ID' => 'Plugin version number, for example, 10000.',
'MYSQLND_MS_LAST_USED_SWITCH' => 'SQL hint used to send a query to the last used MySQL server. The last used MySQL server can either be a master or a slave server in a MySQL replication setup.',
'MYSQLND_MS_MASTER_SWITCH' => 'SQL hint used to send a query to the MySQL replication master server.',
'MYSQLND_MS_QOS_CONSISTENCY_EVENTUAL' => 'Use to request the service level eventual consistency from the `mysqlnd_ms_set_qos`. Eventual consistency is the default quality of service when reading from an asynchronous MySQL replication slave. Data returned in this service level may or may not be stale, depending on whether the selected slaves happen to have replicated the latest changes from the MySQL replication master or not.',
'MYSQLND_MS_QOS_CONSISTENCY_SESSION' => 'Use to request the service level session consistency from the `mysqlnd_ms_set_qos`. Session consistency is defined as read your writes. The client is guaranteed to see his latest changes.',
'MYSQLND_MS_QOS_CONSISTENCY_STRONG' => 'Use to request the service level strong consistency from the `mysqlnd_ms_set_qos`. Strong consistency is used to ensure all clients see each others changes.',
'MYSQLND_MS_QOS_OPTION_AGE' => 'Used as a service level option with `mysqlnd_ms_set_qos` to parameterize eventual consistency.',
'MYSQLND_MS_QOS_OPTION_GTID' => 'Used as a service level option with `mysqlnd_ms_set_qos` to parameterize session consistency.',
'MYSQLND_MS_QUERY_USE_LAST_USED' => 'If `mysqlnd_ms_is_select` returns `MYSQLND_MS_QUERY_USE_LAST_USED` for a given query, the built-in read/write split mechanism recommends sending the query to the last used server.',
'MYSQLND_MS_QUERY_USE_MASTER' => 'If `mysqlnd_ms_is_select` returns `MYSQLND_MS_QUERY_USE_MASTER` for a given query, the built-in read/write split mechanism recommends sending the query to a MySQL replication master server.',
'MYSQLND_MS_QUERY_USE_SLAVE' => 'If `mysqlnd_ms_is_select` returns `MYSQLND_MS_QUERY_USE_SLAVE` for a given query, the built-in read/write split mechanism recommends sending the query to a MySQL replication slave server.',
'MYSQLND_MS_SLAVE_SWITCH' => 'SQL hint used to send a query to one of the MySQL replication slave servers.',
'MYSQLND_MS_VERSION' => 'Plugin version string, for example, 1.0.0-prototype.',
'MYSQLND_MS_VERSION_ID' => 'Plugin version number, for example, 10000.',
'MYSQLND_MUX_VERSION' => 'Plugin version string, for example, 1.0.0-prototype.',
'MYSQLND_MUX_VERSION_ID' => 'Plugin version number, for example, 10000.',
'MYSQLND_QC_CONDITION_META_SCHEMA_PATTERN' => 'Used as a parameter of `mysqlnd_qc_set_cache_condition` to set conditions for schema based automatic caching.',
'MYSQLND_QC_DISABLE_SWITCH' => 'SQL hint used to disable caching of a query if `mysqlnd_qc.cache_by_default = 1`.',
'MYSQLND_QC_ENABLE_SWITCH' => 'SQL hint used to enable caching of a query.',
'MYSQLND_QC_SERVER_ID_SWITCH' => 'This SQL hint should not be used in general.

It is needed by PECL/mysqlnd_ms to group cache entries for one statement but originating from different physical connections. If the hint is used connection settings such as user, hostname and charset are not considered for generating a cache key of a query. Instead the given value and the query string are used as input to the hashing function that generates the key.

PECL/mysqlnd_ms may, if instructed, cache results from MySQL Replication slaves. Because it can hold many connections to the slave the cache key shall not be formed from the user, hostname or other settings that may vary for the various slave connections. Instead, PECL/mysqlnd_ms provides an identifier which refers to the group of slave connections that shall be enabled to share cache entries no matter which physical slave connection was to generate the cache entry.

Use of this feature outside of PECL/mysqlnd_ms is not recommended.',
'MYSQLND_QC_TTL_SWITCH' => 'SQL hint used to set the TTL of a result set.',
'MYSQLND_QC_VERSION' => 'Plugin version string, for example, 1.0.0-prototype.',
'MYSQLND_QC_VERSION_ID' => 'Plugin version number, for example, 10000.',
'MYSQLND_UH_MYSQLND_CHG_USER_RESP_PACKET' => 'MySQL Client Server protocol packet: change user response.',
'MYSQLND_UH_MYSQLND_CLOSE_DISCONNECTED' => 'Connection error.',
'MYSQLND_UH_MYSQLND_CLOSE_EXPLICIT' => 'User has called mysqlnd to close the connection.',
'MYSQLND_UH_MYSQLND_CLOSE_IMPLICIT' => 'Implicitly closed, for example, during garbage connection.',
'MYSQLND_UH_MYSQLND_CLOSE_LAST' => 'No practical meaning. Last entry marker of internal C data structure list.',
'MYSQLND_UH_MYSQLND_COM_BINLOG_DUMP' => 'MySQL Client Server protocol command: COM_BINLOG_DUMP.',
'MYSQLND_UH_MYSQLND_COM_CHANGE_USER' => 'MySQL Client Server protocol command: COM_CHANGE_USER.',
'MYSQLND_UH_MYSQLND_COM_CONNECT' => 'MySQL Client Server protocol command: COM_CONNECT.',
'MYSQLND_UH_MYSQLND_COM_CONNECT_OUT' => 'MySQL Client Server protocol command: COM_CONNECT_OUT.',
'MYSQLND_UH_MYSQLND_COM_CREATE_DB' => 'MySQL Client Server protocol command: COM_CREATE_DB.',
'MYSQLND_UH_MYSQLND_COM_DAEMON' => 'MySQL Client Server protocol command: COM_DAEMON.',
'MYSQLND_UH_MYSQLND_COM_DEBUG' => 'MySQL Client Server protocol command: COM_DEBUG.',
'MYSQLND_UH_MYSQLND_COM_DELAYED_INSERT' => 'MySQL Client Server protocol command: COM_DELAYED_INSERT.',
'MYSQLND_UH_MYSQLND_COM_DROP_DB' => 'MySQL Client Server protocol command: COM_DROP_DB.',
'MYSQLND_UH_MYSQLND_COM_END' => 'MySQL Client Server protocol command: COM_END.',
'MYSQLND_UH_MYSQLND_COM_FIELD_LIST' => 'MySQL Client Server protocol command: COM_FIELD_LIST.',
'MYSQLND_UH_MYSQLND_COM_INIT_DB' => 'MySQL Client Server protocol command: COM_INIT_DB.',
'MYSQLND_UH_MYSQLND_COM_PING' => 'MySQL Client Server protocol command: COM_PING.',
'MYSQLND_UH_MYSQLND_COM_PROCESS_INFO' => 'MySQL Client Server protocol command: COM_PROCESS_INFO.',
'MYSQLND_UH_MYSQLND_COM_PROCESS_KILL' => 'MySQL Client Server protocol command: COM_PROCESS_KILL.',
'MYSQLND_UH_MYSQLND_COM_QUERY' => 'MySQL Client Server protocol command: COM_QUERY.',
'MYSQLND_UH_MYSQLND_COM_QUIT' => 'MySQL Client Server protocol command: COM_QUIT.',
'MYSQLND_UH_MYSQLND_COM_REFRESH' => 'MySQL Client Server protocol command: COM_REFRESH.',
'MYSQLND_UH_MYSQLND_COM_REGISTER_SLAVED' => 'MySQL Client Server protocol command: COM_REGISTER_SLAVED.',
'MYSQLND_UH_MYSQLND_COM_SET_OPTION' => 'MySQL Client Server protocol command: COM_SET_OPTION.',
'MYSQLND_UH_MYSQLND_COM_SHUTDOWN' => 'MySQL Client Server protocol command: COM_SHUTDOWN.',
'MYSQLND_UH_MYSQLND_COM_SLEEP' => 'MySQL Client Server protocol command: COM_SLEEP.',
'MYSQLND_UH_MYSQLND_COM_STATISTICS' => 'MySQL Client Server protocol command: COM_STATISTICS.',
'MYSQLND_UH_MYSQLND_COM_STMT_CLOSE' => 'MySQL Client Server protocol command: COM_STMT_CLOSE.',
'MYSQLND_UH_MYSQLND_COM_STMT_EXECUTE' => 'MySQL Client Server protocol command: COM_STMT_EXECUTE.',
'MYSQLND_UH_MYSQLND_COM_STMT_FETCH' => 'MySQL Client Server protocol command: COM_STMT_FETCH.',
'MYSQLND_UH_MYSQLND_COM_STMT_PREPARE' => 'MySQL Client Server protocol command: COM_STMT_PREPARE.',
'MYSQLND_UH_MYSQLND_COM_STMT_RESET' => 'MySQL Client Server protocol command: COM_STMT_RESET.',
'MYSQLND_UH_MYSQLND_COM_STMT_SEND_LONG_DATA' => 'MySQL Client Server protocol command: COM_STMT_SEND_LONG_DATA.',
'MYSQLND_UH_MYSQLND_COM_TABLE_DUMP' => 'MySQL Client Server protocol command: COM_TABLE_DUMP.',
'MYSQLND_UH_MYSQLND_COM_TIME' => 'MySQL Client Server protocol command: COM_TIME.',
'MYSQLND_UH_MYSQLND_OPT_AUTH_PROTOCOL' => 'Option: TODO. Available as of `PHP 5.4.0`.',
'MYSQLND_UH_MYSQLND_OPT_GUESS_CONNECTION' => 'TODO',
'MYSQLND_UH_MYSQLND_OPT_INT_AND_FLOAT_NATIVE' => 'Option: make mysqlnd return integer and float columns as long even when using the MySQL Client Server text protocol. Only available with a custom build of mysqlnd.',
'MYSQLND_UH_MYSQLND_OPT_LOCAL_INFILE' => 'Option: Whether to allow `LOAD DATA LOCAL INFILE` use.',
'MYSQLND_UH_MYSQLND_OPT_MAX_ALLOWED_PACKET' => 'Option: maximum allowed packet size. Available as of `PHP 5.4.0`.',
'MYSQLND_UH_MYSQLND_OPT_NET_CMD_BUFFER_SIZE' => 'Option: mysqlnd network buffer size for commands.',
'MYSQLND_UH_MYSQLND_OPT_NET_READ_BUFFER_SIZE' => 'Option: mysqlnd network buffer size for reading from the server.',
'MYSQLND_UH_MYSQLND_OPT_PROTOCOL' => 'Option: supported protocol version.',
'MYSQLND_UH_MYSQLND_OPT_READ_TIMEOUT' => 'Option: connection read timeout.',
'MYSQLND_UH_MYSQLND_OPT_RECONNECT' => 'Option: Whether to reconnect automatically.',
'MYSQLND_UH_MYSQLND_OPT_SSL_CA' => 'Option: SSL CA.',
'MYSQLND_UH_MYSQLND_OPT_SSL_CAPATH' => 'Option: Path to SSL CA.',
'MYSQLND_UH_MYSQLND_OPT_SSL_CERT' => 'Option: SSL certificate.',
'MYSQLND_UH_MYSQLND_OPT_SSL_CIPHER' => 'Option: SSL cipher.',
'MYSQLND_UH_MYSQLND_OPT_SSL_KEY' => 'Option: SSL key.',
'MYSQLND_UH_MYSQLND_OPT_SSL_PASSPHRASE' => 'Option: SSL passphrase.',
'MYSQLND_UH_MYSQLND_OPT_SSL_VERIFY_SERVER_CERT' => 'Option: TODO',
'MYSQLND_UH_MYSQLND_OPT_USE_EMBEDDED_CONNECTION' => 'Embedded server related.',
'MYSQLND_UH_MYSQLND_OPT_USE_REMOTE_CONNECTION' => 'Embedded server related.',
'MYSQLND_UH_MYSQLND_OPT_USE_RESULT' => 'Option: unbuffered result sets.',
'MYSQLND_UH_MYSQLND_OPT_WRITE_TIMEOUT' => 'Option: connection write timeout.',
'MYSQLND_UH_MYSQLND_OPTION_INIT_COMMAND' => 'Option: init command to execute upon connect.',
'MYSQLND_UH_MYSQLND_OPTION_OPT_COMPRESS' => 'Option: whether the MySQL compressed protocol is to be used.',
'MYSQLND_UH_MYSQLND_OPTION_OPT_CONNECT_TIMEOUT' => 'Option: connection timeout.',
'MYSQLND_UH_MYSQLND_OPTION_OPT_NAMED_PIPE' => 'Option: named pipe to use for connection (Windows).',
'MYSQLND_UH_MYSQLND_PREPARE_RESP_PACKET' => 'MySQL Client Server protocol packet: prepare response.',
'MYSQLND_UH_MYSQLND_PROT_AUTH_PACKET' => 'MySQL Client Server protocol packet: authentication.',
'MYSQLND_UH_MYSQLND_PROT_CMD_PACKET' => 'MySQL Client Server protocol packet: command.',
'MYSQLND_UH_MYSQLND_PROT_EOF_PACKET' => 'MySQL Client Server protocol packet: EOF.',
'MYSQLND_UH_MYSQLND_PROT_GREET_PACKET' => 'MySQL Client Server protocol packet: greeting.',
'MYSQLND_UH_MYSQLND_PROT_LAST' => 'No practical meaning. Last entry marker of internal C data structure list.',
'MYSQLND_UH_MYSQLND_PROT_OK_PACKET' => 'MySQL Client Server protocol packet: OK.',
'MYSQLND_UH_MYSQLND_PROT_ROW_PACKET' => 'MySQL Client Server protocol packet: row.',
'MYSQLND_UH_MYSQLND_PROT_RSET_FLD_PACKET' => 'MySQL Client Server protocol packet: resultset field.',
'MYSQLND_UH_MYSQLND_PROT_RSET_HEADER_PACKET' => 'MySQL Client Server protocol packet: result set header.',
'MYSQLND_UH_MYSQLND_PROT_STATS_PACKET' => 'MySQL Client Server protocol packet: stats.',
'MYSQLND_UH_MYSQLND_READ_DEFAULT_FILE' => 'Option: MySQL server default file to read upon connect.',
'MYSQLND_UH_MYSQLND_READ_DEFAULT_GROUP' => 'Option: MySQL server default file group to read upon connect.',
'MYSQLND_UH_MYSQLND_REPORT_DATA_TRUNCATION' => 'Option: Whether to report data truncation.',
'MYSQLND_UH_MYSQLND_SECURE_AUTH' => 'TODO',
'MYSQLND_UH_MYSQLND_SET_CHARSET_DIR' => 'Option: charset description files directory.',
'MYSQLND_UH_MYSQLND_SET_CHARSET_NAME' => 'Option: charset name.',
'MYSQLND_UH_MYSQLND_SET_CLIENT_IP' => 'TODO',
'MYSQLND_UH_MYSQLND_SHARED_MEMORY_BASE_NAME' => 'Option: shared memory base name for shared memory connections.',
'MYSQLND_UH_SERVER_OPTION_DEFAULT_AUTH' => 'Option: default authentication method.',
'MYSQLND_UH_SERVER_OPTION_MULTI_STATEMENTS_OFF' => 'Option: disables multi statement support.',
'MYSQLND_UH_SERVER_OPTION_MULTI_STATEMENTS_ON' => 'Option: enables multi statement support.',
'MYSQLND_UH_SERVER_OPTION_PLUGIN_DIR' => 'Option: server plugin directory.',
'MYSQLND_UH_SERVER_OPTION_SET_CLIENT_IP' => 'TODO',
'MYSQLND_UH_VERSION' => 'Plugin version string, for example, 1.0.0-alpha.',
'MYSQLND_UH_VERSION_ID' => 'Plugin version number, for example, 10000.',
'OAUTH_AUTH_TYPE_AUTHORIZATION' => 'This constant represents putting OAuth parameters in the `Authorization` header.',
'OAUTH_AUTH_TYPE_FORM' => 'This constant represents putting OAuth parameters as part of the HTTP POST body.',
'OAUTH_AUTH_TYPE_NONE' => 'This constant indicates a NoAuth OAuth request.',
'OAUTH_AUTH_TYPE_URI' => 'This constant represents putting OAuth parameters in the request URI.',
'OAUTH_BAD_NONCE' => 'The *oauth_nonce* value was used in a previous request, therefore it cannot be used now.',
'OAUTH_BAD_TIMESTAMP' => 'The *oauth_timestamp* value was not accepted by the service provider. In this case, the response should also contain the *oauth_acceptable_timestamps* parameter.',
'OAUTH_CONSUMER_KEY_REFUSED' => 'The consumer key was refused.',
'OAUTH_CONSUMER_KEY_UNKNOWN' => 'The *oauth_consumer_key* is temporarily unacceptable to the service provider. For example, the service provider may be throttling the consumer.',
'OAUTH_HTTP_METHOD_DELETE' => 'Use the *DELETE* method for the OAuth request.',
'OAUTH_HTTP_METHOD_GET' => 'Use the *GET* method for the OAuth request.',
'OAUTH_HTTP_METHOD_HEAD' => 'Use the *HEAD* method for the OAuth request.',
'OAUTH_HTTP_METHOD_POST' => 'Use the *POST* method for the OAuth request.',
'OAUTH_HTTP_METHOD_PUT' => 'Use the *PUT* method for the OAuth request.',
'OAUTH_INVALID_SIGNATURE' => 'The *oauth_signature* is invalid, as it does not match the signature computed by the service provider.',
'OAUTH_OK' => 'Life is good.',
'OAUTH_PARAMETER_ABSENT' => 'A required parameter was not received. In this case, the response should also contain the *oauth_parameters_absent* parameter.',
'OAUTH_REQENGINE_CURL' => 'Used by `OAuth::setRequestEngine` to set the engine to Curl, as opposed to `OAUTH_REQENGINE_STREAMS` for PHP streams.',
'OAUTH_REQENGINE_STREAMS' => 'Used by `OAuth::setRequestEngine` to set the engine to PHP streams, as opposed to `OAUTH_REQENGINE_CURL` for Curl.',
'OAUTH_SIG_METHOD_HMACSHA1' => 'OAuth *HMAC-SHA1* signature method.',
'OAUTH_SIG_METHOD_HMACSHA256' => 'OAuth *HMAC-SHA256* signature method.',
'OAUTH_SIG_METHOD_RSASHA1' => 'OAuth *RSA-SHA1* signature method.',
'OAUTH_SIGNATURE_METHOD_REJECTED' => 'The *oauth_signature_method* was not accepted by service provider.',
'OAUTH_TOKEN_EXPIRED' => 'The *oauth_token* has expired.',
'OAUTH_TOKEN_REJECTED' => 'The *oauth_token* was not accepted by the service provider. The reason is not known, but it might be because the token was never issued, already consumed, expired, and/or forgotten by the service provider.',
'OAUTH_TOKEN_REVOKED' => 'The *oauth_token* has been revoked, and will never be accepted.',
'OAUTH_TOKEN_USED' => 'The *oauth_token* has been consumed. It can no longer be used because it has already been used in the previous request(s).',
'OAUTH_VERIFIER_INVALID' => 'The *oauth_verifier* is incorrect.',
'OP_ANONYMOUS' => 'Don\'t use or update a .newsrc for news (NNTP only)',
'OP_HALFOPEN' => 'For IMAP and NNTP names, open a connection but don\'t open a mailbox.',
'OP_READONLY' => 'Open mailbox read-only',
'OPENSSL_ALGO_MD2' => 'As of PHP 5.2.13 and PHP 5.3.2, this constant is only available if PHP is compiled with MD2 support. This requires passing in the -DHAVE_OPENSSL_MD2_H CFLAG when compiling PHP, and enable-md2 when compiling OpenSSL 1.0.0+.',
'OPENSSL_ALGO_RMD160' => 'Added in PHP 5.4.8.',
'OPENSSL_ALGO_SHA1' => 'Used as default algorithm by `openssl_sign` and `openssl_verify`.',
'OPENSSL_ALGO_SHA224' => 'Added in PHP 5.4.8.',
'OPENSSL_ALGO_SHA256' => 'Added in PHP 5.4.8.',
'OPENSSL_ALGO_SHA384' => 'Added in PHP 5.4.8.',
'OPENSSL_ALGO_SHA512' => 'Added in PHP 5.4.8.',
'OPENSSL_CIPHER_AES_128_CBC' => 'Added in PHP 5.4.0.',
'OPENSSL_CIPHER_AES_192_CBC' => 'Added in PHP 5.4.0.',
'OPENSSL_CIPHER_AES_256_CBC' => 'Added in PHP 5.4.0.',
'OPENSSL_KEYTYPE_EC' => 'This constant is only available when PHP is compiled with OpenSSL 0.9.8+.',
'OPENSSL_TLSEXT_SERVER_NAME' => 'Whether SNI support is available or not.',
'OPENSSL_VERSION_NUMBER' => 'Added in PHP 5.2.0.',
'OPENSSL_VERSION_TEXT' => 'Added in PHP 5.2.0.',
'parallel\Channel::Infinite' => 'Constant for Infinitely Buffered',
'parallel\Events\Event\Type::Cancel' => 'Event::$object (Future) was cancelled',
'parallel\Events\Event\Type::Close' => 'Event::$object (Channel) was closed',
'parallel\Events\Event\Type::Error' => 'Event::$object (Future) raised error',
'parallel\Events\Event\Type::Kill' => 'Runtime executing Event::$object (Future) was killed',
'parallel\Events\Event\Type::Read' => 'Event::$object was read into Event::$value',
'parallel\Events\Event\Type::Write' => 'Input for Event::$source written to Event::$object',
'Parle\INTERNAL_UTF32' => 'Flag whether the internal UTF-32 support is compiled in. Available since parle 0.7.2.',
'Parle\Token::EOI' => 'End of input token id.',
'Parle\Token::SKIP' => 'Skip token id.',
'Parle\Token::UNKNOWN' => 'Unknown token id.',
'PARSEKIT_EXTENDED_VALUE' => 'Opnode Flag',
'PARSEKIT_IS_CONST' => 'Node Type',
'PARSEKIT_IS_TMP_VAR' => 'Node Type',
'PARSEKIT_IS_UNUSED' => 'Node Type',
'PARSEKIT_IS_VAR' => 'Node Type',
'PARSEKIT_QUIET' => 'Return full detail, but without unnecessary NULL entries.',
'PARSEKIT_RESULT_CONST' => 'Opnode Flag',
'PARSEKIT_RESULT_EA_TYPE' => 'Opnode Flag',
'PARSEKIT_RESULT_JMP_ADDR' => 'Opnode Flag',
'PARSEKIT_RESULT_OPARRAY' => 'Opnode Flag',
'PARSEKIT_RESULT_OPLINE' => 'Opnode Flag',
'PARSEKIT_RESULT_VAR' => 'Opnode Flag',
'PARSEKIT_SIMPLE' => 'Return shorthand opcode notation.',
'PARSEKIT_USAGE_UNKNOWN' => 'Opnode Flag',
'PARSEKIT_ZEND_ADD' => 'Opcode',
'PARSEKIT_ZEND_ADD_ARRAY_ELEMENT' => 'Opcode',
'PARSEKIT_ZEND_ADD_CHAR' => 'Opcode',
'PARSEKIT_ZEND_ADD_INTERFACE' => 'Opcode',
'PARSEKIT_ZEND_ADD_STRING' => 'Opcode',
'PARSEKIT_ZEND_ADD_VAR' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_ADD' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_BW_AND' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_BW_OR' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_BW_XOR' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_CONCAT' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_DIM' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_DIV' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_MOD' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_MUL' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_OBJ' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_REF' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_SL' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_SR' => 'Opcode',
'PARSEKIT_ZEND_ASSIGN_SUB' => 'Opcode',
'PARSEKIT_ZEND_BEGIN_SILENCE' => 'Opcode',
'PARSEKIT_ZEND_BOOL' => 'Opcode',
'PARSEKIT_ZEND_BOOL_NOT' => 'Opcode',
'PARSEKIT_ZEND_BOOL_XOR' => 'Opcode',
'PARSEKIT_ZEND_BRK' => 'Opcode',
'PARSEKIT_ZEND_BW_AND' => 'Opcode',
'PARSEKIT_ZEND_BW_NOT' => 'Opcode',
'PARSEKIT_ZEND_BW_OR' => 'Opcode',
'PARSEKIT_ZEND_BW_XOR' => 'Opcode',
'PARSEKIT_ZEND_CASE' => 'Opcode',
'PARSEKIT_ZEND_CAST' => 'Opcode',
'PARSEKIT_ZEND_CATCH' => 'Opcode',
'PARSEKIT_ZEND_CLONE' => 'Opcode',
'PARSEKIT_ZEND_CONCAT' => 'Opcode',
'PARSEKIT_ZEND_CONT' => 'Opcode',
'PARSEKIT_ZEND_DECLARE_CLASS' => 'Opcode',
'PARSEKIT_ZEND_DECLARE_FUNCTION' => 'Opcode',
'PARSEKIT_ZEND_DECLARE_INHERITED_CLASS' => 'Opcode',
'PARSEKIT_ZEND_DIV' => 'Opcode',
'PARSEKIT_ZEND_DO_FCALL' => 'Opcode',
'PARSEKIT_ZEND_DO_FCALL_BY_NAME' => 'Opcode',
'PARSEKIT_ZEND_ECHO' => 'Opcode',
'PARSEKIT_ZEND_END_SILENCE' => 'Opcode',
'PARSEKIT_ZEND_EVAL_CODE' => 'Function Type',
'PARSEKIT_ZEND_EXIT' => 'Opcode',
'PARSEKIT_ZEND_EXT_FCALL_BEGIN' => 'Opcode',
'PARSEKIT_ZEND_EXT_FCALL_END' => 'Opcode',
'PARSEKIT_ZEND_EXT_NOP' => 'Opcode',
'PARSEKIT_ZEND_EXT_STMT' => 'Opcode',
'PARSEKIT_ZEND_FE_FETCH' => 'Opcode',
'PARSEKIT_ZEND_FE_RESET' => 'Opcode',
'PARSEKIT_ZEND_FETCH_CLASS' => 'Opcode',
'PARSEKIT_ZEND_FETCH_CONSTANT' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_FUNC_ARG' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_IS' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_R' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_RW' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_TMP_VAR' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_UNSET' => 'Opcode',
'PARSEKIT_ZEND_FETCH_DIM_W' => 'Opcode',
'PARSEKIT_ZEND_FETCH_FUNC_ARG' => 'Opcode',
'PARSEKIT_ZEND_FETCH_IS' => 'Opcode',
'PARSEKIT_ZEND_FETCH_OBJ_FUNC_ARG' => 'Opcode',
'PARSEKIT_ZEND_FETCH_OBJ_IS' => 'Opcode',
'PARSEKIT_ZEND_FETCH_OBJ_R' => 'Opcode',
'PARSEKIT_ZEND_FETCH_OBJ_RW' => 'Opcode',
'PARSEKIT_ZEND_FETCH_OBJ_UNSET' => 'Opcode',
'PARSEKIT_ZEND_FETCH_OBJ_W' => 'Opcode',
'PARSEKIT_ZEND_FETCH_R' => 'Opcode',
'PARSEKIT_ZEND_FETCH_RW' => 'Opcode',
'PARSEKIT_ZEND_FETCH_UNSET' => 'Opcode',
'PARSEKIT_ZEND_FETCH_W' => 'Opcode',
'PARSEKIT_ZEND_FREE' => 'Opcode',
'PARSEKIT_ZEND_HANDLE_EXCEPTION' => 'Opcode',
'PARSEKIT_ZEND_IMPORT_CLASS' => 'Opcode',
'PARSEKIT_ZEND_IMPORT_CONST' => 'Opcode',
'PARSEKIT_ZEND_IMPORT_FUNCTION' => 'Opcode',
'PARSEKIT_ZEND_INCLUDE_OR_EVAL' => 'Opcode',
'PARSEKIT_ZEND_INIT_ARRAY' => 'Opcode',
'PARSEKIT_ZEND_INIT_CTOR_CALL' => 'Opcode',
'PARSEKIT_ZEND_INIT_FCALL_BY_NAME' => 'Opcode',
'PARSEKIT_ZEND_INIT_METHOD_CALL' => 'Opcode',
'PARSEKIT_ZEND_INIT_STATIC_METHOD_CALL' => 'Opcode',
'PARSEKIT_ZEND_INIT_STRING' => 'Opcode',
'PARSEKIT_ZEND_INSTANCEOF' => 'Opcode',
'PARSEKIT_ZEND_INTERNAL_CLASS' => 'Class Type',
'PARSEKIT_ZEND_INTERNAL_FUNCTION' => 'Function Type',
'PARSEKIT_ZEND_IS_EQUAL' => 'Opcode',
'PARSEKIT_ZEND_IS_IDENTICAL' => 'Opcode',
'PARSEKIT_ZEND_IS_NOT_EQUAL' => 'Opcode',
'PARSEKIT_ZEND_IS_NOT_IDENTICAL' => 'Opcode',
'PARSEKIT_ZEND_IS_SMALLER' => 'Opcode',
'PARSEKIT_ZEND_IS_SMALLER_OR_EQUAL' => 'Opcode',
'PARSEKIT_ZEND_ISSET_ISEMPTY' => 'Opcode',
'PARSEKIT_ZEND_ISSET_ISEMPTY_DIM_OBJ' => 'Opcode',
'PARSEKIT_ZEND_ISSET_ISEMPTY_PROP_OBJ' => 'Opcode',
'PARSEKIT_ZEND_ISSET_ISEMPTY_VAR' => 'Opcode',
'PARSEKIT_ZEND_JMP' => 'Opcode',
'PARSEKIT_ZEND_JMP_NO_CTOR' => 'Opcode',
'PARSEKIT_ZEND_JMPNZ' => 'Opcode',
'PARSEKIT_ZEND_JMPNZ_EX' => 'Opcode',
'PARSEKIT_ZEND_JMPZ' => 'Opcode',
'PARSEKIT_ZEND_JMPZ_EX' => 'Opcode',
'PARSEKIT_ZEND_JMPZNZ' => 'Opcode',
'PARSEKIT_ZEND_MOD' => 'Opcode',
'PARSEKIT_ZEND_MUL' => 'Opcode',
'PARSEKIT_ZEND_NEW' => 'Opcode',
'PARSEKIT_ZEND_NOP' => 'Opcode',
'PARSEKIT_ZEND_OP_DATA' => 'Opcode',
'PARSEKIT_ZEND_OVERLOADED_FUNCTION' => 'Function Type',
'PARSEKIT_ZEND_OVERLOADED_FUNCTION_TEMPORARY' => 'Function Type',
'PARSEKIT_ZEND_POST_DEC' => 'Opcode',
'PARSEKIT_ZEND_POST_DEC_OBJ' => 'Opcode',
'PARSEKIT_ZEND_POST_INC' => 'Opcode',
'PARSEKIT_ZEND_POST_INC_OBJ' => 'Opcode',
'PARSEKIT_ZEND_PRE_DEC' => 'Opcode',
'PARSEKIT_ZEND_PRE_DEC_OBJ' => 'Opcode',
'PARSEKIT_ZEND_PRE_INC' => 'Opcode',
'PARSEKIT_ZEND_PRE_INC_OBJ' => 'Opcode',
'PARSEKIT_ZEND_PRINT' => 'Opcode',
'PARSEKIT_ZEND_QM_ASSIGN' => 'Opcode',
'PARSEKIT_ZEND_RAISE_ABSTRACT_ERROR' => 'Opcode',
'PARSEKIT_ZEND_RECV' => 'Opcode',
'PARSEKIT_ZEND_RECV_INIT' => 'Opcode',
'PARSEKIT_ZEND_RETURN' => 'Opcode',
'PARSEKIT_ZEND_SEND_REF' => 'Opcode',
'PARSEKIT_ZEND_SEND_VAL' => 'Opcode',
'PARSEKIT_ZEND_SEND_VAR' => 'Opcode',
'PARSEKIT_ZEND_SEND_VAR_NO_REF' => 'Opcode',
'PARSEKIT_ZEND_SL' => 'Opcode',
'PARSEKIT_ZEND_SR' => 'Opcode',
'PARSEKIT_ZEND_SUB' => 'Opcode',
'PARSEKIT_ZEND_SWITCH_FREE' => 'Opcode',
'PARSEKIT_ZEND_THROW' => 'Opcode',
'PARSEKIT_ZEND_TICKS' => 'Opcode',
'PARSEKIT_ZEND_UNSET_DIM_OBJ' => 'Opcode',
'PARSEKIT_ZEND_UNSET_VAR' => 'Opcode',
'PARSEKIT_ZEND_USER_CLASS' => 'Class Type',
'PARSEKIT_ZEND_USER_FUNCTION' => 'Function Type',
'PARSEKIT_ZEND_VERIFY_ABSTRACT_CLASS' => 'Opcode',
'PASSWORD_ARGON2_DEFAULT_MEMORY_COST' => 'Default amount of memory in bytes that Argon2lib will use while trying to compute a hash.

Available as of PHP 7.2.0.',
'PASSWORD_ARGON2_DEFAULT_THREADS' => 'Default number of threads that Argon2lib will use.

Available as of PHP 7.2.0.',
'PASSWORD_ARGON2_DEFAULT_TIME_COST' => 'Default amount of time that Argon2lib will spend trying to compute a hash.

Available as of PHP 7.2.0.',
'PASSWORD_ARGON2I' => '`PASSWORD_ARGON2I` is used to create new password hashes using the Argon2i algorithm.

Supported Options:

`memory_cost` (`integer`) - Maximum memory (in bytes) that may be used to compute the Argon2 hash. Defaults to `PASSWORD_ARGON2_DEFAULT_MEMORY_COST`. `time_cost` (`integer`) - Maximum amount of time it may take to compute the Argon2 hash. Defaults to `PASSWORD_ARGON2_DEFAULT_TIME_COST`. `threads` (`integer`) - Number of threads to use for computing the Argon2 hash. Defaults to `PASSWORD_ARGON2_DEFAULT_THREADS`.

Available as of PHP 7.2.0.',
'PASSWORD_ARGON2ID' => '`PASSWORD_ARGON2ID` is used to create new password hashes using the Argon2id algorithm. It supports the same options as `PASSWORD_ARGON2I`.

Available as of PHP 7.3.0.',
'PASSWORD_BCRYPT' => '`PASSWORD_BCRYPT` is used to create new password hashes using the `CRYPT_BLOWFISH` algorithm.

This will always result in a hash using the "$2y$" crypt format, which is always 60 characters wide.

Supported Options:

`salt` (`string`) - to manually provide a salt to use when hashing the password. Note that this will override and prevent a salt from being automatically generated. If omitted, a random salt will be generated by `password_hash` for each password hashed. This is the intended mode of operation and as of PHP 7.0.0 the salt option has been deprecated. `cost` (`integer`) - which denotes the algorithmic cost that should be used. Examples of these values can be found on the `crypt` page. If omitted, a default value of `10` will be used. This is a good baseline cost, but you may want to consider increasing it depending on your hardware.',
'PASSWORD_DEFAULT' => 'The default algorithm to use for hashing if no algorithm is provided. This may change in newer PHP releases when newer, stronger hashing algorithms are supported.

It is worth noting that over time this constant can (and likely will) change. Therefore you should be aware that the length of the resulting hash can change. Therefore, if you use `PASSWORD_DEFAULT` you should store the resulting hash in a way that can store more than 60 characters (255 is the recommended width).

Values for this constant:

PHP 5.5.0 - `PASSWORD_BCRYPT`',
'PATH_SEPARATOR' => 'Semicolon on Windows, colon otherwise.',
'PATHINFO_FILENAME' => 'Since PHP 5.2.0.',
'PDO::ATTR_AUTOCOMMIT' => 'If this value is `false`, PDO attempts to disable autocommit so that the connection begins a transaction.',
'PDO::ATTR_CASE' => 'Force column names to a specific case specified by the `PDO::CASE_*` constants.',
'PDO::ATTR_CLIENT_VERSION' => 'This is a read only attribute; it will return information about the version of the client libraries that the PDO driver is using.',
'PDO::ATTR_CURSOR' => 'Selects the cursor type. PDO currently supports either `PDO::CURSOR_FWDONLY` and `PDO::CURSOR_SCROLL`. Stick with `PDO::CURSOR_FWDONLY` unless you know that you need a scrollable cursor.',
'PDO::ATTR_CURSOR_NAME' => 'Get or set the name to use for a cursor. Most useful when using scrollable cursors and positioned updates.',
'PDO::ATTR_DEFAULT_FETCH_MODE' => 'Available since PHP 5.2.0',
'PDO::ATTR_DEFAULT_STR_PARAM' => 'Sets the default string parameter type, this can be one of `PDO::PARAM_STR_NATL` and `PDO::PARAM_STR_CHAR`.

Available since PHP 7.2.0.',
'PDO::ATTR_DRIVER_NAME' => 'Returns the name of the driver.',
'PDO::ATTR_EMULATE_PREPARES' => 'Available since PHP 5.1.3.',
'PDO::ATTR_ERRMODE' => 'See the Errors and error handling section for more information about this attribute.',
'PDO::ATTR_FETCH_CATALOG_NAMES' => 'Prepend the containing catalog name to each column name returned in the result set. The catalog name and column name are separated by a decimal (.) character. Support of this attribute is at the driver level; it may not be supported by your driver.',
'PDO::ATTR_FETCH_TABLE_NAMES' => 'Prepend the containing table name to each column name returned in the result set. The table name and column name are separated by a decimal (.) character. Support of this attribute is at the driver level; it may not be supported by your driver.',
'PDO::ATTR_MAX_COLUMN_LEN' => 'Sets the maximum column name length.',
'PDO::ATTR_ORACLE_NULLS' => 'Convert empty strings to SQL NULL values on data fetches.',
'PDO::ATTR_PERSISTENT' => 'Request a persistent connection, rather than creating a new connection. See Connections and Connection management for more information on this attribute.',
'PDO::ATTR_PREFETCH' => 'Setting the prefetch size allows you to balance speed against memory usage for your application. Not all database/driver combinations support setting of the prefetch size. A larger prefetch size results in increased performance at the cost of higher memory usage.',
'PDO::ATTR_SERVER_INFO' => 'This is a read only attribute; it will return some meta information about the database server to which PDO is connected.',
'PDO::ATTR_SERVER_VERSION' => 'This is a read only attribute; it will return information about the version of the database server to which PDO is connected.',
'PDO::ATTR_STATEMENT_CLASS' => 'Sets the class name of which statements are returned as.',
'PDO::ATTR_STRINGIFY_FETCHES' => 'Forces all values fetched to be treated as strings.',
'PDO::ATTR_TIMEOUT' => 'Sets the timeout value in seconds for communications with the database.',
'PDO::CASE_LOWER' => 'Force column names to lower case.',
'PDO::CASE_NATURAL' => 'Leave column names as returned by the database driver.',
'PDO::CASE_UPPER' => 'Force column names to upper case.',
'PDO::CURSOR_FWDONLY' => 'Create a `PDOStatement` object with a forward-only cursor. This is the default cursor choice, as it is the fastest and most common data access pattern in PHP.',
'PDO::CURSOR_SCROLL' => 'Create a `PDOStatement` object with a scrollable cursor. Pass the `PDO::FETCH_ORI_*` constants to control the rows fetched from the result set.',
'PDO::ERR_NONE' => 'Corresponds to SQLSTATE \'00000\', meaning that the SQL statement was successfully issued with no errors or warnings. This constant is for your convenience when checking `PDO::errorCode` or `PDOStatement::errorCode` to determine if an error occurred. You will usually know if this is the case by examining the return code from the method that raised the error condition anyway.',
'PDO::ERRMODE_EXCEPTION' => 'Throw a `PDOException` if an error occurs. See Errors and error handling for more information about this attribute.',
'PDO::ERRMODE_SILENT' => 'Do not raise an error or exception if an error occurs. The developer is expected to explicitly check for errors. This is the default mode. See Errors and error handling for more information about this attribute.',
'PDO::ERRMODE_WARNING' => 'Issue a PHP `E_WARNING` message if an error occurs. See Errors and error handling for more information about this attribute.',
'PDO::FB_ATTR_DATE_FORMAT' => 'Sets the date format.',
'PDO::FB_ATTR_TIME_FORMAT' => 'Sets the time format.',
'PDO::FB_ATTR_TIMESTAMP_FORMAT' => 'Sets the timestamp format.',
'PDO::FETCH_ASSOC' => 'Specifies that the fetch method shall return each row as an array indexed by column name as returned in the corresponding result set. If the result set contains multiple columns with the same name, `PDO::FETCH_ASSOC` returns only a single value per column name.',
'PDO::FETCH_BOTH' => 'Specifies that the fetch method shall return each row as an array indexed by both column name and number as returned in the corresponding result set, starting at column 0.',
'PDO::FETCH_BOUND' => 'Specifies that the fetch method shall return TRUE and assign the values of the columns in the result set to the PHP variables to which they were bound with the `PDOStatement::bindParam` or `PDOStatement::bindColumn` methods.',
'PDO::FETCH_CLASS' => 'Specifies that the fetch method shall return a new instance of the requested class, mapping the columns to named properties in the class.',
'PDO::FETCH_CLASSTYPE' => 'Determine the class name from the value of first column.',
'PDO::FETCH_COLUMN' => 'Specifies that the fetch method shall return only a single requested column from the next row in the result set.',
'PDO::FETCH_FUNC' => 'Allows completely customize the way data is treated on the fly (only valid inside `PDOStatement::fetchAll`).',
'PDO::FETCH_GROUP' => 'Group return by values. Usually combined with `PDO::FETCH_COLUMN` or `PDO::FETCH_KEY_PAIR`.',
'PDO::FETCH_INTO' => 'Specifies that the fetch method shall update an existing instance of the requested class, mapping the columns to named properties in the class.',
'PDO::FETCH_KEY_PAIR' => 'Fetch a two-column result into an array where the first column is a key and the second column is the value.',
'PDO::FETCH_LAZY' => 'Specifies that the fetch method shall return each row as an object with variable names that correspond to the column names returned in the result set. `PDO::FETCH_LAZY` creates the object variable names as they are accessed. Not valid inside `PDOStatement::fetchAll`.',
'PDO::FETCH_NAMED' => 'Specifies that the fetch method shall return each row as an array indexed by column name as returned in the corresponding result set. If the result set contains multiple columns with the same name, `PDO::FETCH_NAMED` returns an array of values per column name.',
'PDO::FETCH_NUM' => 'Specifies that the fetch method shall return each row as an array indexed by column number as returned in the corresponding result set, starting at column 0.',
'PDO::FETCH_OBJ' => 'Specifies that the fetch method shall return each row as an object with property names that correspond to the column names returned in the result set.',
'PDO::FETCH_ORI_ABS' => 'Fetch the requested row by row number from the result set. Valid only for scrollable cursors.',
'PDO::FETCH_ORI_FIRST' => 'Fetch the first row in the result set. Valid only for scrollable cursors.',
'PDO::FETCH_ORI_LAST' => 'Fetch the last row in the result set. Valid only for scrollable cursors.',
'PDO::FETCH_ORI_NEXT' => 'Fetch the next row in the result set. Valid only for scrollable cursors.',
'PDO::FETCH_ORI_PRIOR' => 'Fetch the previous row in the result set. Valid only for scrollable cursors.',
'PDO::FETCH_ORI_REL' => 'Fetch the requested row by relative position from the current position of the cursor in the result set. Valid only for scrollable cursors.',
'PDO::FETCH_PROPS_LATE' => 'Call the constructor before setting properties.',
'PDO::FETCH_SERIALIZE' => 'As `PDO::FETCH_INTO` but object is provided as a serialized string.',
'PDO::FETCH_UNIQUE' => 'Fetch only the unique values.',
'PDO::MYSQL_ATTR_COMPRESS' => 'Enable network communication compression. This is also supported when compiled against mysqlnd as of PHP 5.3.11.',
'PDO::MYSQL_ATTR_DIRECT_QUERY' => 'Perform direct queries, don\'t use prepared statements.',
'PDO::MYSQL_ATTR_FOUND_ROWS' => 'Return the number of found (matched) rows, not the number of changed rows.',
'PDO::MYSQL_ATTR_IGNORE_SPACE' => 'Permit spaces after function names. Makes all functions names reserved words.',
'PDO::MYSQL_ATTR_INIT_COMMAND' => 'Command to execute when connecting to the MySQL server. Will automatically be re-executed when reconnecting.

Note, this constant can only be used in the driver_options array when constructing a new database handle.',
'PDO::MYSQL_ATTR_LOCAL_INFILE' => 'Enable `LOAD LOCAL INFILE`.

Note, this constant can only be used in the driver_options array when constructing a new database handle.',
'PDO::MYSQL_ATTR_MAX_BUFFER_SIZE' => 'Maximum buffer size. Defaults to 1 MiB. This constant is not supported when compiled against mysqlnd.',
'PDO::MYSQL_ATTR_MULTI_STATEMENTS' => 'Disables multi query execution in both `PDO::prepare` and `PDO::query` when set to `false`.

Note, this constant can only be used in the driver_options array when constructing a new database handle.

`version.exists.asof` 5.5.21 and PHP 5.6.5.',
'PDO::MYSQL_ATTR_READ_DEFAULT_FILE' => 'Read options from the named option file instead of from my.cnf. This option is not available if mysqlnd is used, because mysqlnd does not read the mysql configuration files.',
'PDO::MYSQL_ATTR_READ_DEFAULT_GROUP' => 'Read options from the named group from my.cnf or the file specified with `MYSQL_READ_DEFAULT_FILE`. This option is not available if mysqlnd is used, because mysqlnd does not read the mysql configuration files.',
'PDO::MYSQL_ATTR_SSL_CA' => 'The file path to the SSL certificate authority.

`version.exists.asof` 5.3.7.',
'PDO::MYSQL_ATTR_SSL_CAPATH' => 'The file path to the directory that contains the trusted SSL CA certificates, which are stored in PEM format.

`version.exists.asof` 5.3.7.',
'PDO::MYSQL_ATTR_SSL_CERT' => 'The file path to the SSL certificate.

`version.exists.asof` 5.3.7.',
'PDO::MYSQL_ATTR_SSL_CIPHER' => 'A list of one or more permissible ciphers to use for SSL encryption, in a format understood by OpenSSL. For example: `DHE-RSA-AES256-SHA:AES128-SHA`

`version.exists.asof` 5.3.7.',
'PDO::MYSQL_ATTR_SSL_KEY' => 'The file path to the SSL key.

`version.exists.asof` 5.3.7.',
'PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT' => 'Provides a way to disable verification of the server SSL certificate.

`version.exists.asof` 7.0.18 and PHP 7.1.4.',
'PDO::MYSQL_ATTR_USE_BUFFERED_QUERY' => 'If this attribute is set to `true` on a `PDOStatement`, the MySQL driver will use the buffered versions of the MySQL API. If you\'re writing portable code, you should use `PDOStatement::fetchAll` instead.',
'PDO::OCI_ATTR_ACTION' => 'Provides a way to specify the action on the database session.

`version.exists.asof` 7.2.16 and 7.3.3',
'PDO::OCI_ATTR_CLIENT_IDENTIFIER' => 'Provides a way to specify the client identifier on the database session.

`version.exists.asof` 7.2.16 and 7.3.3',
'PDO::OCI_ATTR_CLIENT_INFO' => 'Provides a way to specify the client info on the database session.

`version.exists.asof` 7.2.16 and 7.3.3',
'PDO::OCI_ATTR_MODULE' => 'Provides a way to specify the module on the database session.

`version.exists.asof` 7.2.16 and 7.3.3',
'PDO::PARAM_BOOL' => 'Represents a boolean data type.',
'PDO::PARAM_EVT_ALLOC' => 'Allocation event',
'PDO::PARAM_EVT_EXEC_POST' => 'Event triggered subsequent to execution of a prepared statement.',
'PDO::PARAM_EVT_EXEC_PRE' => 'Event triggered prior to execution of a prepared statement.',
'PDO::PARAM_EVT_FETCH_POST' => 'Event triggered subsequent to fetching a result from a resultset.',
'PDO::PARAM_EVT_FETCH_PRE' => 'Event triggered prior to fetching a result from a resultset.',
'PDO::PARAM_EVT_FREE' => 'Deallocation event',
'PDO::PARAM_EVT_NORMALIZE' => 'Event triggered during bound parameter registration allowing the driver to normalize the parameter name.',
'PDO::PARAM_INPUT_OUTPUT' => 'Specifies that the parameter is an INOUT parameter for a stored procedure. You must bitwise-OR this value with an explicit PDO::PARAM_* data type.',
'PDO::PARAM_INT' => 'Represents the SQL INTEGER data type.',
'PDO::PARAM_LOB' => 'Represents the SQL large object data type.',
'PDO::PARAM_NULL' => 'Represents the SQL NULL data type.',
'PDO::PARAM_STMT' => 'Represents a recordset type. Not currently supported by any drivers.',
'PDO::PARAM_STR' => 'Represents the SQL CHAR, VARCHAR, or other string data type.',
'PDO::PARAM_STR_CHAR' => 'Flag to denote a string uses the regular character set.

Available since PHP 7.2.0',
'PDO::PARAM_STR_NATL' => 'Flag to denote a string uses the national character set.

Available since PHP 7.2.0',
'PDO::SQLITE_DETERMINISTIC' => 'Specifies that a function created with `PDO::sqliteCreateFunction` is deterministic, i.e. it always returns the same result given the same inputs within a single SQL statement. (Available as of PHP 7.1.4.)',
'PDO::SQLSRV_ATTR_DIRECT_QUERY' => 'Indicates that a query should be executed directly, without being prepared. This constant can be passed to PDO::setAttribute, and PDO::prepare. For more information, see Direct and Prepared Statement Execution.',
'PDO::SQLSRV_ATTR_QUERY_TIMEOUT' => 'A non-negative integer representing the timeout period, in seconds. Zero (0) is the default and means no timeout. This constant can be passed to PDOStatement::setAttribute, PDO::setAttribute, and PDO::prepare.',
'PDO::SQLSRV_ENCODING_BINARY' => 'Specifies that data is sent/retrieved as a raw byte stream to/from the server without performing encoding or translation. This constant can be passed to PDOStatement::setAttribute, PDO::prepare, PDOStatement::bindColumn, and PDOStatement::bindParam.',
'PDO::SQLSRV_ENCODING_DEFAULT' => 'Specifies that data is sent/retrieved to/from the server according to PDO::SQLSRV_ENCODING_SYSTEM if specified during connection. The connection\'s encoding is used if specified in a prepare statement. This constant can be passed to PDOStatement::setAttribute, PDO::setAttribute, PDO::prepare, PDOStatement::bindColumn, and PDOStatement::bindParam.',
'PDO::SQLSRV_ENCODING_SYSTEM' => 'Specifies that data is sent/retrieved to/from the server as 8-bit characters as specified in the code page of the Windows locale that is set on the system. Any multi-byte characters or characters that do not map into this code page are substituted with a single byte question mark (?) character. This constant can be passed to PDOStatement::setAttribute, PDO::setAttribute, PDO::prepare, PDOStatement::bindColumn, and PDOStatement::bindParam.',
'PDO::SQLSRV_ENCODING_UTF8' => 'Specifies that data is sent/retrieved to/from the server in UTF-8 encoding. This is the default encoding. This constant can be passed to PDOStatement::setAttribute, PDO::setAttribute, PDO::prepare, PDOStatement::bindColumn, and PDOStatement::bindParam.',
'PDO::SQLSRV_TXN_READ_COMMITTED' => 'This constant is an acceptable value for the SQLSRV DSN key TransactionIsolation. This constant sets the transaction isolation level for the connection to Read Committed.',
'PDO::SQLSRV_TXN_READ_UNCOMMITTED' => 'This constant is an acceptable value for the SQLSRV DSN key TransactionIsolation. This constant sets the transaction isolation level for the connection to Read Uncommitted.',
'PDO::SQLSRV_TXN_REPEATABLE_READ' => 'This constant is an acceptable value for the SQLSRV DSN key TransactionIsolation. This constant sets the transaction isolation level for the connection to Repeateable Read.',
'PDO::SQLSRV_TXN_SERIALIZABLE' => 'This constant is an acceptable value for the SQLSRV DSN key TransactionIsolation. This constant sets the transaction isolation level for the connection to Serializable.',
'PDO::SQLSRV_TXN_SNAPSHOT' => 'This constant is an acceptable value for the SQLSRV DSN key TransactionIsolation. This constant sets the transaction isolation level for the connection to Snapshot.',
'PGSQL_ASSOC' => 'Passed to `pg_fetch_array`. Return an associative array of field names and values.',
'PGSQL_BAD_RESPONSE' => 'Returned by `pg_result_status`. The server\'s response was not understood.',
'PGSQL_BOTH' => 'Passed to `pg_fetch_array`. Return an array of field values that is both numerically indexed (by field number) and associated (by field name).',
'PGSQL_COMMAND_OK' => 'Returned by `pg_result_status`. Successful completion of a command returning no data.',
'PGSQL_CONNECT_ASYNC' => 'Passed to `pg_connect` to create an asynchronous connection. Added in PHP 5.6.0.',
'PGSQL_CONNECT_FORCE_NEW' => 'Passed to `pg_connect` to force the creation of a new connection, rather than re-using an existing identical connection.',
'PGSQL_CONNECTION_BAD' => 'Returned by `pg_connection_status` indicating that the database connection is in an invalid state.',
'PGSQL_CONNECTION_OK' => 'Returned by `pg_connection_status` indicating that the database connection is in a valid state.',
'PGSQL_CONV_FORCE_NULL' => 'Passed to `pg_convert`. Use SQL `NULL` in place of an empty `string`.',
'PGSQL_CONV_IGNORE_DEFAULT' => 'Passed to `pg_convert`. Ignore default values in the table during conversion.',
'PGSQL_CONV_IGNORE_NOT_NULL' => 'Passed to `pg_convert`. Ignore conversion of `null` into SQL `NOT NULL` columns.',
'PGSQL_COPY_IN' => 'Returned by `pg_result_status`. Copy In (to server) data transfer started.',
'PGSQL_COPY_OUT' => 'Returned by `pg_result_status`. Copy Out (from server) data transfer started.',
'PGSQL_DIAG_CONTEXT' => 'Passed to `pg_result_error_field`. An indication of the context in which the error occurred. Presently this includes a call stack traceback of active procedural language functions and internally-generated queries. The trace is one entry per line, most recent first.',
'PGSQL_DIAG_INTERNAL_POSITION' => 'Passed to `pg_result_error_field`. This is defined the same as the `PG_DIAG_STATEMENT_POSITION` field, but it is used when the cursor position refers to an internally generated command rather than the one submitted by the client. The `PG_DIAG_INTERNAL_QUERY` field will always appear when this field appears.',
'PGSQL_DIAG_INTERNAL_QUERY' => 'Passed to `pg_result_error_field`. The text of a failed internally-generated command. This could be, for example, a SQL query issued by a PL/pgSQL function.',
'PGSQL_DIAG_MESSAGE_DETAIL' => 'Passed to `pg_result_error_field`. Detail: an optional secondary error message carrying more detail about the problem. May run to multiple lines.',
'PGSQL_DIAG_MESSAGE_HINT' => 'Passed to `pg_result_error_field`. Hint: an optional suggestion what to do about the problem. This is intended to differ from detail in that it offers advice (potentially inappropriate) rather than hard facts. May run to multiple lines.',
'PGSQL_DIAG_MESSAGE_PRIMARY' => 'Passed to `pg_result_error_field`. The primary human-readable error message (typically one line). Always present.',
'PGSQL_DIAG_SEVERITY' => 'Passed to `pg_result_error_field`. The severity; the field contents are `ERROR`, `FATAL`, or `PANIC` (in an error message), or `WARNING`, `NOTICE`, `DEBUG`, `INFO`, or `LOG` (in a notice message), or a localized translation of one of these. Always present.',
'PGSQL_DIAG_SEVERITY_NONLOCALIZED' => 'The severity; the field contents are ERROR, FATAL, or PANIC (in an error message), or WARNING, NOTICE, DEBUG, INFO, or LOG (in a notice message). This is identical to the PG_DIAG_SEVERITY field except that the contents are never localized. This is present only in versions 9.6 and later.',
'PGSQL_DIAG_SOURCE_FILE' => 'Passed to `pg_result_error_field`. The file name of the PostgreSQL source-code location where the error was reported.',
'PGSQL_DIAG_SOURCE_FUNCTION' => 'Passed to `pg_result_error_field`. The name of the PostgreSQL source-code function reporting the error.',
'PGSQL_DIAG_SOURCE_LINE' => 'Passed to `pg_result_error_field`. The line number of the PostgreSQL source-code location where the error was reported.',
'PGSQL_DIAG_SQLSTATE' => 'Passed to `pg_result_error_field`. The SQLSTATE code for the error. The SQLSTATE code identifies the type of error that has occurred; it can be used by front-end applications to perform specific operations (such as error handling) in response to a particular database error. This field is not localizable, and is always present.',
'PGSQL_DIAG_STATEMENT_POSITION' => 'Passed to `pg_result_error_field`. A string containing a decimal integer indicating an error cursor position as an index into the original statement string. The first character has index 1, and positions are measured in characters not bytes.',
'PGSQL_DML_ASYNC' => 'Passed to `pg_insert`, `pg_select`, `pg_update` and `pg_delete`. Execute asynchronous query by these functions.',
'PGSQL_DML_ESCAPE' => 'Passed to `pg_insert`, `pg_select`, `pg_update` and `pg_delete`. Apply escape to all parameters instead of calling `pg_convert` internally. This option omits meta data look up. Query could be as fast as `pg_query` and `pg_send_query`.',
'PGSQL_DML_EXEC' => 'Passed to `pg_insert`, `pg_select`, `pg_update` and `pg_delete`. Execute query by these functions.',
'PGSQL_DML_NO_CONV' => 'Passed to `pg_insert`, `pg_select`, `pg_update` and `pg_delete`. All parameters passed as is. Manual escape is required if parameters contain user supplied data. Use `pg_escape_string` for it.',
'PGSQL_DML_STRING' => 'Passed to `pg_insert`, `pg_select`, `pg_update` and `pg_delete`. Return executed query string.',
'PGSQL_EMPTY_QUERY' => 'Returned by `pg_result_status`. The string sent to the server was empty.',
'PGSQL_ERRORS_DEFAULT' => 'Passed to `pg_set_error_verbosity`. The default mode produces messages that include the above plus any detail, hint, or context fields (these may span multiple lines).',
'PGSQL_ERRORS_TERSE' => 'Passed to `pg_set_error_verbosity`. Specified that returned messages include severity, primary text, and position only; this will normally fit on a single line.',
'PGSQL_ERRORS_VERBOSE' => 'Passed to `pg_set_error_verbosity`. The verbose mode includes all available fields.',
'PGSQL_FATAL_ERROR' => 'Returned by `pg_result_status`. A fatal error occurred.',
'PGSQL_LIBPQ_VERSION' => 'Short libpq version that contains only numbers and dots.',
'PGSQL_LIBPQ_VERSION_STR' => 'Long libpq version that includes compiler information.',
'PGSQL_NONFATAL_ERROR' => 'Returned by `pg_result_status`. A nonfatal error (a notice or warning) occurred.',
'PGSQL_NOTICE_ALL' => 'Used by `pg_last_notice`. Available since PHP 7.1.0.',
'PGSQL_NOTICE_CLEAR' => 'Used by `pg_last_notice`. Available since PHP 7.1.0.',
'PGSQL_NOTICE_LAST' => 'Used by `pg_last_notice`. Available since PHP 7.1.0.',
'PGSQL_NUM' => 'Passed to `pg_fetch_array`. Return a numerically indexed array of field numbers and values.',
'PGSQL_POLLING_ACTIVE' => 'Returned by `pg_connect_poll` to indicate that the connection is currently active.',
'PGSQL_POLLING_FAILED' => 'Returned by `pg_connect_poll` to indicate that the connection attempt failed.',
'PGSQL_POLLING_OK' => 'Returned by `pg_connect_poll` to indicate that the connection is ready to be used.',
'PGSQL_POLLING_READING' => 'Returned by `pg_connect_poll` to indicate that the connection is waiting for the PostgreSQL socket to be readable.',
'PGSQL_POLLING_WRITING' => 'Returned by `pg_connect_poll` to indicate that the connection is waiting for the PostgreSQL socket to be writable.',
'PGSQL_SEEK_CUR' => 'Passed to `pg_lo_seek`. Seek operation is to begin from the current position.',
'PGSQL_SEEK_END' => 'Passed to `pg_lo_seek`. Seek operation is to begin from the end of the object.',
'PGSQL_SEEK_SET' => 'Passed to `pg_lo_seek`. Seek operation is to begin from the start of the object.',
'PGSQL_STATUS_LONG' => 'Passed to `pg_result_status`. Indicates that numerical result code is desired.',
'PGSQL_STATUS_STRING' => 'Passed to `pg_result_status`. Indicates that textual result command tag is desired.',
'PGSQL_TRANSACTION_ACTIVE' => 'Returned by `pg_transaction_status`. A command is in progress on the connection. A query has been sent via the connection and not yet completed.',
'PGSQL_TRANSACTION_IDLE' => 'Returned by `pg_transaction_status`. Connection is currently idle, not in a transaction.',
'PGSQL_TRANSACTION_INERROR' => 'Returned by `pg_transaction_status`. The connection is idle, in a failed transaction block.',
'PGSQL_TRANSACTION_INTRANS' => 'Returned by `pg_transaction_status`. The connection is idle, in a transaction block.',
'PGSQL_TRANSACTION_UNKNOWN' => 'Returned by `pg_transaction_status`. The connection is bad.',
'PGSQL_TUPLES_OK' => 'Returned by `pg_result_status`. Successful completion of a command returning data (such as a `SELECT` or `SHOW`).',
'PHP_BINARY' => 'Specifies the PHP binary path during script execution. Available since PHP 5.4.',
'PHP_BINDIR' => 'Specifies where the binaries were installed into.',
'PHP_DEBUG' => 'Available since PHP 5.2.7.',
'PHP_EOL' => 'The correct \'End Of Line\' symbol for this platform.',
'PHP_EXTRA_VERSION' => 'The current PHP "extra" version as a string (e.g., \'-extra\' from version "5.2.7-extra"). Often used by distribution vendors to indicate a package version.',
'PHP_FD_SETSIZE' => 'The maximum number of file descriptors for select system calls. Available as of PHP 7.1.0.',
'PHP_FLOAT_DIG' => 'Number of decimal digits that can be rounded into a float and back without precision loss. Available as of PHP 7.2.0.',
'PHP_FLOAT_EPSILON' => 'Smallest representable positive number x, so that `x + 1.0 != 1.0`. Available as of PHP 7.2.0.',
'PHP_FLOAT_MAX' => 'Largest representable floating point number. Available as of PHP 7.2.0.',
'PHP_FLOAT_MIN' => 'Smallest representable floating point number. Available as of PHP 7.2.0.',
'PHP_INT_MAX' => 'The largest integer supported in this build of PHP. Usually int(2147483647) in 32 bit systems and int(9223372036854775807) in 64 bit systems.',
'PHP_INT_MIN' => 'The smallest integer supported in this build of PHP. Usually int(-2147483648) in 32 bit systems and int(-9223372036854775808) in 64 bit systems. Available since PHP 7.0.0. Usually, PHP_INT_MIN === ~PHP_INT_MAX.',
'PHP_INT_SIZE' => 'The size of an integer in bytes in this build of PHP.',
'PHP_MAJOR_VERSION' => 'The current PHP "major" version as an integer (e.g., int(5) from version "5.2.7-extra").',
'PHP_MANDIR' => 'Specifies where the manpages were installed into.',
'PHP_MAXPATHLEN' => 'The maximum length of filenames (including path) supported by this build of PHP.',
'PHP_MINOR_VERSION' => 'The current PHP "minor" version as an integer (e.g., int(2) from version "5.2.7-extra").',
'PHP_OS' => 'The operating system PHP was built for.',
'PHP_OS_FAMILY' => 'The operating system family PHP was built for. Either of `\'Windows\'`, `\'BSD\'`, `\'Darwin\'`, `\'Solaris\'`, `\'Linux\'` or `\'Unknown\'`. Available as of PHP 7.2.0.',
'PHP_OUTPUT_HANDLER_CLEAN' => 'Indicates that the output buffer has been cleaned.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_CLEANABLE' => 'Controls whether an output buffer created by `ob_start` can be cleaned.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_CONT' => 'Indicates that the buffer has been flushed, but output buffering will continue.

As of PHP 5.4, this is an alias for `PHP_OUTPUT_HANDLER_WRITE`.',
'PHP_OUTPUT_HANDLER_END' => 'Indicates that output buffering has ended.

As of PHP 5.4, this is an alias for `PHP_OUTPUT_HANDLER_FINAL`.',
'PHP_OUTPUT_HANDLER_FINAL' => 'Indicates that this is the final output buffering operation.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_FLUSH' => 'Indicates that the buffer has been flushed.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_FLUSHABLE' => 'Controls whether an output buffer created by `ob_start` can be flushed.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_REMOVABLE' => 'Controls whether an output buffer created by `ob_start` can be removed before the end of the script.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_START' => 'Indicates that output buffering has begun.',
'PHP_OUTPUT_HANDLER_STDFLAGS' => 'The default set of output buffer flags; currently equivalent to `PHP_OUTPUT_HANDLER_CLEANABLE` | `PHP_OUTPUT_HANDLER_FLUSHABLE` | `PHP_OUTPUT_HANDLER_REMOVABLE`.

Available since PHP 5.4.',
'PHP_OUTPUT_HANDLER_WRITE' => 'Indicates that the output buffer is being flushed, and had data to output.

Available since PHP 5.4.',
'PHP_PREFIX' => 'The value "--prefix" was set to at configure.',
'PHP_QUERY_RFC1738' => 'Encoding is performed per RFC 1738 and the `application/x-www-form-urlencoded` media type, which implies that spaces are encoded as plus (`+`) signs.',
'PHP_QUERY_RFC3986' => 'Encoding is performed according to RFC 3986, and spaces will be percent encoded (`%20`).',
'PHP_RELEASE_VERSION' => 'The current PHP "release" version as an integer (e.g., int(7) from version "5.2.7-extra").',
'PHP_SAPI' => 'The Server API for this build of PHP. See also `php_sapi_name`.',
'PHP_SESSION_ACTIVE' => 'Since PHP 5.4.0. Return value of `session_status` if sessions are enabled, and a session exists.',
'PHP_SESSION_DISABLED' => 'Since PHP 5.4.0. Return value of `session_status` if sessions are disabled.',
'PHP_SESSION_NONE' => 'Since PHP 5.4.0. Return value of `session_status` if sessions are enabled, but no session exists.',
'PHP_SHLIB_SUFFIX' => 'The build-platform\'s shared library suffix, such as "so" (most Unixes) or "dll" (Windows).',
'PHP_SVN_AUTH_PARAM_IGNORE_SSL_VERIFY_ERRORS' => 'Custom property for ignoring SSL cert verification errors',
'PHP_URL_FRAGMENT' => 'Outputs the fragment (string after the hashmark #) of the URL parsed.',
'PHP_URL_HOST' => 'Outputs the hostname of the URL parsed.',
'PHP_URL_PASS' => 'Outputs the password of the URL parsed.',
'PHP_URL_PATH' => 'Outputs the path of the URL parsed.',
'PHP_URL_PORT' => 'Outputs the port of the URL parsed.',
'PHP_URL_QUERY' => 'Outputs the query string of the URL parsed.',
'PHP_URL_USER' => 'Outputs the user of the URL parsed.',
'PHP_VERSION' => 'The current PHP version as a string in "major.minor.release[extra]" notation.',
'PHP_VERSION_ID' => 'The current PHP version as an integer, useful for version comparisons (e.g., int(50207) from version "5.2.7-extra").',
'PHP_WINDOWS_EVENT_CTRL_BREAK' => 'A Windows `CTRL+BREAK` event. Available as of PHP 7.4.0 (Windows only).',
'PHP_WINDOWS_EVENT_CTRL_C' => 'A Windows `CTRL+C` event. Available as of PHP 7.4.0 (Windows only).',
'PHP_ZTS' => 'Available since PHP 5.2.7.',
'PHPDBG_FILE' => 'Removed as of PHP 7.3.0.',
'PHPDBG_FUNC' => 'Removed as of PHP 7.3.0.',
'PHPDBG_LINENO' => 'Removed as of PHP 7.3.0.',
'PHPDBG_METHOD' => 'Removed as of PHP 7.3.0.',
'POLL_ERR' => 'Available since PHP 5.3.0.',
'POLL_HUP' => 'Available since PHP 5.3.0.',
'POLL_IN' => 'Available since PHP 5.3.0.',
'POLL_MSG' => 'Available since PHP 5.3.0.',
'POLL_OUT' => 'Available since PHP 5.3.0.',
'POLL_PRI' => 'Available since PHP 5.3.0.',
'POSIX_F_OK' => 'Check whether the file exists.',
'POSIX_R_OK' => 'Check whether the file exists and has read permissions.',
'POSIX_RLIMIT_AS' => 'The maximum size of the process\'s address space in bytes. See also PHP\'s memory_limit configuration directive.',
'POSIX_RLIMIT_CORE' => 'The maximum size of a core file. If the limit is set to 0, no core file will be generated.',
'POSIX_RLIMIT_CPU' => 'The maximum amount of CPU time that the process can use, in seconds. When the soft limit is hit, a `SIGXCPU` signal will be sent, which can be caught with `pcntl_signal`. Depending on the operating system, additional `SIGXCPU` signals may be sent each second until the hard limit is hit, at which point an uncatchable `SIGKILL` signal is sent.

See also `set_time_limit`.',
'POSIX_RLIMIT_DATA' => 'The maximum size of the process\'s data segment, in bytes. It is extremely unlikely that this will have any effect on the execution of PHP unless an extension is in use that calls `brk` or `sbrk`.',
'POSIX_RLIMIT_FSIZE' => 'The maximum size of files that the process can create, in bytes.',
'POSIX_RLIMIT_INFINITY' => 'Used to indicate an infinite value for a resource limit.',
'POSIX_RLIMIT_LOCKS' => 'The maximum number of locks that the process can create. This is only supported on extremely old Linux kernels.',
'POSIX_RLIMIT_MEMLOCK' => 'The maximum number of bytes that can be locked into memory.',
'POSIX_RLIMIT_MSGQUEUE' => 'The maximum number of bytes that can be allocated for POSIX message queues. PHP does not ship with support for POSIX message queues, so this limit will not have any effect unless you are using an extension that implements that support.',
'POSIX_RLIMIT_NICE' => 'The maximum value to which the process can be reniced to. The value that will be used will be `20 - limit`, as resource limit values cannot be negative.',
'POSIX_RLIMIT_NOFILE' => 'A value one greater than the maximum file descriptor number that can be opened by this process.',
'POSIX_RLIMIT_NPROC' => 'The maximum number of processes (and/or threads, on some operating systems) that can be created for the real user ID of the process.',
'POSIX_RLIMIT_RSS' => 'The maximum size of the process\'s resident set, in pages.',
'POSIX_RLIMIT_RTPRIO' => 'The maximum real time priority that can be set via the `sched_setscheduler` and `sched_setparam` system calls.',
'POSIX_RLIMIT_RTTIME' => 'The maximum amount of CPU time, in microseconds, that the process can consume without making a blocking system call if it is using real time scheduling.',
'POSIX_RLIMIT_SIGPENDING' => 'The maximum number of signals that can be queued for the real user ID of the process.',
'POSIX_RLIMIT_STACK' => 'The maximum size of the process stack, in bytes.',
'POSIX_S_IFBLK' => 'Block special file',
'POSIX_S_IFCHR' => 'Character special file',
'POSIX_S_IFIFO' => 'FIFO (named pipe) special file',
'POSIX_S_IFREG' => 'Normal file',
'POSIX_S_IFSOCK' => 'Socket',
'POSIX_W_OK' => 'Check whether the file exists and has write permissions.',
'POSIX_X_OK' => 'Check whether the file exists and has execute permissions.',
'PTHREADS_ALLOW_HEADERS' => 'Allow new Threads to send headers to standard output (normally prohibited)',
'PTHREADS_INHERIT_ALL' => 'The default options for all Threads, causes pthreads to copy the environment when new Threads are started',
'PTHREADS_INHERIT_CLASSES' => 'Inherit user declared classes when new Threads are started',
'PTHREADS_INHERIT_COMMENTS' => 'Inherit all comments when new Threads are started',
'PTHREADS_INHERIT_CONSTANTS' => 'Inherit user declared constants when new Threads are started',
'PTHREADS_INHERIT_FUNCTIONS' => 'Inherit user declared functions when new Threads are started',
'PTHREADS_INHERIT_INCLUDES' => 'Inherit included file information when new Threads are started',
'PTHREADS_INHERIT_INI' => 'Inherit INI entries when new Threads are started',
'PTHREADS_INHERIT_NONE' => 'Do not inherit anything when new Threads are started',
'RADIUS_ACCESS_ACCEPT' => 'An Access-Accept response to an Access-Request indicating that the RADIUS server authenticated the user successfully.',
'RADIUS_ACCESS_CHALLENGE' => 'An Access-Challenge response to an Access-Request indicating that the RADIUS server requires further information in another Access-Request before authenticating the user.',
'RADIUS_ACCESS_REJECT' => 'An Access-Reject response to an Access-Request indicating that the RADIUS server could not authenticate the user.',
'RADIUS_ACCESS_REQUEST' => 'An Access-Request, used to authenticate a user against a RADIUS server. Access request packets must include a `RADIUS_NAS_IP_ADDRESS` or a `RADIUS_NAS_IDENTIFIER` attribute, must also include a `RADIUS_USER_PASSWORD`, `RADIUS_CHAP_PASSWORD` or a `RADIUS_STATE` attribute, and should include a `RADIUS_USER_NAME` attribute.',
'RADIUS_ACCOUNTING_REQUEST' => 'An Accounting-Request, used to convey accounting information for a service to the RADIUS server.',
'RADIUS_ACCOUNTING_RESPONSE' => 'An Accounting-Response response to an Accounting-Request.',
'RADIUS_ACCT_AUTHENTIC' => 'Accounting authentic, one of: `RADIUS_AUTH_RADIUS` `RADIUS_AUTH_LOCAL` `RADIUS_AUTH_REMOTE`',
'RADIUS_ACCT_DELAY_TIME' => 'Accounting delay time',
'RADIUS_ACCT_INPUT_OCTETS' => 'Accounting input bytes',
'RADIUS_ACCT_INPUT_PACKETS' => 'Accounting input packets',
'RADIUS_ACCT_LINK_COUNT' => 'Accounting link count',
'RADIUS_ACCT_MULTI_SESSION_ID' => 'Accounting multi session ID',
'RADIUS_ACCT_OUTPUT_OCTETS' => 'Accounting output bytes',
'RADIUS_ACCT_OUTPUT_PACKETS' => 'Accounting output packets',
'RADIUS_ACCT_SESSION_ID' => 'Accounting session ID',
'RADIUS_ACCT_SESSION_TIME' => 'Accounting session time',
'RADIUS_ACCT_STATUS_TYPE' => 'Accounting status type, one of: `RADIUS_START` `RADIUS_STOP` `RADIUS_ACCOUNTING_ON` `RADIUS_ACCOUNTING_OFF`',
'RADIUS_ACCT_TERMINATE_CAUSE' => 'Accounting terminate cause, one of: `RADIUS_TERM_USER_REQUEST` `RADIUS_TERM_LOST_CARRIER` `RADIUS_TERM_LOST_SERVICE` `RADIUS_TERM_IDLE_TIMEOUT` `RADIUS_TERM_SESSION_TIMEOUT` `RADIUS_TERM_ADMIN_RESET` `RADIUS_TERM_ADMIN_REBOOT` `RADIUS_TERM_PORT_ERROR` `RADIUS_TERM_NAS_ERROR` `RADIUS_TERM_NAS_REQUEST` `RADIUS_TERM_NAS_REBOOT` `RADIUS_TERM_PORT_UNNEEDED` `RADIUS_TERM_PORT_PREEMPTED` `RADIUS_TERM_PORT_SUSPENDED` `RADIUS_TERM_SERVICE_UNAVAILABLE` `RADIUS_TERM_CALLBACK` `RADIUS_TERM_USER_ERROR` `RADIUS_TERM_HOST_REQUEST`',
'RADIUS_CALLBACK_ID' => 'The Callback-Id attribute. The attribute value is a `string` containing an implementation-specific name of the place to be called.',
'RADIUS_CALLBACK_NUMBER' => 'The Callback-Number attribute. The attribute value is a `string` containing the dialing string to use for callback.',
'RADIUS_CALLED_STATION_ID' => 'Called Station Id',
'RADIUS_CALLING_STATION_ID' => 'Calling Station Id',
'RADIUS_CHAP_CHALLENGE' => 'Challenge',
'RADIUS_CHAP_PASSWORD' => 'The Chap-Password attribute. The attribute value is expected to be a `string` with the first byte containing the CHAP identifier, and the subsequent 16 bytes containing the MD5 hash of the CHAP identifier, the plaintext password and the CHAP challenge value concatenated together. Note that the CHAP challenge value should also be sent separately in a `RADIUS_CHAP_CHALLENGE` attribute.

Using CHAP passwords',
'RADIUS_CLASS' => 'The Class attribute. The attribute value is an arbitrary `string` included in an Access-Accept message that should then be sent to the accounting server in Accounting-Request messages, and can be set using `radius_put_attr`.',
'RADIUS_COA_ACK' => 'A CoA-ACK, sent to the RADIUS server to indicate that the user authorisations have been updated.

This constant is available in PECL radius 1.3.0 and later.',
'RADIUS_COA_NAK' => 'A CoA-NAK, sent to the RADIUS server to indicate that the user authorisations could not be updated.

This constant is available in PECL radius 1.3.0 and later.',
'RADIUS_COA_REQUEST' => 'A CoA-Request, sent from the RADIUS server to indicate that the authorisations within the user session have changed. A response must be sent in the form of a CoA-ACK or a CoA-NAK.

This constant is available in PECL radius 1.3.0 and later.',
'RADIUS_CONNECT_INFO' => 'Connect info',
'RADIUS_DISCONNECT_ACK' => 'A Disconnect-ACK, sent to the RADIUS server to indicate that the user session has been terminated.

This constant is available in PECL radius 1.3.0 and later.',
'RADIUS_DISCONNECT_NAK' => 'A Disconnect-NAK, sent to the RADIUS server to indicate that the user session could not be terminated.

This constant is available in PECL radius 1.3.0 and later.',
'RADIUS_DISCONNECT_REQUEST' => 'A Disconnect-Request, sent from the RADIUS server to indicate that the user session must be terminated.

This constant is available in PECL radius 1.3.0 and later.',
'RADIUS_FILTER_ID' => 'The Filter-ID attribute. The attribute value is expected to be an implementation-specific, human-readable `string` of filters, which can be set using `radius_put_attr`.',
'RADIUS_FRAMED_APPLETALK_LINK' => 'Framed Appletalk Link',
'RADIUS_FRAMED_APPLETALK_NETWORK' => 'Framed Appletalk Network',
'RADIUS_FRAMED_APPLETALK_ZONE' => 'Framed Appletalk Zone',
'RADIUS_FRAMED_COMPRESSION' => 'The Framed-Compression attribute. The attribute value is expected to be an `integer` indicating the compression protocol to be used, and can be set using `radius_put_int`. Possible values include these constants: `RADIUS_COMP_NONE`: No compression `RADIUS_COMP_VJ`: VJ TCP/IP header compression `RADIUS_COMP_IPXHDR`: IPX header compression `RADIUS_COMP_STAC_LZS`: Stac-LZS compression (added in PECL radius 1.3.0b2)',
'RADIUS_FRAMED_IP_ADDRESS' => 'The Framed-IP-Address attribute. The attribute value is expected to be the address of the user\'s network encoded as an `integer`, which can be set using `radius_put_addr` and retrieved using `radius_cvt_addr`.',
'RADIUS_FRAMED_IP_NETMASK' => 'The Framed-IP-Netmask attribute. The attribute value is expected to be the netmask of the user\'s network encoded as an `integer`, which can be set using `radius_put_addr` and retrieved using `radius_cvt_addr`.',
'RADIUS_FRAMED_IPX_NETWORK' => 'The Framed-IPX-Network attribute. The attribute value is an `integer` containing the IPX network to be configured for the user, or `0xFFFFFFFE` to indicate that the RADIUS client should select the network, and can be accessed via `radius_cvt_int`.',
'RADIUS_FRAMED_MTU' => 'The Framed-MTU attribute. The attribute value is expected to be an `integer` indicating the MTU to be configured for the user, and can be set using `radius_put_int`.',
'RADIUS_FRAMED_PROTOCOL' => 'The Framed-Protocol attribute. The attribute value is expected to be an `integer` indicating the framing to be used for framed access, and can be set using `radius_put_int`. The possible attribute values include these constants: `RADIUS_PPP` `RADIUS_SLIP` `RADIUS_ARAP` `RADIUS_GANDALF` `RADIUS_XYLOGICS`',
'RADIUS_FRAMED_ROUTE' => 'The Framed-Route attribute. The attribute value is a `string` containing an implementation-specific set of routes to be configured for the user.',
'RADIUS_FRAMED_ROUTING' => 'The Framed-Routing attribute. The attribute value is expected to be an `integer` indicating the routing method for the user, which can be set using `radius_put_int`.

Possible values include: `0`: No routing `1`: Send routing packets `2`: Listen for routing packets `3`: Send and listen',
'RADIUS_IDLE_TIMEOUT' => 'Idle timeout',
'RADIUS_LOGIN_IP_HOST' => 'The Login-IP-Host attribute. The attribute value is expected to the IP address to connect the user to, encoded as an `integer`, which can be set using `radius_put_addr`.',
'RADIUS_LOGIN_LAT_GROUP' => 'Login LAT Group',
'RADIUS_LOGIN_LAT_NODE' => 'Login LAT Node',
'RADIUS_LOGIN_LAT_PORT' => 'Login LAT Port',
'RADIUS_LOGIN_LAT_SERVICE' => 'Login LAT Service',
'RADIUS_LOGIN_SERVICE' => 'The Login-Service attribute. The attribute value is an `integer` indicating the service to connect the user to on the login host. The value can be converted to a PHP integer via `radius_cvt_int`.',
'RADIUS_LOGIN_TCP_PORT' => 'The Login-TCP-Port attribute. The attribute value is an `integer` indicating the port to connect the user to on the login host. The value can be converted to a PHP integer via `radius_cvt_int`.',
'RADIUS_MPPE_KEY_LEN' => 'The maximum length of MPPE keys.',
'RADIUS_NAS_IDENTIFIER' => 'NAS ID',
'RADIUS_NAS_IP_ADDRESS' => 'The NAS-IP-Address attribute. The attribute value is expected to the IP address of the RADIUS client encoded as an `integer`, which can be set using `radius_put_addr`.',
'RADIUS_NAS_PORT' => 'The NAS-Port attribute. The attribute value is expected to be the physical port of the user on the RADIUS client encoded as an `integer`, which can be set using `radius_put_int`.',
'RADIUS_NAS_PORT_TYPE' => 'NAS port type, one of: `RADIUS_ASYNC` `RADIUS_SYNC` `RADIUS_ISDN_SYNC` `RADIUS_ISDN_ASYNC_V120` `RADIUS_ISDN_ASYNC_V110` `RADIUS_VIRTUAL` `RADIUS_PIAFS` `RADIUS_HDLC_CLEAR_CHANNEL` `RADIUS_X_25` `RADIUS_X_75` `RADIUS_G_3_FAX` `RADIUS_SDSL` `RADIUS_ADSL_CAP` `RADIUS_ADSL_DMT` `RADIUS_IDSL` `RADIUS_ETHERNET` `RADIUS_XDSL` `RADIUS_CABLE` `RADIUS_WIRELESS_OTHER` `RADIUS_WIRELESS_IEEE_802_11`',
'RADIUS_OPTION_SALT' => 'When set, this option will result in the attribute value being salt-encrypted.',
'RADIUS_OPTION_TAGGED' => 'When set, this option will result in the attribute value being tagged with the value of the tag parameter.',
'RADIUS_PORT_LIMIT' => 'Port Limit',
'RADIUS_PROXY_STATE' => 'Proxy State',
'RADIUS_REPLY_MESSAGE' => 'The Reply-Message attribute. The attribute value is a `string` containing text that may be displayed to the user in response to an access request.',
'RADIUS_SERVICE_TYPE' => 'The Service-Type attribute. The attribute value indicates the service type the user is requesting, and is expected to be an `integer`, which can be set using `radius_put_int`.

A number of constants are provided to represent the possible values of this attribute. They include: `RADIUS_LOGIN` `RADIUS_FRAMED` `RADIUS_CALLBACK_LOGIN` `RADIUS_CALLBACK_FRAMED` `RADIUS_OUTBOUND` `RADIUS_ADMINISTRATIVE` `RADIUS_NAS_PROMPT` `RADIUS_AUTHENTICATE_ONLY` `RADIUS_CALLBACK_NAS_PROMPT`',
'RADIUS_SESSION_TIMEOUT' => 'Session timeout',
'RADIUS_STATE' => 'The State attribute. The attribute value is an implementation-defined `string` included in an Access-Challenge from a server that must be included in the subsequent Access-Request, and can be set using `radius_put_attr`.',
'RADIUS_TERMINATION_ACTION' => 'Termination action',
'RADIUS_USER_NAME' => 'The User-Name attribute. The attribute value is expected to be a `string` containing the name of the user being authenticated, and can be set using `radius_put_attr`.',
'RADIUS_USER_PASSWORD' => 'The User-Password attribute. The attribute value is expected to be a `string` containing the user\'s password, and can be set using `radius_put_attr`. This value will be obfuscated on transmission as described in section 5.2 of RFC 2865.',
'RADIUS_VENDOR_MICROSOFT' => 'Microsoft specific vendor attributes (RFC 2548), one of: `RADIUS_MICROSOFT_MS_CHAP_RESPONSE` `RADIUS_MICROSOFT_MS_CHAP_ERROR` `RADIUS_MICROSOFT_MS_CHAP_PW_1` `RADIUS_MICROSOFT_MS_CHAP_PW_2` `RADIUS_MICROSOFT_MS_CHAP_LM_ENC_PW` `RADIUS_MICROSOFT_MS_CHAP_NT_ENC_PW` `RADIUS_MICROSOFT_MS_MPPE_ENCRYPTION_POLICY` `RADIUS_MICROSOFT_MS_MPPE_ENCRYPTION_TYPES` `RADIUS_MICROSOFT_MS_RAS_VENDOR` `RADIUS_MICROSOFT_MS_CHAP_DOMAIN` `RADIUS_MICROSOFT_MS_CHAP_CHALLENGE` `RADIUS_MICROSOFT_MS_CHAP_MPPE_KEYS` `RADIUS_MICROSOFT_MS_BAP_USAGE` `RADIUS_MICROSOFT_MS_LINK_UTILIZATION_THRESHOLD` `RADIUS_MICROSOFT_MS_LINK_DROP_TIME_LIMIT` `RADIUS_MICROSOFT_MS_MPPE_SEND_KEY` `RADIUS_MICROSOFT_MS_MPPE_RECV_KEY` `RADIUS_MICROSOFT_MS_RAS_VERSION` `RADIUS_MICROSOFT_MS_OLD_ARAP_PASSWORD` `RADIUS_MICROSOFT_MS_NEW_ARAP_PASSWORD` `RADIUS_MICROSOFT_MS_ARAP_PASSWORD_CHANGE_REASON` `RADIUS_MICROSOFT_MS_FILTER` `RADIUS_MICROSOFT_MS_ACCT_AUTH_TYPE` `RADIUS_MICROSOFT_MS_ACCT_EAP_TYPE` `RADIUS_MICROSOFT_MS_CHAP2_RESPONSE` `RADIUS_MICROSOFT_MS_CHAP2_SUCCESS` `RADIUS_MICROSOFT_MS_CHAP2_PW` `RADIUS_MICROSOFT_MS_PRIMARY_DNS_SERVER` `RADIUS_MICROSOFT_MS_SECONDARY_DNS_SERVER` `RADIUS_MICROSOFT_MS_PRIMARY_NBNS_SERVER` `RADIUS_MICROSOFT_MS_SECONDARY_NBNS_SERVER` `RADIUS_MICROSOFT_MS_ARAP_CHALLENGE`',
'RADIUS_VENDOR_SPECIFIC' => 'The Vendor-Specific attribute. In general, vendor attribute values should be set using `radius_put_vendor_addr`, `radius_put_vendor_attr`, `radius_put_vendor_int` and `radius_put_vendor_string`, rather than directly.

This constant is mostly useful when interpreting vendor specific attributes in responses from a RADIUS server; when a vendor specific attribute is received, the `radius_get_vendor_attr` function should be used to access the vendor ID, attribute type and attribute value.',
'RAR_HOST_BEOS' => 'Use `RarEntry::HOST_BEOS` instead.',
'RAR_HOST_MSDOS' => 'Use `RarEntry::HOST_MSDOS` instead.',
'RAR_HOST_OS2' => 'Use `RarEntry::HOST_OS2` instead.',
'RAR_HOST_UNIX' => 'Use `RarEntry::HOST_UNIX` instead.',
'RAR_HOST_WIN32' => 'Use `RarEntry::HOST_WIN32` instead.',
'RarEntry::ATTRIBUTE_UNIX_BLOCK_DEV' => 'Unix block devices will have attributes whose last four bits have this value. To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constant
{@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}.',
'RarEntry::ATTRIBUTE_UNIX_CHAR_DEV' => 'Unix character devices will have attributes whose last four bits have this value. To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constant
{@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}.',
'RarEntry::ATTRIBUTE_UNIX_DIRECTORY' => 'Unix directories will have attributes whose last four bits have this value. To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constant
{@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}.

See also {@see RarEntry::isDirectory()}, which also works with entries that were added in other operating
systems.',
'RarEntry::ATTRIBUTE_UNIX_FIFO' => 'Unix FIFOs will have attributes whose last four bits have this value. To be used with {@see RarEntry::getAttr()}
on entries whose host OS is UNIX and with the constant {@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}.',
'RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET' => 'Mask to isolate the last four bits (nibble) of UNIX attributes (_S_IFMT, the type of file mask). To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constants
{@see RarEntry::ATTRIBUTE_UNIX_FIFO}, {@see RarEntry::ATTRIBUTE_UNIX_CHAR_DEV},
{@see RarEntry::ATTRIBUTE_UNIX_DIRECTORY}, {@see RarEntry::ATTRIBUTE_UNIX_BLOCK_DEV},
{@see RarEntry::ATTRIBUTE_UNIX_REGULAR_FILE},
{@see RarEntry::ATTRIBUTE_UNIX_SYM_LINK} and {@see RarEntry::ATTRIBUTE_UNIX_SOCKET}.',
'RarEntry::ATTRIBUTE_UNIX_GROUP_EXECUTE' => 'Bit that represents a UNIX entry that is group executable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_GROUP_READ' => 'Bit that represents a UNIX entry that is group readable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_GROUP_WRITE' => 'Bit that represents a UNIX entry that is group writable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_OWNER_EXECUTE' => 'Bit that represents a UNIX entry that is owner executable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_OWNER_READ' => 'Bit that represents a UNIX entry that is owner readable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_OWNER_WRITE' => 'Bit that represents a UNIX entry that is owner writable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_REGULAR_FILE' => 'Unix regular files (not directories) will have attributes whose last four bits have this value. To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constant
{@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}. See also {@see RarEntry::isDirectory()}, which also works with
entries that were added in other operating systems.',
'RarEntry::ATTRIBUTE_UNIX_SETGID' => 'Bit that represents the UNIX setgid attribute. To be used with {@see RarEntry::getAttr()} on entries whose host
OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_SETUID' => 'Bit that represents the UNIX setuid attribute. To be used with {@see RarEntry::getAttr()} on entries whose host
OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_SOCKET' => 'Unix sockets will have attributes whose last four bits have this value. To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constant
{@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}.',
'RarEntry::ATTRIBUTE_UNIX_STICKY' => 'Bit that represents the UNIX sticky bit. To be used with {@see RarEntry::getAttr()} on entries whose host OS is
UNIX.',
'RarEntry::ATTRIBUTE_UNIX_SYM_LINK' => 'Unix symbolic links will have attributes whose last four bits have this value. To be used with
{@see RarEntry::getAttr()} on entries whose host OS is UNIX and with the constant
{@see RarEntry::ATTRIBUTE_UNIX_FINAL_QUARTET}.',
'RarEntry::ATTRIBUTE_UNIX_WORLD_EXECUTE' => 'Bit that represents a UNIX entry that is world executable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_WORLD_READ' => 'Bit that represents a UNIX entry that is world readable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_UNIX_WORLD_WRITE' => 'Bit that represents a UNIX entry that is world writable. To be used with {@see RarEntry::getAttr()} on entries
whose host OS is UNIX.',
'RarEntry::ATTRIBUTE_WIN_ARCHIVE' => 'Bit that represents a Windows entry with an archive attribute. To be used with {@see RarEntry::getAttr()} on
entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_COMPRESSED' => 'Bit that represents a Windows entry with a compressed attribute (NTFS only). To be used with
{@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_DEVICE' => 'Bit that represents a Windows entry with a device attribute. To be used with {@see RarEntry::getAttr()} on
entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_DIRECTORY' => 'Bit that represents a Windows entry with a directory attribute (entry is a directory). To be used with
{@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows. See also
{@see RarEntry::isDirectory()}, which also works with entries that were not added in WinRAR.',
'RarEntry::ATTRIBUTE_WIN_ENCRYPTED' => 'Bit that represents a Windows entry with an encrypted attribute (NTFS only). To be used with
{@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_HIDDEN' => 'Bit that represents a Windows entry with a hidden attribute. To be used with {@see RarEntry::getAttr()} on
entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_NORMAL' => 'Bit that represents a Windows entry with a normal file attribute (entry is NOT a directory). To be used with
{@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows. See also
{@see RarEntry::isDirectory()}, which also works with entries that were not added in WinRAR.',
'RarEntry::ATTRIBUTE_WIN_NOT_CONTENT_INDEXED' => 'Bit that represents a Windows entry with a not content indexed attribute (entry is to be indexed). To be used
with {@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_OFFLINE' => 'Bit that represents a Windows entry with an offline attribute (entry is offline and not accessible). To be used
with {@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_READONLY' => 'Bit that represents a Windows entry with a read-only attribute. To be used with {@see RarEntry::getAttr()} on
entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_REPARSE_POINT' => 'Bit that represents a Windows entry with a reparse point attribute (entry is an NTFS reparse point, e.g. a
directory junction or a mount file system). To be used with {@see RarEntry::getAttr()} on entries whose host OS
is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_SPARSE_FILE' => 'Bit that represents a Windows entry with a sparse file attribute (file is an NTFS sparse file). To be used with
{@see RarEntry::getAttr()} on entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_SYSTEM' => 'Bit that represents a Windows entry with a system attribute. To be used with {@see RarEntry::getAttr()} on
entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_TEMPORARY' => 'Bit that represents a Windows entry with a temporary attribute. To be used with {@see RarEntry::getAttr()} on
entries whose host OS is Microsoft Windows.',
'RarEntry::ATTRIBUTE_WIN_VIRTUAL' => 'Bit that represents a Windows entry with a virtual attribute. To be used with {@see RarEntry::getAttr()}
on entries whose host OS is Microsoft Windows.',
'RarEntry::HOST_BEOS' => 'If the return value of {@see RarEntry::getHostOs()} equals this constant, BeOS was used to add this entry.
Intended to replace {@see RAR_HOST_BEOS}.',
'RarEntry::HOST_MACOS' => 'If the return value of {@see RarEntry::getHostOs()} equals this constant, Mac OS was used to add this entry.',
'RarEntry::HOST_MSDOS' => 'If the return value of {@see RarEntry::getHostOs()} equals this constant, MS-DOS was used to add this entry.
Use instead of {@see RAR_HOST_MSDOS}.',
'RarEntry::HOST_OS2' => 'If the return value of {@see RarEntry::getHostOs()} equals this constant, OS/2 was used to add this entry.
Intended to replace {@see RAR_HOST_OS2}.',
'RarEntry::HOST_UNIX' => 'If the return value of {@see RarEntry::getHostOs()} equals this constant, an unspecified UNIX OS was used to add
this entry. Intended to replace {@see RAR_HOST_UNIX}.',
'RarEntry::HOST_WIN32' => 'If the return value of {@see RarEntry::getHostOs()} equals this constant, Microsoft Windows was used to add this entry.
Intended to replace {@see RAR_HOST_WIN32}',
'READLINE_LIB' => 'The library which is used for readline support; currently either `readline` or `libedit`. Available as of PHP 5.5.0.',
'RPMMIRE_DEFAULT' => 'Search pattern is a regular expression with \., .* and ^...$ added.',
'RPMMIRE_GLOB' => 'Search pattern is a glob expression, using fnmatch(3).',
'RPMMIRE_REGEX' => 'Search pattern is a regular expression, using regcomp(3).',
'RPMMIRE_STRCMP' => 'Search pattern is a `string`, using strcmp(3).',
'RPMREADER_BASENAMES' => 'The list of the names of files in the RPM package without path information. This tag is used in conjunction with RPMREADER_DIRINDEXES and RPMREADER_DIRNAMES to reconstruct filenames in the RPM package stored with the new "CompressedFileNames" method in RPM.',
'RPMREADER_BUILDHOST' => 'The name of the host on which the RPM package was built.',
'RPMREADER_BUILDTIME' => 'The date and time when the RPM package was built.',
'RPMREADER_CHANGELOGNAME' => 'The list of changelog entry names.',
'RPMREADER_CHANGELOGTEXT' => 'The list of the text from changelog entries.',
'RPMREADER_CHANGELOGTIME' => 'The list of dates from changelog entries.',
'RPMREADER_DESCRIPTION' => 'The full description text of the RPM package.',
'RPMREADER_DIRINDEXES' => 'The list of indices that relate directory names to files in the RPM package. This tag is used in conjunction with RPMREADER_BASENAMES and RPMREADER_DIRNAMES to reconstruct filenames in the RPM package stored with the new "CompressedFileNames" method in RPM.',
'RPMREADER_DIRNAMES' => 'The list of directory names used by files in the RPM package. This tag is used in conjunction with RPMREADER_BASENAMES and RPMREADER_DIRINDEXES to reconstruct filenames in the RPM package stored with the new "CompressedFileNames" method in RPM.',
'RPMREADER_MAXIMUM' => 'The maximum valid value of any RPM tag number.',
'RPMREADER_MINIMUM' => 'The minimum valid value of any RPM tag number.',
'RPMREADER_NAME' => 'The name of the RPM package.',
'RPMREADER_OLDFILENAMES' => 'The list of files in an RPM package (deprecated format). The correct way is now to use a combination of 3 tags (RPMREADER_BASENAMES, RPMREADER_DIRINDEXES, RPMREADER_DIRNAMES) in what RPM now calls "CompressedFileNames". This tag is still used in older RPM files that did not use the "CompressedFileNames" method and is maintained for backward compatibility.',
'RPMREADER_RELEASE' => 'The release of the RPM package.',
'RPMREADER_SIZE' => 'The size of the RPM package.',
'RPMREADER_SUMMARY' => 'The summary text of the RPM package.',
'RPMREADER_VERSION' => 'The version of the RPM package.',
'RPMTAG_BASENAMES' => 'Name (not path) of files, with database index.',
'RPMTAG_CONFLICTNAME' => 'Conflicting dependencies, with database index.',
'RPMTAG_DIRNAMES' => 'Directory of files, with database index.',
'RPMTAG_ENHANCENAME' => 'Weak dependencies, with database index, requires librpm &gt;= 4.13.',
'RPMTAG_FILETRIGGERNAME' => 'File trigger name, with database index, requires librpm &gt;= 4.13.',
'RPMTAG_GROUP' => 'Group of the package, with database index.',
'RPMTAG_INSTALLTID' => 'Installation transaction ID, with database index.',
'RPMTAG_INSTFILENAMES' => 'Path of files, with database index.',
'RPMTAG_NAME' => 'Package name, with database index.',
'RPMTAG_OBSOLETENAME' => 'Obsoleted packages, with database index.',
'RPMTAG_PROVIDENAME' => 'Provided dependencies, with database index.',
'RPMTAG_RECOMMENDNAME' => 'Recommended weak dependencies, with database index, requires librpm &gt;= 4.13.',
'RPMTAG_REQUIRENAME' => 'Required dependencies, with database index.',
'RPMTAG_SHA1HEADER' => 'SHA1 signature, with database index.',
'RPMTAG_SIGMD5' => 'MD5 signature, with database index.',
'RPMTAG_SUGGESTNAME' => 'Suggested weak dependencies, with database index, requires librpm &gt;= 4.13.',
'RPMTAG_SUPPLEMENTNAME' => 'Weak dependencies, with database index, requires librpm &gt;= 4.13.',
'RPMTAG_TRANSFILETRIGGERNAME' => 'Transaction file trigger name, with database index, requires librpm &gt;= 4.13.',
'RPMTAG_TRIGGERNAME' => 'Trigger name, with database index.',
'RPMVERSION' => 'System librpm version.',
'RUNKIT7_ACC_PRIVATE' => 'Flag for `runkit7_method_add` and `runkit7_method_redefine` to make the method private.',
'RUNKIT7_ACC_PROTECTED' => 'Flag for `runkit7_method_add` and `runkit7_method_redefine` to make the method protected.',
'RUNKIT7_ACC_PUBLIC' => 'Flag for `runkit7_method_add` and `runkit7_method_redefine` to make the method public.',
'RUNKIT7_ACC_RETURN_REFERENCE' => 'Include this flag to make the function or method being created or redeclared return a reference.',
'RUNKIT7_ACC_STATIC' => 'Flag for `runkit7_method_add` and `runkit7_method_redefine` to make the method static.',
'RUNKIT7_FEATURE_MANIPULATION' => 'Equal to 1 if runtime manipulation is enabled, and 0 otherwise.',
'RUNKIT7_FEATURE_SANDBOX' => 'Always 0, it\'s impractical to implement the sandbox feature in php 7.',
'RUNKIT7_FEATURE_SUPERGLOBALS' => 'Equal to 1 if custom superglobals are enabled, and 0 otherwise.',
'RUNKIT7_IMPORT_CLASS_CONSTS' => '`runkit7_import` flag indicating that class constants should be imported from the specified file.',
'RUNKIT7_IMPORT_CLASS_METHODS' => '`runkit7_import` flag indicating that class methods should be imported from the specified file.',
'RUNKIT7_IMPORT_CLASS_PROPS' => '`runkit7_import` flag indicating that class standard properties should be imported from the specified file.',
'RUNKIT7_IMPORT_CLASS_STATIC_PROPS' => '`runkit7_import` flag indicating that class static properties should be imported from the specified file. Available since Runkit 1.0.1.',
'RUNKIT7_IMPORT_CLASSES' => '`runkit7_import` flag representing a bitwise OR of the `RUNKIT7_IMPORT_CLASS_*` constants.',
'RUNKIT7_IMPORT_FUNCTIONS' => '`runkit7_import` flag indicating that normal functions should be imported from the specified file.',
'RUNKIT7_IMPORT_OVERRIDE' => '`runkit7_import` flag indicating that if any of the imported functions, methods, constants, or properties already exist, they should be replaced with the new definitions. If this flag is not set, then any imported definitions which already exist will be discarded.',
'RUNKIT_ACC_PRIVATE' => 'PHP 5 specific flag to `runkit_method_add` and `runkit_method_redefine`',
'RUNKIT_ACC_PROTECTED' => 'PHP 5 specific flag to `runkit_method_add` and `runkit_method_redefine`',
'RUNKIT_ACC_PUBLIC' => 'PHP 5 specific flag to `runkit_method_add` and `runkit_method_redefine`',
'RUNKIT_ACC_STATIC' => 'PHP 5 specific flag to `runkit_method_add` and `runkit_method_redefine`. Available since Runkit 1.0.1.',
'RUNKIT_IMPORT_CLASS_CONSTS' => '`runkit_import` flag indicating that class constants should be imported from the specified file. Note that this flag is only meaningful in PHP versions 5.1.0 and above.',
'RUNKIT_IMPORT_CLASS_METHODS' => '`runkit_import` flag indicating that class methods should be imported from the specified file.',
'RUNKIT_IMPORT_CLASS_PROPS' => '`runkit_import` flag indicating that class standard properties should be imported from the specified file.',
'RUNKIT_IMPORT_CLASS_STATIC_PROPS' => '`runkit_import` flag indicating that class static properties should be imported from the specified file. Available since Runkit 1.0.1.',
'RUNKIT_IMPORT_CLASSES' => '`runkit_import` flag representing a bitwise OR of the `RUNKIT_IMPORT_CLASS_*` constants.',
'RUNKIT_IMPORT_FUNCTIONS' => '`runkit_import` flag indicating that normal functions should be imported from the specified file.',
'RUNKIT_IMPORT_OVERRIDE' => '`runkit_import` flag indicating that if any of the imported functions, methods, constants, or properties already exist, they should be replaced with the new definitions. If this flag is not set, then any imported definitions which already exist will be discarded.',
'RUNKIT_VERSION' => 'Defined to the current version of the runkit package.',
'SAM_AUTO' => 'Automatic behaviour',
'SAM_BOOLEAN' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_BUS' => 'Connect attribute used to set the name of the enterprise service bus to connect to.',
'SAM_BYTE' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_BYTES' => 'Message body type descriptor.',
'SAM_CORRELID' => 'Attribute used on receive, send and remove requests to identify specific messages.',
'SAM_DELIVERYMODE' => 'Message header property.',
'SAM_DOUBLE' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_ENDPOINTS' => 'Connect attribute used to define the possible endpoints to connect to.',
'SAM_FLOAT' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_HOST' => 'Connect attribute used to set the hostname of the required messaging server.',
'SAM_INT' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_LONG' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_MANUAL' => 'Manual (script controlled) behaviour',
'SAM_MESSAGEID' => 'Attribute used on receive and remove requests to identify specific messages.',
'SAM_MQTT' => 'Connect protocol definition for selecting the MQTT (MQ Telemetry Transport) protocol.',
'SAM_MQTT_CLEANSTART' => 'Optional connect option to indicate to an MQTT server that all previous connection data for this client should be removed and that subscriptions should be deleted when the client disconnects explicitly or unexpectedly.',
'SAM_NON_PERSISTENT' => 'Connect attribute value used to request messages are not made persistent on the messaging server.',
'SAM_PASSWORD' => 'Connect attribute used to define the password to be used for the user account being used to connect to a messaging server that requires authorisation for connections.',
'SAM_PERSISTENT' => 'Connect attribute value used to request messages are made persistent on the messaging server to protect against loss of messages in the event of failure.',
'SAM_PORT' => 'Connect attribute used to set the port number on which to communicate with the messaging server.',
'SAM_PRIORITY' => 'Option name used on send requests to specify a delivery priority value.',
'SAM_REPLY_TO' => 'Message property used to specify the queue identity on to which the script expects response or reply messages to be posted.',
'SAM_RTT' => 'Connect protocol definition for selecting the IBM Realtime Transport protocol for communication with a business integration messaging server.',
'SAM_STRING' => 'Type specifier used when setting properties on SAM_Message objects.',
'SAM_TARGETCHAIN' => 'Connection attribute used to set the required target chain identifier.',
'SAM_TEXT' => 'Message body type descriptor.',
'SAM_TIMETOLIVE' => 'Message send option name used to specify the length of time a message should be retained in milliseconds.',
'SAM_TRANSACTIONS' => 'Connection attribute used to set required transactional behaviour. May be set to SAM_AUTO (default) or SAM_MANUAL.',
'SAM_USERID' => 'Connect attribute used to define the account to being used to connect to a messaging server that requires authorisation for connections.',
'SAM_WAIT' => 'Receive property used to specify the wait timeout to be used when receiving a message from a queue or subscription.',
'SAM_WMQ' => 'Connect protocol definition for selecting the IBM WebSphere MQSeries protocol for communication with the desired messaging server.',
'SAM_WMQ_BINDINGS' => 'Connect protocol definition for selecting the IBM WebSphere MQSeries protocol for communication with a local messaging server.',
'SAM_WMQ_CLIENT' => 'Connect protocol definition for selecting the IBM WebSphere MQSeries protocol for communication with a remote messaging server.',
'SAM_WMQ_TARGET_CLIENT' => 'Option name used on send requests to specify the target client mode. This can either be default to \'jms\' or \'mq\'. The default is \'jms\' which means an RFH2 header is sent with the message whereas the \'mq\' setting means no RFH2 is included.',
'SAM_WPM' => 'Connect protocol definition for selecting the IBM WebSphere Platform Messaging protocol for communication with a WebSphere Application Server messaging server.',
'SCANDIR_SORT_ASCENDING' => 'Available since PHP 5.4.0.',
'SCANDIR_SORT_DESCENDING' => 'Available since PHP 5.4.0.',
'SCANDIR_SORT_NONE' => 'Available since PHP 5.4.0.',
'SDO_DAS_ChangeSummary::ADDITION' => 'Represents a change type of \'addition\'.',
'SDO_DAS_ChangeSummary::DELETION' => 'Represents a change type of \'deletion\'.',
'SDO_DAS_ChangeSummary::MODIFICATION' => 'Represents a change type of \'modification\'.',
'SDO_DAS_ChangeSummary::NONE' => 'Represents a change type of \'none\'.',
'SE_NOPREFETCH' => 'Don\'t prefetch searched messages',
'SE_UID' => 'Return UIDs instead of sequence numbers',
'SEASLOG_ALERT' => '"ALERT" - Action must be taken immediately.Immediate attention should be given to relevant personnel for emergency repairs.',
'SEASLOG_ALL' => '"ALL"',
'SEASLOG_APPENDER_FILE' => '1',
'SEASLOG_APPENDER_TCP' => '2',
'SEASLOG_APPENDER_UDP' => '3',
'SEASLOG_CLOSE_LOGGER_STREAM_MOD_ALL' => '1',
'SEASLOG_CLOSE_LOGGER_STREAM_MOD_ASSIGN' => '2',
'SEASLOG_CRITICAL' => '"CRITICAL" - Critical conditions.Need to be repaired immediately, and the program component is unavailable.',
'SEASLOG_DEBUG' => '"DEBUG" - Detailed debug information.Fine-grained information events.',
'SEASLOG_DETAIL_ORDER_ASC' => '1',
'SEASLOG_DETAIL_ORDER_DESC' => '2',
'SEASLOG_EMERGENCY' => '"EMERGENCY" - System is unusable.',
'SEASLOG_ERROR' => '"ERROR" - Runtime errors that do not require immediate action but should typically.',
'SEASLOG_INFO' => '"INFO" - Interesting events.Emphasizes the running process of the application.',
'SEASLOG_NOTICE' => '"NOTICE" - Normal but significant events.Information that is more important than the INFO level during execution.',
'SEASLOG_REQUEST_VARIABLE_CLIENT_IP' => '4',
'SEASLOG_REQUEST_VARIABLE_DOMAIN_PORT' => '1',
'SEASLOG_REQUEST_VARIABLE_REQUEST_METHOD' => '3',
'SEASLOG_REQUEST_VARIABLE_REQUEST_URI' => '2',
'SEASLOG_WARNING' => '"WARNING" - Exceptional occurrences that are not errors.Potentially aberrant information that needs attention and needs to be repaired.',
'SEGV_ACCERR' => 'Available since PHP 5.3.0.',
'SEGV_MAPERR' => 'Available since PHP 5.3.0.',
'SI_ASYNCIO' => 'Available since PHP 5.3.0.',
'SI_KERNEL' => 'Available since PHP 5.3.0.',
'SI_MSGGQ' => 'Available since PHP 5.3.0.',
'SI_NOINFO' => 'Available since PHP 5.3.0.',
'SI_QUEUE' => 'Available since PHP 5.3.0.',
'SI_SIGIO' => 'Available since PHP 5.3.0.',
'SI_TIMER' => 'Available since PHP 5.3.0.',
'SI_TKILL' => 'Available since PHP 5.3.0.',
'SI_USER' => 'Available since PHP 5.3.0.',
'SID' => 'Constant containing either the session name and session ID in the form of `"name=ID"` or empty string if session ID was set in an appropriate session cookie. This is the same id as the one returned by `session_id`.',
'SIG_BLOCK' => 'Available since PHP 5.3.0.',
'SIG_SETMASK' => 'Available since PHP 5.3.0.',
'SIG_UNBLOCK' => 'Available since PHP 5.3.0.',
'SNMP_OID_OUTPUT_FULL' => 'As of 5.2.0',
'SNMP_OID_OUTPUT_MODULE' => 'As of 5.4.0',
'SNMP_OID_OUTPUT_NONE' => 'As of 5.4.0',
'SNMP_OID_OUTPUT_NUMERIC' => 'As of 5.2.0',
'SNMP_OID_OUTPUT_SUFFIX' => 'As of 5.4.0',
'SNMP_OID_OUTPUT_UCD' => 'As of 5.4.0',
'SO_REUSEPORT' => 'This constant is only available in PHP 5.4.10 or later on platforms that support the `SO_REUSEPORT` socket option: this includes macOS and FreeBSD, but does not include Linux or Windows.',
'SOCKET_ADDRINUSE' => 'Address already in use.',
'SOCKET_E2BIG' => 'Arg list too long.',
'SOCKET_EACCES' => 'Permission denied.',
'SOCKET_EADDRNOTAVAIL' => 'Cannot assign requested address.',
'SOCKET_EADV' => 'Advertise error.',
'SOCKET_EAFNOSUPPORT' => 'Address family not supported by protocol.',
'SOCKET_EAGAIN' => 'Try again.',
'SOCKET_EALREADY' => 'Operation already in progress.',
'SOCKET_EBADE' => 'Invalid exchange.',
'SOCKET_EBADF' => 'Bad file number.',
'SOCKET_EBADFD' => 'File descriptor in bad state.',
'SOCKET_EBADMSG' => 'Not a data message.',
'SOCKET_EBADR' => 'Invalid request descriptor.',
'SOCKET_EBADRQC' => 'Invalid request code.',
'SOCKET_EBADSLT' => 'Invalid slot.',
'SOCKET_EBUSY' => 'Device or resource busy.',
'SOCKET_ECHRNG' => 'Channel number out of range.',
'SOCKET_ECOMM' => 'Communication error on send.',
'SOCKET_ECONNABORTED' => 'Software caused connection abort.',
'SOCKET_ECONNREFUSED' => 'Connection refused.',
'SOCKET_ECONNRESET' => 'Connection reset by peer.',
'SOCKET_EDESTADDRREQ' => 'Destination address required.',
'SOCKET_EDQUOT' => 'Quota exceeded.',
'SOCKET_EEXIST' => 'File exists.',
'SOCKET_EFAULT' => 'Bad address.',
'SOCKET_EHOSTDOWN' => 'Host is down.',
'SOCKET_EHOSTUNREACH' => 'No route to host.',
'SOCKET_EIDRM' => 'Identifier removed.',
'SOCKET_EINPROGRESS' => 'Operation now in progress.',
'SOCKET_EINTR' => 'Interrupted system call.',
'SOCKET_EINVAL' => 'Invalid argument.',
'SOCKET_EIO' => 'I/O error.',
'SOCKET_EISCONN' => 'Transport endpoint is already connected.',
'SOCKET_EISDIR' => 'Is a directory.',
'SOCKET_EISNAM' => 'Is a named type file.',
'SOCKET_EL2HLT' => 'Level 2 halted.',
'SOCKET_EL2NSYNC' => 'Level 2 not synchronized.',
'SOCKET_EL3HLT' => 'Level 3 halted.',
'SOCKET_EL3RST' => 'Level 3 reset.',
'SOCKET_ELNRNG' => 'Link number out of range.',
'SOCKET_ELOOP' => 'Too many symbolic links encountered.',
'SOCKET_EMEDIUMTYPE' => 'Wrong medium type.',
'SOCKET_EMFILE' => 'Too many open files.',
'SOCKET_EMLINK' => 'Too many links.',
'SOCKET_EMSGSIZE' => 'Message too long.',
'SOCKET_EMULTIHOP' => 'Multihop attempted.',
'SOCKET_ENAMETOOLONG' => 'File name too long.',
'SOCKET_ENETDOWN' => 'Network is down.',
'SOCKET_ENETRESET' => 'Network dropped connection because of reset.',
'SOCKET_ENETUNREACH' => 'Network is unreachable.',
'SOCKET_ENFILE' => 'File table overflow.',
'SOCKET_ENOANO' => 'No anode.',
'SOCKET_ENOBUFS' => 'No buffer space available.',
'SOCKET_ENOCSI' => 'No CSI structure available.',
'SOCKET_ENODATA' => 'No data available.',
'SOCKET_ENODEV' => 'No such device.',
'SOCKET_ENOENT' => 'No such file or directory.',
'SOCKET_ENOLCK' => 'No record locks available.',
'SOCKET_ENOLINK' => 'Link has been severed.',
'SOCKET_ENOMEDIUM' => 'No medium found.',
'SOCKET_ENOMEM' => 'Out of memory.',
'SOCKET_ENOMSG' => 'No message of desired type.',
'SOCKET_ENONET' => 'Machine is not on the network.',
'SOCKET_ENOSPC' => 'No space left on device.',
'SOCKET_ENOSR' => 'Out of streams resources.',
'SOCKET_ENOSTR' => 'Device not a stream.',
'SOCKET_ENOSYS' => 'Function not implemented.',
'SOCKET_ENOTBLK' => 'Block device required.',
'SOCKET_ENOTCONN' => 'Transport endpoint is not connected.',
'SOCKET_ENOTDIR' => 'Not a directory.',
'SOCKET_ENOTEMPTY' => 'Directory not empty.',
'SOCKET_ENOTSOCK' => 'Socket operation on non-socket.',
'SOCKET_ENOTTY' => 'Not a typewriter.',
'SOCKET_ENOTUNIQ' => 'Name not unique on network.',
'SOCKET_ENXIO' => 'No such device or address.',
'SOCKET_EOPNOTSUPP' => 'Operation not supported on transport endpoint.',
'SOCKET_EPERM' => 'Operation not permitted.',
'SOCKET_EPFNOSUPPORT' => 'Protocol family not supported.',
'SOCKET_EPIPE' => 'Broken pipe.',
'SOCKET_EPROTO' => 'Protocol error.',
'SOCKET_EPROTONOSUPPORT' => 'Protocol not supported.',
'SOCKET_EPROTOOPT' => 'Protocol not available.',
'SOCKET_EPROTOTYPE' => 'Protocol wrong type for socket.',
'SOCKET_EREMCHG' => 'Remote address changed.',
'SOCKET_EREMOTE' => 'Object is remote.',
'SOCKET_EREMOTEIO' => 'Remote I/O error.',
'SOCKET_ERESTART' => 'Interrupted system call should be restarted.',
'SOCKET_EROFS' => 'Read-only file system.',
'SOCKET_ESHUTDOWN' => 'Cannot send after transport endpoint shutdown.',
'SOCKET_ESOCKTNOSUPPORT' => 'Socket type not supported.',
'SOCKET_ESPIPE' => 'Illegal seek.',
'SOCKET_ESRMNT' => 'Srmount error.',
'SOCKET_ESTRPIPE' => 'Streams pipe error.',
'SOCKET_ETIME' => 'Timer expired.',
'SOCKET_ETIMEDOUT' => 'Connection timed out.',
'SOCKET_ETOOMANYREFS' => 'Too many references: cannot splice.',
'SOCKET_EUNATCH' => 'Protocol driver not attached.',
'SOCKET_EUSERS' => 'Too many users.',
'SOCKET_EWOULDBLOCK' => 'Operation would block.',
'SOCKET_EXDEV' => 'Cross-device link.',
'SOCKET_EXFULL' => 'Exchange full.',
'Sodium\CRYPTO_AEAD_AES256GCM_KEYBYTES' => 'To silence the phpstorm "unknown namespace" errors.',
'SolrClient::DEFAULT_PING_SERVLET' => 'This is the initial value for the ping servlet.',
'SolrClient::DEFAULT_SEARCH_SERVLET' => 'This is the initial value for the search servlet.',
'SolrClient::DEFAULT_SYSTEM_SERVLET' => 'This is the initial value for the system servlet used to obtain Solr Server information.',
'SolrClient::DEFAULT_TERMS_SERVLET' => 'This is the initial value for the terms servlet used for the TermsComponent.',
'SolrClient::DEFAULT_THREADS_SERVLET' => 'This is the initial value for the threads servlet.',
'SolrClient::DEFAULT_UPDATE_SERVLET' => 'This is the initial value for the update servlet.',
'SolrClient::PING_SERVLET_TYPE' => 'Used when updating the ping servlet.',
'SolrClient::SEARCH_SERVLET_TYPE' => 'Used when updating the search servlet.',
'SolrClient::SYSTEM_SERVLET_TYPE' => 'Used when retrieving system information from the system servlet.',
'SolrClient::TERMS_SERVLET_TYPE' => 'Used when updating the terms servlet.',
'SolrClient::THREADS_SERVLET_TYPE' => 'Used when updating the threads servlet.',
'SolrClient::UPDATE_SERVLET_TYPE' => 'Used when updating the update servlet.',
'SolrDisMaxQuery::FACET_SORT_COUNT' => 'Used to specify that the facet should sort by count',
'SolrDisMaxQuery::FACET_SORT_INDEX' => 'Used to specify that the facet should sort by index',
'SolrDisMaxQuery::ORDER_ASC' => 'Used to specify that the sorting should be in ascending order',
'SolrDisMaxQuery::ORDER_DESC' => 'Used to specify that the sorting should be in descending order',
'SolrDisMaxQuery::TERMS_SORT_COUNT' => 'Used in the TermsComponent',
'SolrDisMaxQuery::TERMS_SORT_INDEX' => 'Used in the TermsComponent',
'SolrDocument::SORT_ASC' => 'Sorts the fields in ascending order.',
'SolrDocument::SORT_DEFAULT' => 'Sorts the fields in ascending order.',
'SolrDocument::SORT_DESC' => 'Sorts the fields in descending order.',
'SolrDocument::SORT_FIELD_BOOST_VALUE' => 'Sorts the fields by boost value.',
'SolrDocument::SORT_FIELD_NAME' => 'Sorts the fields by name',
'SolrDocument::SORT_FIELD_VALUE_COUNT' => 'Sorts the fields by number of values.',
'SolrGenericResponse::PARSE_SOLR_DOC' => 'Documents should be parsed as SolrDocument instances.',
'SolrGenericResponse::PARSE_SOLR_OBJ' => 'Documents should be parsed as SolrObject instances',
'SolrInputDocument::SORT_ASC' => 'Sorts the fields in ascending order.',
'SolrInputDocument::SORT_DEFAULT' => 'Sorts the fields in ascending order.',
'SolrInputDocument::SORT_DESC' => 'Sorts the fields in descending order.',
'SolrInputDocument::SORT_FIELD_BOOST_VALUE' => 'Sorts the fields by boost value.',
'SolrInputDocument::SORT_FIELD_NAME' => 'Sorts the fields by name',
'SolrInputDocument::SORT_FIELD_VALUE_COUNT' => 'Sorts the fields by number of values.',
'SolrPingResponse::PARSE_SOLR_DOC' => 'Documents should be parsed as SolrDocument instances.',
'SolrPingResponse::PARSE_SOLR_OBJ' => 'Documents should be parsed as SolrObject instances',
'SolrQuery::FACET_SORT_COUNT' => 'Used to specify that the facet should sort by count',
'SolrQuery::FACET_SORT_INDEX' => 'Used to specify that the facet should sort by index',
'SolrQuery::ORDER_ASC' => 'Used to specify that the sorting should be in ascending order',
'SolrQuery::ORDER_DESC' => 'Used to specify that the sorting should be in descending order',
'SolrQuery::TERMS_SORT_COUNT' => 'Used in the TermsComponent',
'SolrQuery::TERMS_SORT_INDEX' => 'Used in the TermsComponent',
'SolrQueryResponse::PARSE_SOLR_DOC' => 'Documents should be parsed as SolrDocument instances.',
'SolrQueryResponse::PARSE_SOLR_OBJ' => 'Documents should be parsed as SolrObject instances',
'SolrResponse::PARSE_SOLR_DOC' => 'Documents should be parsed as SolrDocument instances.',
'SolrResponse::PARSE_SOLR_OBJ' => 'Documents should be parsed as SolrObject instances',
'SolrUpdateResponse::PARSE_SOLR_DOC' => 'Documents should be parsed as SolrDocument instances.',
'SolrUpdateResponse::PARSE_SOLR_OBJ' => 'Documents should be parsed as SolrObject instances',
'SORT_ASC' => '`SORT_ASC` is used with `array_multisort` to sort in ascending order.',
'SORT_DESC' => '`SORT_DESC` is used with `array_multisort` to sort in descending order.',
'SORT_FLAG_CASE' => '`SORT_FLAG_CASE` can be combined (bitwise OR) with `SORT_STRING` or `SORT_NATURAL` to sort strings case-insensitively. Added in PHP 5.4.0.',
'SORT_LOCALE_STRING' => '`SORT_LOCALE_STRING` is used to compare items as strings, based on the current locale. Added in PHP 5.0.2.',
'SORT_NATURAL' => '`SORT_NATURAL` is used to compare items as strings using "natural ordering" like `natsort`. Added in PHP 5.4.0.',
'SORT_NUMERIC' => '`SORT_NUMERIC` is used to compare items numerically.',
'SORT_REGULAR' => '`SORT_REGULAR` is used to compare items normally.',
'SORT_STRING' => '`SORT_STRING` is used to compare items as strings.',
'SORTARRIVAL' => 'Sort criteria for `imap_sort`: arrival date',
'SORTCC' => 'Sort criteria for `imap_sort`: mailbox in first cc address',
'SORTDATE' => 'Sort criteria for `imap_sort`: message Date',
'SORTFROM' => 'Sort criteria for `imap_sort`: mailbox in first From address',
'SORTSIZE' => 'Sort criteria for `imap_sort`: size of message in octets',
'SORTSUBJECT' => 'Sort criteria for `imap_sort`: message subject',
'SORTTO' => 'Sort criteria for `imap_sort`: mailbox in first To address',
'SplType::__default' => 'Default value',
'SQLBIT' => 'Indicates the \'`BIT`\' type in MSSQL, used by `mssql_bind`\'s `type` parameter.',
'SQLCHAR' => 'Indicates the \'`CHAR`\' type in MSSQL, used by `mssql_bind`\'s `type` parameter.',
'SQLFLT4' => 'Represents an four byte float.',
'SQLFLT8' => 'Represents an eight byte float.',
'SQLINT1' => 'Represents one byte, with a range of -128 to 127.',
'SQLINT2' => 'Represents two bytes, with a range of -32768 to 32767.',
'SQLINT4' => 'Represents four bytes, with a range of -2147483648 to 2147483647.',
'SQLITE3_ASSOC' => 'Specifies that the `Sqlite3Result::fetchArray` method shall return an array indexed by column name as returned in the corresponding result set.',
'SQLITE3_BLOB' => 'Represents the SQLite3 BLOB storage class.',
'SQLITE3_BOTH' => 'Specifies that the `Sqlite3Result::fetchArray` method shall return an array indexed by both column name and number as returned in the corresponding result set, starting at column 0.',
'SQLITE3_DETERMINISTIC' => 'Specifies that a function created with `SQLite3::createFunction` is deterministic, i.e. it always returns the same result given the same inputs within a single SQL statement. (Available as of PHP 7.1.4.)',
'SQLITE3_FLOAT' => 'Represents the SQLite3 REAL (FLOAT) storage class.',
'SQLITE3_INTEGER' => 'Represents the SQLite3 INTEGER storage class.',
'SQLITE3_NULL' => 'Represents the SQLite3 NULL storage class.',
'SQLITE3_NUM' => 'Specifies that the `Sqlite3Result::fetchArray` method shall return an array indexed by column number as returned in the corresponding result set, starting at column 0.',
'SQLITE3_OPEN_CREATE' => 'Specifies that the SQLite3 database be created if it does not already exist.',
'SQLITE3_OPEN_READONLY' => 'Specifies that the SQLite3 database be opened for reading only.',
'SQLITE3_OPEN_READWRITE' => 'Specifies that the SQLite3 database be opened for reading and writing.',
'SQLITE3_TEXT' => 'Represents the SQLite3 TEXT storage class.',
'SQLITE_ABORT' => 'Callback routine requested an abort.',
'SQLITE_ASSOC' => 'Columns are returned into the array having the field name as the array index.',
'SQLITE_AUTH' => 'Authorized failed.',
'SQLITE_BOTH' => 'Columns are returned into the array having both a numerical index and the field name as the array index.',
'SQLITE_BUSY' => 'The database file is locked.',
'SQLITE_CANTOPEN' => 'Unable to open the database file.',
'SQLITE_CONSTRAINT' => 'Abort due to constraint violation.',
'SQLITE_CORRUPT' => 'The database disk image is malformed.',
'SQLITE_DONE' => 'Internal process has finished executing.',
'SQLITE_EMPTY' => '(Internal) Database table is empty.',
'SQLITE_ERROR' => 'SQL error or missing database.',
'SQLITE_FORMAT' => 'Auxiliary database format error.',
'SQLITE_FULL' => 'Insertion failed because database is full.',
'SQLITE_INTERNAL' => 'An internal logic error in SQLite.',
'SQLITE_INTERRUPT' => 'Operation terminated internally.',
'SQLITE_IOERR' => 'Disk I/O error occurred.',
'SQLITE_LOCKED' => 'A table in the database is locked.',
'SQLITE_MISMATCH' => 'Data type mismatch.',
'SQLITE_MISUSE' => 'Library used incorrectly.',
'SQLITE_NOLFS' => 'Uses of OS features not supported on host.',
'SQLITE_NOMEM' => 'Memory allocation failed.',
'SQLITE_NOTADB' => 'File opened that is not a database file.',
'SQLITE_NOTFOUND' => '(Internal) Table or record not found.',
'SQLITE_NUM' => 'Columns are returned into the array having a numerical index to the fields. This index starts with 0, the first field in the result.',
'SQLITE_OK' => 'Successful result.',
'SQLITE_PERM' => 'Access permission denied.',
'SQLITE_PROTOCOL' => 'Database lock protocol error.',
'SQLITE_READONLY' => 'Attempt to write a readonly database.',
'SQLITE_ROW' => 'Internal process has another row ready.',
'SQLITE_SCHEMA' => 'The database schema changed.',
'SQLITE_TOOBIG' => 'Too much data for one row of a table.',
'SQLSRV_CURSOR_BUFFERED' => 'Creates a client-side cursor query. Lets you access rows in any order. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_CURSOR_DYNAMIC' => 'Indicates a dynamic cursor. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_CURSOR_FORWARD' => 'Indicates a forward-only cursor. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_CURSOR_KEYSET' => 'Indicates a keyset cursor. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_CURSOR_STATIC' => 'Indicates a static cursor. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_ENC_BINARY' => 'Specifies that data is returned as a raw byte stream from the server without performing encoding or translation. For usage information, see How to: Specify PHP Types.',
'SQLSRV_ENC_CHAR' => 'Data is returned in 8-bit characters as specified in the code page of the Windows locale that is set on the system. Any multi-byte characters or characters that do not map into this code page are substituted with a single byte question mark (?) character. This is the default encoding. For usage information, see How to: Specify PHP Types.',
'SQLSRV_ERR_ALL' => 'Forces `sqlsrv_errors` to return both errors and warings when passed as a parameter (the default behavior).',
'SQLSRV_ERR_ERRORS' => 'Forces `sqlsrv_errors` to return errors only (no warnings) when passed as a parameter.',
'SQLSRV_ERR_WARNINGS' => 'Forces `sqlsrv_errors` to return warnings only (no errors) when passed as a parameter.',
'SQLSRV_FETCH_ASSOC' => 'Forces `sqlsrv_fetch_array` to return an associative array when passed as a parameter.',
'SQLSRV_FETCH_BOTH' => 'Forces `sqlsrv_fetch_array` to return an array with both associative and numeric keys when passed as a parameter (the default behavior).',
'SQLSRV_FETCH_NUMERIC' => 'Forces `sqlsrv_fetch_array` to return an array with numeric when passed as a parameter.',
'SQLSRV_LOG_SEVERITY_ALL' => 'Specifies that errors, warnings, and notices will be logged when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SEVERITY_ERROR' => 'Specifies that errors will be logged when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SEVERITY_NOTICE' => 'Specifies that notices will be logged when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SEVERITY_WARNING' => 'Specifies that warnings will be logged when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SYSTEM_ALL' => 'Turns on logging of all subsystems when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SYSTEM_CONN' => 'Turns on logging of connection activity when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SYSTEM_INIT' => 'Turns on logging of initialization activity when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SYSTEM_OFF' => 'Turns off logging of all subsystems when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SYSTEM_STMT' => 'Turns on logging of statement activity when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_LOG_SYSTEM_UTIL' => 'Turns on logging of error function activity when passed to `sqlsrv_configure` as a parameter.',
'SQLSRV_NULLABLE_NO' => 'Indicates that a column is not nullable.',
'SQLSRV_NULLABLE_UNKNOWN' => 'Indicates that it is not known if a column is nullable.',
'SQLSRV_NULLABLE_YES' => 'Indicates that a column is nullable.',
'SQLSRV_PARAM_IN' => 'Indicates an input parameter when passed to `sqlsrv_query` or `sqlsrv_prepare`.',
'SQLSRV_PARAM_INOUT' => 'Indicates a bidirectional parameter when passed to `sqlsrv_query` or `sqlsrv_prepare`.',
'SQLSRV_PARAM_OUT' => 'Indicates an output parameter when passed to `sqlsrv_query` or `sqlsrv_prepare`.',
'SQLSRV_PHPTYPE_DATETIME' => 'Specifies a datetime PHP data type. For usage information, see How to: Specify PHP Types.',
'SQLSRV_PHPTYPE_FLOAT' => 'Specifies a float PHP data type. For usage information, see How to: Specify PHP Types.',
'SQLSRV_PHPTYPE_INT' => 'Specifies an integer PHP data type. For usage information, see How to: Specify PHP Types.',
'SQLSRV_PHPTYPE_STREAM' => 'Specifies a PHP stream. This constant works like a function and accepts an encoding constant. See the SQLSRV_ENC_* constants. For usage information, see How to: Specify PHP Types.',
'SQLSRV_PHPTYPE_STRING' => 'Specifies a string PHP data type. This constant works like a function and accepts an encoding constant. See the SQLSRV_ENC_* constants. For usage information, see How to: Specify PHP Types.',
'SQLSRV_SCROLL_ABSOLUTE' => 'Specifies which row to select in a result set. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_SCROLL_FIRST' => 'Specifies which row to select in a result set. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_SCROLL_LAST' => 'Specifies which row to select in a result set. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_SCROLL_NEXT' => 'Specifies which row to select in a result set. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_SCROLL_PRIOR' => 'Specifies which row to select in a result set. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_SCROLL_RELATIVE' => 'Specifies which row to select in a result set. For usage information, see Specifying a Cursor Type and Selecting Rows.',
'SQLSRV_SQLTYPE_BIGINT' => 'Describes the bigint SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_BINARY' => 'Describes the binary SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_BIT' => 'Describes the bit SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_CHAR' => 'Describes the char SQL Server data type. This constant works like a function and accepts a parameter indicating the number characters. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_DATE' => 'Describes the date SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_DATETIME' => 'Describes the datetime SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_DATETIME2' => 'Describes the datetime2 SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_DATETIMEOFFSET' => 'Describes the datetimeoffset SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_DECIMAL' => 'Describes the decimal SQL Server data type. This constant works like a function and accepts two parameters indicating (in order) precision and scale. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_FLOAT' => 'Describes the float SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_IMAGE' => 'Describes the image SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_INT' => 'Describes the int SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_MONEY' => 'Describes the money SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_NCHAR' => 'Describes the nchar SQL Server data type. This constant works like a function and accepts a single parameter indicating the character count. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_NTEXT' => 'Describes the ntext SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_NUMERIC' => 'Describes the numeric SQL Server data type. This constant works like a function and accepts two parameter indicating (in order) precision and scale. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_NVARCHAR' => 'Describes the nvarchar(MAX) SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_REAL' => 'Describes the real SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_SMALLDATETIME' => 'Describes the smalldatetime SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_SMALLINT' => 'Describes the smallint SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_SMALLMONEY' => 'Describes the smallmoney SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_TEXT' => 'Describes the text SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_TIME' => 'Describes the time SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_TIMESTAMP' => 'Describes the timestamp SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_TINYINT' => 'Describes the tinyint SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_UDT' => 'Describes the UDT SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_UNIQUEIDENTIFIER' => 'Describes the uniqueidentifier SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_VARBINARY' => 'Describes the varbinary(MAX) SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_VARCHAR' => 'Describes the varchar(MAX) SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_SQLTYPE_XML' => 'Describes the XML SQL Server data type. For usage information, see How to: Specify SQL Types.',
'SQLSRV_TXN_READ_COMMITTED' => 'Indicates a transaction isolation level of READ COMMITTED. This value is used to set the TransactionIsolation level in the $connectionOptions array passed to `sqlsrv_connect`.',
'SQLSRV_TXN_READ_SERIALIZABLE' => 'Indicates a transaction isolation level of SERIALIZABLE. This value is used to set the TransactionIsolation level in the $connectionOptions array passed to `sqlsrv_connect`.',
'SQLSRV_TXN_READ_UNCOMMITTED' => 'Indicates a transaction isolation level of READ UNCOMMITTED. This value is used to set the TransactionIsolation level in the $connectionOptions array passed to `sqlsrv_connect`.',
'SQLSRV_TXN_REPEATABLE_READ' => 'Indicates a transaction isolation level of REPEATABLE READ. This value is used to set the TransactionIsolation level in the $connectionOptions array passed to `sqlsrv_connect`.',
'SQLSRV_TXN_SNAPSHOT' => 'Indicates a transaction isolation level of SNAPSHOT. This value is used to set the TransactionIsolation level in the $connectionOptions array passed to `sqlsrv_connect`.',
'SQLTEXT' => 'Indicates the \'`TEXT`\' type in MSSQL, used by `mssql_bind`\'s `type` parameter.',
'SQLVARCHAR' => 'Indicates the \'`VARCHAR`\' type in MSSQL, used by `mssql_bind`\'s `type` parameter.',
'SSH2_DEFAULT_TERM_HEIGHT' => 'Default terminal height requested by `ssh2_shell`.',
'SSH2_DEFAULT_TERM_UNIT' => 'Default terminal units requested by `ssh2_shell`.',
'SSH2_DEFAULT_TERM_WIDTH' => 'Default terminal width requested by `ssh2_shell`.',
'SSH2_DEFAULT_TERMINAL' => 'Default terminal type (e.g. vt102, ansi, xterm, vanilla) requested by `ssh2_shell`.',
'SSH2_FINGERPRINT_HEX' => 'Flag to `ssh2_fingerprint` requesting hostkey fingerprint as a string of hexits.',
'SSH2_FINGERPRINT_MD5' => 'Flag to `ssh2_fingerprint` requesting hostkey fingerprint as an MD5 hash.',
'SSH2_FINGERPRINT_RAW' => 'Flag to `ssh2_fingerprint` requesting hostkey fingerprint as a raw string of 8-bit characters.',
'SSH2_FINGERPRINT_SHA1' => 'Flag to `ssh2_fingerprint` requesting hostkey fingerprint as an SHA1 hash.',
'SSH2_STREAM_STDERR' => 'Flag to `ssh2_fetch_stream` requesting STDERR subchannel.',
'SSH2_STREAM_STDIO' => 'Flag to `ssh2_fetch_stream` requesting STDIO subchannel.',
'SSH2_TERM_UNIT_CHARS' => 'Flag to `ssh2_shell` specifying that width and height are provided as character sizes.',
'SSH2_TERM_UNIT_PIXELS' => 'Flag to `ssh2_shell` specifying that width and height are provided in pixel units.',
'ST_UID' => 'The sequence argument contains UIDs instead of sequence numbers',
'STDERR' => 'An already opened stream to *stderr* (standard error).',
'STDIN' => 'An already opened stream to *stdin* (standard input).',
'STDOUT' => 'An already opened stream to *stdout* (standard output).',
'SUNFUNCS_RET_DOUBLE' => 'Hours as floating point number (example 8.75)',
'SUNFUNCS_RET_STRING' => 'Hours:minutes (example: 08:02)',
'SUNFUNCS_RET_TIMESTAMP' => 'Timestamp',
'SVN_AUTH_PARAM_DEFAULT_PASSWORD' => 'Property for default password to use when performing basic authentication',
'SVN_AUTH_PARAM_DEFAULT_USERNAME' => 'Property for default username to use when performing basic authentication',
'SVN_FS_CONFIG_FS_TYPE' => 'Configuration key that determines filesystem type',
'SVN_FS_TYPE_BDB' => 'Filesystem is Berkeley-DB implementation',
'SVN_FS_TYPE_FSFS' => 'Filesystem is native-filesystem implementation',
'SVN_NODE_DIR' => 'Directory',
'SVN_NODE_FILE' => 'File',
'SVN_NODE_NONE' => 'Absent',
'SVN_NODE_UNKNOWN' => 'Something Subversion cannot identify',
'SVN_PROP_REVISION_AUTHOR' => 'svn:author',
'SVN_PROP_REVISION_DATE' => 'svn:date',
'SVN_PROP_REVISION_LOG' => 'svn:log',
'SVN_PROP_REVISION_ORIG_DATE' => 'svn:original-date',
'SVN_REVISION_HEAD' => 'Magic number (-1) specifying the HEAD revision',
'SVN_WC_STATUS_ADDED' => 'Item is scheduled for addition',
'SVN_WC_STATUS_CONFLICTED' => 'Item\'s local modifications conflicted with repository modifications',
'SVN_WC_STATUS_DELETED' => 'Item is scheduled for deletion',
'SVN_WC_STATUS_EXTERNAL' => 'Unversioned path that is populated using svn:externals',
'SVN_WC_STATUS_IGNORED' => 'Item is unversioned but configured to be ignored',
'SVN_WC_STATUS_INCOMPLETE' => 'Directory does not contain complete entries list',
'SVN_WC_STATUS_MERGED' => 'Item\'s local modifications were merged with repository modifications',
'SVN_WC_STATUS_MISSING' => 'Item is versioned but missing from the working copy',
'SVN_WC_STATUS_MODIFIED' => 'Item (text or properties) was modified',
'SVN_WC_STATUS_NONE' => 'Status does not exist',
'SVN_WC_STATUS_NORMAL' => 'Item exists, nothing else is happening',
'SVN_WC_STATUS_OBSTRUCTED' => 'Unversioned item is in the way of a versioned resource',
'SVN_WC_STATUS_REPLACED' => 'Item was deleted and then re-added',
'SVN_WC_STATUS_UNVERSIONED' => 'Item is not versioned in working copy',
'TCP_NODELAY' => 'Used to disable Nagle TCP algorithm. Added in PHP 5.2.7.',
'TRAP_BRKPT' => 'Available since PHP 5.3.0.',
'TRAP_TRACE' => 'Available since PHP 5.3.0.',
'TYPEAPPLICATION' => 'Primary body type: application data',
'TYPEAUDIO' => 'Primary body type: audio',
'TYPEIMAGE' => 'Primary body type: static image',
'TYPEMESSAGE' => 'Primary body type: encapsulated message',
'TYPEMODEL' => 'Primary body type: model',
'TYPEMULTIPART' => 'Primary body type: multiple part',
'TYPEOTHER' => 'Primary body type: unknown',
'TYPETEXT' => 'Primary body type: unformatted text',
'TYPEVIDEO' => 'Primary body type: video',
'UTF-8' => 'Specifies that data is returned with UTF-8 encoding. For usage information, see How to: Specify PHP Types.',
'XATTR_CREATE' => 'Function will fail if extended attribute already exists.',
'XATTR_DONTFOLLOW' => 'Do not follow the symbolic link but operate on symbolic link itself.',
'XATTR_REPLACE' => 'Function will fail if extended attribute doesn\'t exist.',
'XATTR_ROOT' => 'Set attribute in root (trusted) namespace. Requires root privileges.',
'XDIFF_PATCH_NORMAL' => 'This flag indicates that `xdiff_string_patch` and `xdiff_file_patch` functions should create result by applying patch to original content thus creating newer version of file. This is the default mode of operation.',
'XDIFF_PATCH_REVERSE' => 'This flag indicated that `xdiff_string_patch` and `xdiff_file_patch` functions should create result by reversing patch changed from newer content thus creating original version.',
'XHPROF_FLAGS_CPU' => 'Used to add CPU profiling information to the output.',
'XHPROF_FLAGS_MEMORY' => 'Used to add memory profiling information to the output.',
'XHPROF_FLAGS_NO_BUILTINS' => 'Used to skip all built-in (internal) functions.',
'XML_SAX_IMPL' => 'Holds the SAX implementation method. Can be `libxml` or `expat`.',
'XSL_SECPREF_CREATE_DIRECTORY' => 'Disallows creating directories.',
'XSL_SECPREF_DEFAULT' => 'Disallows all write access, i.e. a bitmask of `XSL_SECPREF_WRITE_NETWORK` | `XSL_SECPREF_CREATE_DIRECTORY` | `XSL_SECPREF_WRITE_FILE`.',
'XSL_SECPREF_NONE' => 'Deactivate all security restrictions.',
'XSL_SECPREF_READ_FILE' => 'Disallows reading files.',
'XSL_SECPREF_READ_NETWORK' => 'Disallows reading network files.',
'XSL_SECPREF_WRITE_FILE' => 'Disallows writing files.',
'XSL_SECPREF_WRITE_NETWORK' => 'Disallows writing network files.',
'YAC_MAX_KEY_LEN' => 'Max length of a key could be, it is 48 bytes.',
'YAC_SERIALIZER' => 'Which serialzier is yac used',
'YAC_SERIALIZER_IGBINARY' => 'Use igbinary as serializer(require --enable-igbinary)',
'YAC_SERIALIZER_JSON' => 'Use json as serializer(requrie --enable-json)',
'YAC_SERIALIZER_MSGPACK' => 'Use msgpack as serializer(require --enable-msgpack)',
'YAC_SERIALIZER_PHP' => 'Use php serialize as serializer',
'YAML_ANY_BREAK' => 'Let emitter choose linebreak character.',
'YAML_ANY_ENCODING' => 'Let the emitter choose an encoding.',
'YAML_BOOL_TAG' => '"tag:yaml.org,2002:bool"',
'YAML_CR_BREAK' => 'Use `\r` as break character (Mac style).',
'YAML_CRLN_BREAK' => 'Use `\r\n` as break character (DOS style).',
'YAML_FLOAT_TAG' => '"tag:yaml.org,2002:float"',
'YAML_INT_TAG' => '"tag:yaml.org,2002:int"',
'YAML_LN_BREAK' => 'Use `\n` as break character (Unix style).',
'YAML_MAP_TAG' => '"tag:yaml.org,2002:map"',
'YAML_NULL_TAG' => '"tag:yaml.org,2002:null"',
'YAML_PHP_TAG' => '"!php/object"',
'YAML_SEQ_TAG' => '"tag:yaml.org,2002:seq"',
'YAML_STR_TAG' => '"tag:yaml.org,2002:str"',
'YAML_TIMESTAMP_TAG' => '"tag:yaml.org,2002:timestamp"',
'YAML_UTF16BE_ENCODING' => 'Encode as UTF16BE.',
'YAML_UTF16LE_ENCODING' => 'Encode as UTF16LE.',
'YAML_UTF8_ENCODING' => 'Encode as UTF8.',
'YAR_OPT_HEADER' => 'Since 2.0.4',
'YPERR_ACCESS' => 'access violation (this has only been added recently and is only available from PECL SVN for now)',
'YPERR_BADARGS' => 'The function arguments are bad',
'YPERR_BADDB' => 'YP database is bad',
'YPERR_BUSY' => 'Database busy',
'YPERR_DOMAIN' => 'cannot bind to server in this domain',
'YPERR_KEY' => 'no such key in map',
'YPERR_MAP' => 'no such map in server\'s domain',
'YPERR_NODOM' => 'Local domain name not set',
'YPERR_NOMORE' => 'No more records in map database',
'YPERR_PMAP' => 'Can\'t communicate with portmapper',
'YPERR_RESRC' => 'resource allocation failure',
'YPERR_RPC' => 'RPC failure - domain has been unbound',
'YPERR_VERS' => 'YP version mismatch',
'YPERR_YPBIND' => 'Can\'t communicate with ypbind',
'YPERR_YPERR' => 'internal yp server or client error',
'YPERR_YPSERV' => 'Can\'t communicate with ypserv',
'ZEND_ACC_ABSTRACT' => 'Mark function as abstract',
'ZEND_ACC_CLASS' => 'Dummy registered for consistency, the default kind of class entry. Removed as of uopz 5.0.0.',
'ZEND_ACC_FETCH' => 'Used for getting flags only. Removed as of uopz 5.0.0.',
'ZEND_ACC_FINAL' => 'Mark function as final',
'ZEND_ACC_INTERFACE' => 'Mark class as interface. Removed as of uopz 5.0.0.',
'ZEND_ACC_PRIVATE' => 'Mark function as private',
'ZEND_ACC_PROTECTED' => 'Mark function as protected',
'ZEND_ACC_PUBLIC' => 'Mark function as public, the default',
'ZEND_ACC_STATIC' => 'Mark function as static',
'ZEND_ACC_TRAIT' => 'Mark class as trait. Removed as of uopz 5.0.0.',
'ZEND_ADD_INTERFACE' => 'Invoked upon composure, receives the class the interface is being added to as the first argument, and the name of the interface as the second argument',
'ZEND_ADD_TRAIT' => 'Invoked upon composure, receives the class the trait is being added to as the first argument, and the name of the trait as the second argument',
'ZEND_EXIT' => 'Invoked by exit() and die(), receives no arguments. Return boolean `true` to exit, `false` to continue',
'ZEND_FETCH_CLASS' => 'Invoked upon composure, receives the class the name of the class being fetched as the only argument',
'ZEND_INSTANCEOF' => 'Invoked by instanceof operator, receives the object being verified as the first argument, and the name of the class which that object should be as the second argument',
'ZEND_NEW' => 'Invoked by object construction, receives the class of object being created as the only argument',
'ZEND_THROW' => 'Invoked by the throw construct, receives the class of exception being thrown as the only argument',
'ZEND_USER_OPCODE_CONTINUE' => 'Advance 1 opcode and continuue',
'ZEND_USER_OPCODE_DISPATCH' => 'Dispatch to original opcode handler',
'ZEND_USER_OPCODE_DISPATCH_TO' => 'Dispatch to a specific handler (OR\'d with ZEND opcode constant)',
'ZEND_USER_OPCODE_ENTER' => 'Enter into new op_array without recursion',
'ZEND_USER_OPCODE_LEAVE' => 'Return to calling op_array within the same executor',
'ZEND_USER_OPCODE_RETURN' => 'Exit from executor (return from function)',
'ZipArchive::CHECKCONS' => 'Perform additional consistency checks on the archive, and error if they fail.',
'ZipArchive::CM_BZIP2' => 'BZIP2 algorithm',
'ZipArchive::CM_DEFAULT' => 'better of deflate or store.',
'ZipArchive::CM_DEFLATE' => 'deflated',
'ZipArchive::CM_DEFLATE64' => 'deflate64',
'ZipArchive::CM_IMPLODE' => 'imploded',
'ZipArchive::CM_LZMA' => 'LZMA algorithm',
'ZipArchive::CM_LZMA2' => 'LZMA2 algorithm. Available as of PHP 7.4.3 and PECL zip 1.16.0, respectively, if built against libzip ≥ 1.6.0.',
'ZipArchive::CM_PKWARE_IMPLODE' => 'PKWARE imploding',
'ZipArchive::CM_REDUCE_1' => 'reduced with factor 1',
'ZipArchive::CM_REDUCE_2' => 'reduced with factor 2',
'ZipArchive::CM_REDUCE_3' => 'reduced with factor 3',
'ZipArchive::CM_REDUCE_4' => 'reduced with factor 4',
'ZipArchive::CM_SHRINK' => 'shrunk',
'ZipArchive::CM_STORE' => 'stored (uncompressed).',
'ZipArchive::CM_XZ' => 'XZ algorithm. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively, if built against libzip ≥ 1.6.0.',
'ZipArchive::CREATE' => 'Create the archive if it does not exist.',
'ZipArchive::EM_AES_128' => 'AES 128 encryption, since PHP 7.2.0, PECL zip 1.14.0',
'ZipArchive::EM_AES_192' => 'AES 1192 encryption, since PHP 7.2.0, PECL zip 1.14.0',
'ZipArchive::EM_AES_256' => 'AES 256 encryption, since PHP 7.2.0, PECL zip 1.14.0',
'ZipArchive::EM_NONE' => 'No encryption, since PHP 7.2.0, PECL zip 1.14.0',
'ZipArchive::ER_CANCELLED' => 'Operation cancelled. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively, if built against libzip ≥ 1.6.0.',
'ZipArchive::ER_CHANGED' => 'Entry has been changed',
'ZipArchive::ER_CLOSE' => 'Closing zip archive failed',
'ZipArchive::ER_COMPNOTSUPP' => 'Compression method not supported.',
'ZipArchive::ER_CRC' => 'CRC error',
'ZipArchive::ER_DELETED' => 'Entry has been deleted',
'ZipArchive::ER_ENCRNOTSUPP' => 'Encryption method not supported. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively.',
'ZipArchive::ER_EOF' => 'Premature EOF',
'ZipArchive::ER_EXISTS' => 'File already exists',
'ZipArchive::ER_INCONS' => 'Zip archive inconsistent',
'ZipArchive::ER_INTERNAL' => 'Internal error',
'ZipArchive::ER_INVAL' => 'Invalid argument',
'ZipArchive::ER_MEMORY' => 'Memory allocation failure',
'ZipArchive::ER_MULTIDISK' => 'Multi-disk zip archives not supported.',
'ZipArchive::ER_NOENT' => 'No such file.',
'ZipArchive::ER_NOPASSWD' => 'No password provided. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively.',
'ZipArchive::ER_NOZIP' => 'Not a zip archive',
'ZipArchive::ER_OK' => 'No error.',
'ZipArchive::ER_OPEN' => 'Can\'t open file',
'ZipArchive::ER_RDONLY' => 'Read-only archive. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively.',
'ZipArchive::ER_READ' => 'Read error',
'ZipArchive::ER_REMOVE' => 'Can\'t remove file',
'ZipArchive::ER_RENAME' => 'Renaming temporary file failed.',
'ZipArchive::ER_SEEK' => 'Seek error',
'ZipArchive::ER_TMPOPEN' => 'Failure to create temporary file.',
'ZipArchive::ER_WRITE' => 'Write error',
'ZipArchive::ER_WRONGPASSWD' => 'Wrong password provided. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively.',
'ZipArchive::ER_ZIPCLOSED' => 'Containing zip archive was closed',
'ZipArchive::ER_ZLIB' => 'Zlib error',
'ZipArchive::EXCL' => 'Error if archive already exists.',
'ZipArchive::FL_COMPRESSED' => 'Read compressed data',
'ZipArchive::FL_ENC_CP437' => 'String is CP437 encoded. Available as of PHP 7.0.8.',
'ZipArchive::FL_ENC_GUESS' => 'Guess string encoding (is default). Available as of PHP 7.0.8.',
'ZipArchive::FL_ENC_RAW' => 'Get unmodified string. Available as of PHP 7.0.8.',
'ZipArchive::FL_ENC_STRICT' => 'Follow specification strictly. Available as of PHP 7.0.8.',
'ZipArchive::FL_ENC_UTF_8' => 'String is UTF-8 encoded. Available as of PHP 7.0.8.',
'ZipArchive::FL_ENCRYPTED' => 'Read encrypted data (implies FL_COMPRESSED). Available as of PHP 8.0.0 and PECL zip 1.18.0.',
'ZipArchive::FL_LOCAL' => 'In local header. Available as of PHP 8.0.0 and PECL zip 1.18.0.',
'ZipArchive::FL_NOCASE' => 'Ignore case on name lookup',
'ZipArchive::FL_NODIR' => 'Ignore directory component',
'ZipArchive::FL_OVERWRITE' => 'If file with name exists, overwrite (replace) it. Available as of PHP 8.0.0 and PECL zip 1.18.0.',
'ZipArchive::FL_RECOMPRESS' => 'Force recompression of data. Available as of PHP 8.0.0 and PECL zip 1.18.0.',
'ZipArchive::FL_UNCHANGED' => 'Use original data, ignoring changes.',
'ZipArchive::LIBZIP_VERSION' => 'Zip library version. Available as of PHP 7.4.3 and PECL zip 1.16.0.',
'ZipArchive::OPSYS_DOS' => 'Since PHP 5.6.0, PECL zip 1.12.4',
'ZipArchive::OVERWRITE' => 'If archive exists, ignore its current contents. In other words, handle it the same way as an empty archive.',
'ZipArchive::RDONLY' => 'Open archive in read only mode. Available as of PHP 7.4.3 and PECL zip 1.17.1, respectively, if built against libzip ≥ 1.0.0.',
'ZipArchive::ZIP_ER_COMPRESSED_DATA' => 'Compressed data invalid. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively, if built against libzip ≥ 1.6.0.',
'ZipArchive::ZIP_ER_INUSE' => 'Resource still in use. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively, if built against libzip ≥ 1.0.0.',
'ZipArchive::ZIP_ER_OPNOTSUPP' => 'Operation not supported. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively, if built against libzip ≥ 1.0.0.',
'ZipArchive::ZIP_ER_TELL' => 'Tell error. Available as of PHP 7.4.3 and PECL zip 1.16.1, respectively, if built against libzip ≥ 1.0.0.',
'ZipArchive::ZIP_FL_CENTRAL' => 'In central directory. Available as of PHP 8.0.0 and PECL zip 1.18.0.',
'ZLIB_BLOCK' => 'Available as of PHP 7.0.0.',
'ZLIB_DEFAULT_STRATEGY' => 'Available as of PHP 7.0.0.',
'ZLIB_ENCODING_DEFLATE' => 'ZLIB compression algorithm as per RFC 1950. Available as of PHP 7.0.0.',
'ZLIB_ENCODING_GZIP' => 'GZIP algorithm as per RFC 1952. Available as of PHP 7.0.0.',
'ZLIB_ENCODING_RAW' => 'DEFLATE algorithm as per RFC 1951. Available as of PHP 7.0.0.',
'ZLIB_FILTERED' => 'Available as of PHP 7.0.0.',
'ZLIB_FINISH' => 'Available as of PHP 7.0.0.',
'ZLIB_FIXED' => 'Available as of PHP 7.0.0.',
'ZLIB_FULL_FLUSH' => 'Available as of PHP 7.0.0.',
'ZLIB_HUFFMAN_ONLY' => 'Available as of PHP 7.0.0.',
'ZLIB_NO_FLUSH' => 'Available as of PHP 7.0.0.',
'ZLIB_PARTIAL_FLUSH' => 'Available as of PHP 7.0.0.',
'ZLIB_RLE' => 'Available as of PHP 7.0.0.',
'ZLIB_SYNC_FLUSH' => 'Available as of PHP 7.0.0.',
'ZMQ::CTXOPT_MAX_SOCKETS' => 'The socket limit for this context.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::DEVICE_FORWARDER' => 'Forwarder device',
'ZMQ::DEVICE_QUEUE' => 'Queue device',
'ZMQ::DEVICE_STREAMER' => 'Streamer device',
'ZMQ::ERR_EAGAIN' => 'Implies that the operation would block when ZMQ::MODE_DONTWAIT is used',
'ZMQ::ERR_EFSM' => 'The operation can not be executed because the socket is not in correct state',
'ZMQ::ERR_ENOTSUP' => 'The operation is not supported by the socket type',
'ZMQ::ERR_ETERM' => 'The context has been terminated',
'ZMQ::ERR_INTERNAL' => 'ZMQ extension internal error',
'ZMQ::MODE_DONTWAIT' => 'Non-blocking operation',
'ZMQ::MODE_NOBLOCK' => 'Non-blocking operation.',
'ZMQ::MODE_SNDMORE' => 'Send multi-part message',
'ZMQ::POLL_IN' => 'Poll for incoming data',
'ZMQ::POLL_OUT' => 'Poll for outgoing data',
'ZMQ::SOCKET_DEALER' => 'Extended REQ socket that load balances to all connected peers',
'ZMQ::SOCKET_PAIR' => 'Exclusive pair pattern',
'ZMQ::SOCKET_PUB' => 'Publisher socket',
'ZMQ::SOCKET_PULL' => 'Pipeline downstream pull socket',
'ZMQ::SOCKET_PUSH' => 'Pipeline upstream push socket',
'ZMQ::SOCKET_REP' => 'Reply socket',
'ZMQ::SOCKET_REQ' => 'Request socket',
'ZMQ::SOCKET_ROUTER' => 'Extended REP socket that can route replies to requesters',
'ZMQ::SOCKET_STREAM' => 'Used to send and receive TCP data from a non-ØMQ peer.
Available if compiled against ZeroMQ 4.x or higher.',
'ZMQ::SOCKET_SUB' => 'Subscriber socket',
'ZMQ::SOCKET_XPUB' => 'Similar to SOCKET_PUB, except you can receive subscriptions as messages.
The subscription message is 0 (unsubscribe) or 1 (subscribe) followed by the topic.',
'ZMQ::SOCKET_XREP' => 'Alias for SOCKET_ROUTER',
'ZMQ::SOCKET_XREQ' => 'Alias for SOCKET_DEALER',
'ZMQ::SOCKET_XSUB' => 'Similar to SOCKET_SUB, except you can send subscriptions as messages. See SOCKET_XPUB for format.',
'ZMQ::SOCKOPT_AFFINITY' => 'Set I/O thread affinity',
'ZMQ::SOCKOPT_BACKLOG' => 'The SOCKOPT_BACKLOG option shall set the maximum length of the queue of outstanding peer connections
for the specified socket; this only applies to connection-oriented transports.',
'ZMQ::SOCKOPT_DELAY_ATTACH_ON_CONNECT' => 'Set a CIDR string to match against incoming TCP connections.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_HWM' => 'The high water mark for inbound and outbound messages is a hard
limit on the maximum number of outstanding messages ØMQ shall queue in memory
for any single peer that the specified socket is communicating with.
Setting this option on a socket will only affect connections made after the option has been set.
On ZeroMQ 3.x this is a wrapper for setting both SNDHWM and RCVHWM.',
'ZMQ::SOCKOPT_IDENTITY' => 'Set socket identity',
'ZMQ::SOCKOPT_IPV4ONLY' => 'Disable IPV6 support if 1.
Available if compiled against ZeroMQ 3.x',
'ZMQ::SOCKOPT_IPV6' => 'Enable IPV6.
Available if compiled against ZeroMQ 4.0 or higher',
'ZMQ::SOCKOPT_LAST_ENDPOINT' => 'Retrieve the last connected endpoint - for use with * wildcard ports.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_LINGER' => 'The linger value of the socket.
Specifies how long the socket blocks trying flush messages after it has been closed',
'ZMQ::SOCKOPT_MAXMSGSIZE' => 'Limits the maximum size of the inbound message. Value -1 means no limit.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_MCAST_LOOP' => 'Control multicast loopback (Value: int >= 0)',
'ZMQ::SOCKOPT_RATE' => 'Set rate for multicast sockets (pgm) (Value: int >= 0)',
'ZMQ::SOCKOPT_RCVBUF' => 'Set kernel receive buffer size (Value: int >= 0)',
'ZMQ::SOCKOPT_RCVHWM' => 'The ZMQ_SNDHWM option shall set the high water mark for inbound messages on the specified socket.
Available if compiled against ZeroMQ 3.x or higher.',
'ZMQ::SOCKOPT_RCVMORE' => 'Receive multi-part messages',
'ZMQ::SOCKOPT_RCVTIMEO' => 'Sets the timeout for receive operation on the socket. Value -1 means no limit.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_RECONNECT_IVL' => 'Set the initial reconnection interval (Value: int >= 0)',
'ZMQ::SOCKOPT_RECONNECT_IVL_MAX' => 'Set the max reconnection interval (Value: int >= 0)',
'ZMQ::SOCKOPT_RECOVERY_IVL' => 'Set multicast recovery interval (Value: int >= 0)',
'ZMQ::SOCKOPT_ROUTER_RAW' => 'Sets the raw mode on the ROUTER, when set to 1.
In raw mode when using tcp:// transport the socket will read and write without ZeroMQ framing.
Available if compiled against ZeroMQ 4.0 or higher',
'ZMQ::SOCKOPT_SNDBUF' => 'Set kernel transmit buffer size (Value: int >= 0)',
'ZMQ::SOCKOPT_SNDHWM' => 'The ZMQ_SNDHWM option shall set the high water mark for outbound messages on the specified socket.
Available if compiled against ZeroMQ 3.x or higher.',
'ZMQ::SOCKOPT_SNDTIMEO' => 'Sets the timeout for send operation on the socket. Value -1 means no limit.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_SUBSCRIBE' => 'Establish message filter. Valid for subscriber socket',
'ZMQ::SOCKOPT_TCP_ACCEPT_FILTER' => 'Set a CIDR string to match against incoming TCP connections.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_TCP_KEEPALIVE_CNT' => 'Count time for TCP keepalive.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_TCP_KEEPALIVE_IDLE' => 'Idle time for TCP keepalive.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_TCP_KEEPALIVE_INTVL' => 'Interval for TCP keepalive.
Available if compiled against ZeroMQ 3.x or higher',
'ZMQ::SOCKOPT_TYPE' => 'Get the socket type. Valid for getSockOpt',
'ZMQ::SOCKOPT_UNSUBSCRIBE' => 'Remove message filter. Valid for subscriber socket',
'ZMQ::SOCKOPT_XPUB_VERBOSE' => 'Set the XPUB to receive an application message on each instance of a subscription.
Available if compiled against ZeroMQ 3.x or higher',
];
